/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.ev.Event;
import sba.sl.ev.EventExecutionOrder;
import sba.sl.ev.EventManager;
import sba.sl.ev.HandlerRegisteredEvent;

public abstract class AbstractBukkitEventHandlerFactory<T extends org.bukkit.event.Event, SE extends Event>
implements Listener {
    @NotNull
    protected static final @NotNull Map<@NotNull EventExecutionOrder, EventPriority> EVENT_PRIORITY_TRANSLATION_MAP = Map.of(EventExecutionOrder.FIRST, EventPriority.LOWEST, EventExecutionOrder.EARLY, EventPriority.LOW, EventExecutionOrder.NORMAL, EventPriority.NORMAL, EventExecutionOrder.LATE, EventPriority.HIGH, EventExecutionOrder.LAST, EventPriority.HIGHEST, EventExecutionOrder.MONITOR, EventPriority.MONITOR);
    @NotNull
    protected final @NotNull Map<@NotNull EventExecutionOrder, EventExecutor> eventMap = new HashMap<EventExecutionOrder, EventExecutor>();
    protected final boolean fireAsync;
    protected final boolean checkOnlySameNotChildren;
    @NotNull
    protected final Class<SE> eventClass;
    @NotNull
    protected final Class<T> platformEventClass;

    public AbstractBukkitEventHandlerFactory(@NotNull Class<T> platformEventClass, @NotNull Class<SE> eventClass, @NotNull Plugin plugin) {
        this(platformEventClass, eventClass, plugin, false);
    }

    public AbstractBukkitEventHandlerFactory(@NotNull Class<T> platformEventClass, @NotNull Class<SE> eventClass, @NotNull Plugin plugin, boolean fireAsync) {
        this(platformEventClass, eventClass, plugin, fireAsync, false);
    }

    public AbstractBukkitEventHandlerFactory(@NotNull Class<T> platformEventClass, @NotNull Class<SE> eventClass, @NotNull Plugin plugin, boolean fireAsync, boolean checkOnlySameNotChildren) {
        this.eventClass = eventClass;
        this.platformEventClass = platformEventClass;
        this.fireAsync = fireAsync;
        this.checkOnlySameNotChildren = checkOnlySameNotChildren;
        Objects.requireNonNull(EventManager.getDefaultEventManager()).register(HandlerRegisteredEvent.class, handlerRegisteredEvent -> {
            if (handlerRegisteredEvent.getEventManager() != EventManager.getDefaultEventManager()) {
                return;
            }
            if (!this.eventClass.isAssignableFrom(handlerRegisteredEvent.getEventClass())) {
                return;
            }
            EventExecutionOrder priority = handlerRegisteredEvent.getHandler().getExecutionOrder();
            if (!this.eventMap.containsKey((Object)priority)) {
                EventExecutor handler = (listener, event) -> {
                    if (checkOnlySameNotChildren ? !platformEventClass.equals(event.getClass()) : !platformEventClass.isInstance(event)) {
                        return;
                    }
                    SE wrapped = this.wrapEvent(event, priority);
                    if (wrapped == null) {
                        return;
                    }
                    if (this.fireAsync) {
                        try {
                            EventManager.getDefaultEventManager().fireEventAsync(wrapped, priority).get();
                        }
                        catch (Throwable throwable) {
                            throw new EventException(throwable);
                        }
                    }
                    try {
                        EventManager.getDefaultEventManager().fireEvent(wrapped, priority);
                    }
                    catch (Throwable throwable) {
                        throw new EventException(throwable);
                    }
                };
                this.eventMap.put(handlerRegisteredEvent.getHandler().getExecutionOrder(), handler);
                Bukkit.getPluginManager().registerEvent(this.platformEventClass, (Listener)this, EVENT_PRIORITY_TRANSLATION_MAP.get((Object)priority), handler, plugin);
            }
        });
    }

    @Nullable
    protected abstract SE wrapEvent(@NotNull T var1, @NotNull EventExecutionOrder var2);
}

