/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.entity;

import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.ev.entity.EntityBreedEvent;
import sba.sl.i.ItemStack;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.impl.bukkit.item.BukkitItem;

public class BukkitEntityBreedEvent
implements EntityBreedEvent,
BukkitCancellable {
    @NotNull
    private final org.bukkit.event.entity.EntityBreedEvent event;
    @Nullable
    private Entity entity;
    @Nullable
    private Entity mother;
    @Nullable
    private Entity father;
    @Nullable
    private Entity breeder;
    private boolean breederCached;
    @Nullable
    private ItemStack bredWith;
    private boolean bredWithCached;

    @Override
    @NotNull
    public Entity entity() {
        if (this.entity == null) {
            this.entity = Objects.requireNonNull(Entities.wrapEntity(this.event.getEntity()));
        }
        return this.entity;
    }

    @Override
    @NotNull
    public Entity mother() {
        if (this.mother == null) {
            this.mother = Objects.requireNonNull(Entities.wrapEntity(this.event.getMother()));
        }
        return this.mother;
    }

    @Override
    @NotNull
    public Entity father() {
        if (this.father == null) {
            this.father = Objects.requireNonNull(Entities.wrapEntity(this.event.getFather()));
        }
        return this.father;
    }

    @Override
    @Nullable
    public Entity breeder() {
        if (!this.breederCached) {
            if (this.event.getBreeder() != null) {
                this.breeder = Objects.requireNonNull(Entities.wrapEntity(this.event.getBreeder()));
            }
            this.breederCached = true;
        }
        return this.breeder;
    }

    @Override
    @Nullable
    public ItemStack bredWith() {
        if (!this.bredWithCached) {
            if (this.event.getBredWith() != null) {
                this.bredWith = new BukkitItem(this.event.getBredWith());
            }
            this.bredWithCached = true;
        }
        return this.bredWith;
    }

    @Override
    public int experience() {
        return this.event.getExperience();
    }

    @Override
    public void experience(int experience) {
        this.event.setExperience(experience);
    }

    @Generated
    public BukkitEntityBreedEvent(@NotNull org.bukkit.event.entity.EntityBreedEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitEntityBreedEvent)) {
            return false;
        }
        BukkitEntityBreedEvent other = (BukkitEntityBreedEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        org.bukkit.event.entity.EntityBreedEvent this$event = this.event();
        org.bukkit.event.entity.EntityBreedEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitEntityBreedEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        org.bukkit.event.entity.EntityBreedEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitEntityBreedEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public org.bukkit.event.entity.EntityBreedEvent event() {
        return this.event;
    }
}

