/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.entity;

import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.event.Cancellable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.ev.entity.EntityDeathEvent;
import sba.sl.i.ItemStack;
import sba.sl.impl.bukkit.item.BukkitItem;
import sba.sl.impl.utils.collections.CollectionLinkedToCollection;

public class BukkitEntityDeathEvent
implements EntityDeathEvent {
    @NotNull
    private final org.bukkit.event.entity.EntityDeathEvent event;
    @Nullable
    private Entity entity;
    private @Nullable Collection<@NotNull ItemStack> drops;

    @Override
    @NotNull
    public @NotNull Collection<@NotNull ItemStack> drops() {
        if (this.drops == null) {
            this.drops = new CollectionLinkedToCollection<ItemStack, org.bukkit.inventory.ItemStack>(this.event.getDrops(), item -> item.as(org.bukkit.inventory.ItemStack.class), BukkitItem::new);
        }
        return this.drops;
    }

    @Override
    @NotNull
    public Entity entity() {
        if (this.entity == null) {
            this.entity = Objects.requireNonNull(Entities.wrapEntity(this.event.getEntity()));
        }
        return this.entity;
    }

    @Override
    public int dropExp() {
        return this.event.getDroppedExp();
    }

    @Override
    public void dropExp(int dropExp) {
        this.event.setDroppedExp(dropExp);
    }

    @Override
    public boolean cancelled() {
        if (this.event instanceof Cancellable) {
            return this.event.isCancelled();
        }
        return false;
    }

    @Override
    public void cancelled(boolean cancel) {
        if (this.event instanceof Cancellable) {
            this.event.setCancelled(cancel);
        }
    }

    @Generated
    public BukkitEntityDeathEvent(@NotNull org.bukkit.event.entity.EntityDeathEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitEntityDeathEvent)) {
            return false;
        }
        BukkitEntityDeathEvent other = (BukkitEntityDeathEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        org.bukkit.event.entity.EntityDeathEvent this$event = this.event();
        org.bukkit.event.entity.EntityDeathEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitEntityDeathEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        org.bukkit.event.entity.EntityDeathEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitEntityDeathEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public org.bukkit.event.entity.EntityDeathEvent event() {
        return this.event;
    }
}

