/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.entity;

import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.ev.entity.EntityPotionEffectEvent;
import sba.sl.i.meta.PotionEffect;
import sba.sl.impl.bukkit.event.BukkitCancellable;

public class BukkitEntityPotionEffectEvent
implements EntityPotionEffectEvent,
BukkitCancellable {
    @NotNull
    private final org.bukkit.event.entity.EntityPotionEffectEvent event;
    @Nullable
    private Entity entity;
    @Nullable
    private PotionEffect oldEffect;
    private boolean oldEffectCached;
    @Nullable
    private PotionEffect newEffect;
    private boolean newEffectCached;
    @Nullable
    private EntityPotionEffectEvent.Cause cause;
    @Nullable
    private EntityPotionEffectEvent.Action action;

    @Override
    @NotNull
    public Entity entity() {
        if (this.entity == null) {
            this.entity = Objects.requireNonNull(Entities.wrapEntity(this.event.getEntity()));
        }
        return this.entity;
    }

    @Override
    @Nullable
    public PotionEffect oldEffect() {
        if (!this.oldEffectCached) {
            if (this.event.getOldEffect() != null) {
                this.oldEffect = PotionEffect.of(this.event.getOldEffect());
            }
            this.oldEffectCached = true;
        }
        return this.oldEffect;
    }

    @Override
    @Nullable
    public PotionEffect newEffect() {
        if (!this.newEffectCached) {
            if (this.event.getNewEffect() != null) {
                this.newEffect = PotionEffect.of(this.event.getNewEffect());
            }
            this.newEffectCached = true;
        }
        return this.newEffect;
    }

    @Override
    @NotNull
    public EntityPotionEffectEvent.Cause cause() {
        if (this.cause == null) {
            this.cause = EntityPotionEffectEvent.Cause.valueOf(this.event.getCause().name());
        }
        return this.cause;
    }

    @Override
    @NotNull
    public EntityPotionEffectEvent.Action action() {
        if (this.action == null) {
            this.action = EntityPotionEffectEvent.Action.valueOf(this.event.getAction().name());
        }
        return this.action;
    }

    @Override
    public boolean override() {
        return this.event.isOverride();
    }

    @Override
    public void override(boolean override) {
        this.event.setOverride(override);
    }

    @Generated
    public BukkitEntityPotionEffectEvent(@NotNull org.bukkit.event.entity.EntityPotionEffectEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitEntityPotionEffectEvent)) {
            return false;
        }
        BukkitEntityPotionEffectEvent other = (BukkitEntityPotionEffectEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        org.bukkit.event.entity.EntityPotionEffectEvent this$event = this.event();
        org.bukkit.event.entity.EntityPotionEffectEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitEntityPotionEffectEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        org.bukkit.event.entity.EntityPotionEffectEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitEntityPotionEffectEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public org.bukkit.event.entity.EntityPotionEffectEvent event() {
        return this.event;
    }
}

