/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.player;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.block.BlockState;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.BlockPlacement;
import sba.sl.b.snapshot.BlockSnapshot;
import sba.sl.ev.player.PlayerBlockPlaceEvent;
import sba.sl.i.ItemStack;
import sba.sl.impl.block.snapshot.BlockSnapshots;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.impl.bukkit.item.BukkitItem;
import sba.sl.impl.utils.collections.ImmutableCollectionLinkedToCollection;
import sba.sl.pa.Player;
import sba.sl.sl.EquipmentSlot;

public class BukkitPlayerBlockPlaceEvent
implements PlayerBlockPlaceEvent,
BukkitCancellable {
    @NotNull
    private final BlockPlaceEvent event;
    @Nullable
    private Player player;
    private @Nullable Collection<@NotNull BlockSnapshot> replacedBlockStates;
    @Nullable
    private EquipmentSlot playerHand;
    @Nullable
    private BlockPlacement block;
    @Nullable
    private BlockSnapshot replacedBlockState;
    @Nullable
    private ItemStack itemInHand;

    @Override
    @NotNull
    public @NotNull Collection<@NotNull BlockSnapshot> replacedBlockStates() {
        if (this.replacedBlockStates == null) {
            this.replacedBlockStates = this.event instanceof BlockMultiPlaceEvent ? new ImmutableCollectionLinkedToCollection<BlockSnapshot, BlockState>(((BlockMultiPlaceEvent)this.event).getReplacedBlockStates(), blockStateHolder -> blockStateHolder.as(BlockState.class), blockState -> (BlockSnapshot)Objects.requireNonNull(BlockSnapshots.wrapBlockSnapshot(blockState))) : List.of(this.replacedBlockState());
        }
        return this.replacedBlockStates;
    }

    @Override
    @NotNull
    public EquipmentSlot playerHand() {
        if (this.playerHand == null) {
            this.playerHand = BukkitFeature.OFF_HAND.isSupported() ? EquipmentSlot.of(this.event.getHand()) : EquipmentSlot.of("main_hand");
        }
        return this.playerHand;
    }

    @Override
    @NotNull
    public BlockPlacement block() {
        if (this.block == null) {
            this.block = new BukkitBlockPlacement(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    @NotNull
    public BlockSnapshot replacedBlockState() {
        if (this.replacedBlockState == null) {
            this.replacedBlockState = (BlockSnapshot)Objects.requireNonNull(BlockSnapshots.wrapBlockSnapshot(this.event.getBlockReplacedState()));
        }
        return this.replacedBlockState;
    }

    @Override
    @NotNull
    public ItemStack itemInHand() {
        if (this.itemInHand == null) {
            this.itemInHand = new BukkitItem(this.event.getItemInHand());
        }
        return this.itemInHand;
    }

    @Override
    @NotNull
    public Player player() {
        if (this.player == null) {
            this.player = new BukkitPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Generated
    public BukkitPlayerBlockPlaceEvent(@NotNull BlockPlaceEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitPlayerBlockPlaceEvent)) {
            return false;
        }
        BukkitPlayerBlockPlaceEvent other = (BukkitPlayerBlockPlaceEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockPlaceEvent this$event = this.event();
        BlockPlaceEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitPlayerBlockPlaceEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockPlaceEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitPlayerBlockPlaceEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public BlockPlaceEvent event() {
        return this.event;
    }
}

