/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.player;

import lombok.Generated;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.BlockPlacement;
import sba.sl.ev.player.PlayerBucketEvent;
import sba.sl.i.ItemStack;
import sba.sl.i.ItemType;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.impl.bukkit.item.BukkitItem;
import sba.sl.pa.Player;
import sba.sl.u.BlockFace;

public class BukkitPlayerBucketEvent
implements PlayerBucketEvent,
BukkitCancellable {
    @NotNull
    private final org.bukkit.event.player.PlayerBucketEvent event;
    @Nullable
    private Player player;
    @Nullable
    private BlockPlacement block;
    @Nullable
    private BlockPlacement blockClicked;
    @Nullable
    private BlockFace blockFace;
    @Nullable
    private ItemType bucket;

    @Override
    @NotNull
    public Player player() {
        if (this.player == null) {
            this.player = new BukkitPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    @NotNull
    public BlockPlacement block() {
        if (this.block == null) {
            this.block = new BukkitBlockPlacement(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    @NotNull
    public BlockPlacement blockClicked() {
        if (this.blockClicked == null) {
            this.blockClicked = new BukkitBlockPlacement(this.event.getBlockClicked());
        }
        return this.blockClicked;
    }

    @Override
    @NotNull
    public BlockFace blockFace() {
        if (this.blockFace == null) {
            this.blockFace = BlockFace.valueOf(this.event.getBlockFace().name());
        }
        return this.blockFace;
    }

    @Override
    @NotNull
    public ItemType bucket() {
        if (this.bucket == null) {
            this.bucket = ItemType.of(this.event.getBucket());
        }
        return this.bucket;
    }

    @Override
    @Nullable
    public ItemStack item() {
        return this.event.getItemStack() != null ? new BukkitItem(this.event.getItemStack()) : null;
    }

    @Override
    public void item(@Nullable ItemStack item) {
        this.event.setItemStack(item == null ? null : item.as(org.bukkit.inventory.ItemStack.class));
    }

    @Override
    @NotNull
    public PlayerBucketEvent.Action action() {
        return this.event instanceof PlayerBucketFillEvent ? PlayerBucketEvent.Action.FILL : PlayerBucketEvent.Action.EMPTY;
    }

    @Generated
    public BukkitPlayerBucketEvent(@NotNull org.bukkit.event.player.PlayerBucketEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitPlayerBucketEvent)) {
            return false;
        }
        BukkitPlayerBucketEvent other = (BukkitPlayerBucketEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        org.bukkit.event.player.PlayerBucketEvent this$event = this.event();
        org.bukkit.event.player.PlayerBucketEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitPlayerBucketEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        org.bukkit.event.player.PlayerBucketEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitPlayerBucketEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public org.bukkit.event.player.PlayerBucketEvent event() {
        return this.event;
    }
}

