/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.world;

import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.block.BlockState;
import org.bukkit.event.world.StructureGrowEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.snapshot.BlockSnapshot;
import sba.sl.ev.world.PlantGrowEvent;
import sba.sl.impl.block.snapshot.BlockSnapshots;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.impl.utils.collections.CollectionLinkedToCollection;
import sba.sl.impl.world.Locations;
import sba.sl.pa.Player;
import sba.sl.w.Location;

public class BukkitPlantGrowEvent
implements PlantGrowEvent,
BukkitCancellable {
    @NotNull
    private final StructureGrowEvent event;
    private @Nullable Collection<@NotNull BlockSnapshot> collection;
    @Nullable
    private Location location;
    @Nullable
    private Player player;
    private boolean playerCached;

    @Override
    @NotNull
    public @NotNull Collection<@NotNull BlockSnapshot> blockStates() {
        if (this.collection == null) {
            this.collection = new CollectionLinkedToCollection<BlockSnapshot, BlockState>(this.event.getBlocks(), o -> o.as(BlockState.class), o -> (BlockSnapshot)Objects.requireNonNull(BlockSnapshots.wrapBlockSnapshot(o)));
        }
        return this.collection;
    }

    @Override
    @NotNull
    public Location getLocation() {
        if (this.location == null) {
            this.location = Locations.wrapLocation(this.event.getLocation());
        }
        return this.location;
    }

    @Override
    @Nullable
    public Player player() {
        if (!this.playerCached) {
            if (this.event.getPlayer() != null) {
                this.player = new BukkitPlayer(this.event.getPlayer());
            }
            this.playerCached = true;
        }
        return this.player;
    }

    @Override
    public boolean boneMealed() {
        return this.event.isFromBonemeal();
    }

    @Generated
    public BukkitPlantGrowEvent(@NotNull StructureGrowEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitPlantGrowEvent)) {
            return false;
        }
        BukkitPlantGrowEvent other = (BukkitPlantGrowEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StructureGrowEvent this$event = this.event();
        StructureGrowEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitPlantGrowEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StructureGrowEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitPlantGrowEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public StructureGrowEvent event() {
        return this.event;
    }
}

