/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.spectator;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.spectator.Book;
import sba.sl.spectator.Component;
import sba.sl.u.Preconditions;

public class BukkitBook
implements Book {
    @NotNull
    private final Component title;
    @NotNull
    private final Component author;
    @NotNull
    private final @NotNull List<@NotNull Component> pages;

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type.isInstance(this)) {
            return (T)this;
        }
        throw new UnsupportedOperationException("Bukkit doesn't have any class for books");
    }

    @Override
    @NotNull
    public Object raw() {
        throw new UnsupportedOperationException("Bukkit doesn't have any class for books");
    }

    @Override
    @NotNull
    public Book withTitle(@NotNull Component title) {
        return new BukkitBook(title, this.author, this.pages);
    }

    @Override
    @NotNull
    public Book withAuthor(@NotNull Component author) {
        return new BukkitBook(this.title, author, this.pages);
    }

    @Override
    @NotNull
    public Book withPages(@NotNull List<Component> pages) {
        return new BukkitBook(this.title, this.author, pages);
    }

    @Override
    @NotNull
    public Book withPages(Component ... pages) {
        return new BukkitBook(this.title, this.author, Arrays.asList(pages));
    }

    @Override
    public @NotNull Book.Builder toBuilder() {
        return new BukkitBookBuilder(this.title, this.author, this.pages);
    }

    @Generated
    public BukkitBook(@NotNull Component title, @NotNull Component author, @NotNull @NotNull List<@NotNull Component> pages) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (author == null) {
            throw new NullPointerException("author is marked non-null but is null");
        }
        if (pages == null) {
            throw new NullPointerException("pages is marked non-null but is null");
        }
        this.title = title;
        this.author = author;
        this.pages = pages;
    }

    @Override
    @NotNull
    @Generated
    public Component title() {
        return this.title;
    }

    @Override
    @NotNull
    @Generated
    public Component author() {
        return this.author;
    }

    @Override
    @NotNull
    @Generated
    public @NotNull List<@NotNull Component> pages() {
        return this.pages;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitBook)) {
            return false;
        }
        BukkitBook other = (BukkitBook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Component this$title = this.title();
        Component other$title = other.title();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Component this$author = this.author();
        Component other$author = other.author();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        List<Component> this$pages = this.pages();
        List<Component> other$pages = other.pages();
        return !(this$pages == null ? other$pages != null : !((Object)this$pages).equals(other$pages));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitBook;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Component $title = this.title();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Component $author = this.author();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        List<Component> $pages = this.pages();
        result = result * 59 + ($pages == null ? 43 : ((Object)$pages).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitBook(title=" + String.valueOf(this.title()) + ", author=" + String.valueOf(this.author()) + ", pages=" + String.valueOf(this.pages()) + ")";
    }

    public static class BukkitBookBuilder
    implements Book.Builder {
        @Nullable
        private Component title;
        @Nullable
        private Component author;
        private @Nullable List<@NotNull Component> pages;

        @Override
        @NotNull
        public Book.Builder pages(Component ... pages) {
            this.pages = Arrays.asList(pages);
            return this;
        }

        @Override
        @NotNull
        public Book build() {
            Preconditions.checkNotNull(this.title);
            Preconditions.checkNotNull(this.author);
            Preconditions.checkNotNull(this.pages);
            return new BukkitBook(this.title, this.author, this.pages);
        }

        @Override
        @Generated
        public BukkitBookBuilder title(@Nullable Component title) {
            this.title = title;
            return this;
        }

        @Override
        @Generated
        public BukkitBookBuilder author(@Nullable Component author) {
            this.author = author;
            return this;
        }

        @Override
        @Generated
        public BukkitBookBuilder pages(@Nullable List<@NotNull Component> pages) {
            this.pages = pages;
            return this;
        }

        @Generated
        public BukkitBookBuilder() {
        }

        @Generated
        public BukkitBookBuilder(@Nullable Component title, @Nullable Component author, @Nullable List<@NotNull Component> pages) {
            this.title = title;
            this.author = author;
            this.pages = pages;
        }
    }
}

