/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.tasker;

import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import sba.sl.b.BlockPlacement;
import sba.sl.e.Entity;
import sba.sl.impl.bukkit.tasker.task.FoliaTask;
import sba.sl.t.DefaultThreads;
import sba.sl.t.Tasker;
import sba.sl.t.TaskerTime;
import sba.sl.t.ThreadProperty;
import sba.sl.t.task.Task;
import sba.sl.t.task.TaskBase;
import sba.sl.u.annotations.Service;
import sba.sl.w.Location;
import sba.sl.w.chunk.Chunk;

@Service
public class FoliaTasker
extends Tasker {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final AsyncScheduler asyncScheduler;
    @NotNull
    private final RegionScheduler regionScheduler;
    @NotNull
    private final GlobalRegionScheduler globalRegionScheduler;

    public FoliaTasker(@NotNull Plugin plugin) {
        this.plugin = plugin;
        this.asyncScheduler = plugin.getServer().getAsyncScheduler();
        this.regionScheduler = plugin.getServer().getRegionScheduler();
        this.globalRegionScheduler = plugin.getServer().getGlobalRegionScheduler();
    }

    @Override
    @NotNull
    protected Task run0(@NotNull ThreadProperty property, @NotNull Runnable runnable) {
        if (property == DefaultThreads.ASYNC_THREAD) {
            return new FoliaTask(this.asyncScheduler.runNow(this.plugin, st -> runnable.run()));
        }
        if (property instanceof Entity) {
            return new FoliaTask(Objects.requireNonNull(((Entity)property).as(org.bukkit.entity.Entity.class).getScheduler().run(this.plugin, st -> runnable.run(), null)));
        }
        if (property instanceof BlockPlacement || property instanceof Location || property instanceof Chunk) {
            @NotNull Chunk chunk = property instanceof BlockPlacement ? ((BlockPlacement)property).location().getChunk() : (property instanceof Location ? ((Location)property).getChunk() : (Chunk)property);
            return new FoliaTask(this.regionScheduler.run(this.plugin, chunk.getWorld().as(World.class), chunk.getX(), chunk.getZ(), st -> runnable.run()));
        }
        return new FoliaTask(this.globalRegionScheduler.run(this.plugin, (T st) -> runnable.run()));
    }

    @Override
    @NotNull
    protected Task runDelayed0(@NotNull ThreadProperty property, @NotNull Runnable runnable, long delay, @NotNull TaskerTime delayUnit) {
        if (property == DefaultThreads.ASYNC_THREAD) {
            return new FoliaTask(this.asyncScheduler.runDelayed(this.plugin, (T st) -> runnable.run(), delayUnit.getTime(delay), delayUnit.getTimeUnit()));
        }
        if (property instanceof Entity) {
            return new FoliaTask(Objects.requireNonNull(((Entity)property).as(org.bukkit.entity.Entity.class).getScheduler().runDelayed(this.plugin, (T st) -> runnable.run(), null, delayUnit.getBukkitTime(delay))));
        }
        if (property instanceof BlockPlacement || property instanceof Location || property instanceof Chunk) {
            @NotNull Chunk chunk = property instanceof BlockPlacement ? ((BlockPlacement)property).location().getChunk() : (property instanceof Location ? ((Location)property).getChunk() : (Chunk)property);
            return new FoliaTask(this.regionScheduler.runDelayed(this.plugin, chunk.getWorld().as(World.class), chunk.getX(), chunk.getZ(), st -> runnable.run(), delayUnit.getBukkitTime(delay)));
        }
        return new FoliaTask(this.globalRegionScheduler.runDelayed(this.plugin, (T st) -> runnable.run(), delayUnit.getBukkitTime(delay)));
    }

    @Override
    @NotNull
    protected Task runRepeatedly0(@NotNull ThreadProperty property, @NotNull Runnable runnable, long period, @NotNull TaskerTime periodUnit) {
        return this.runDelayedAndRepeatedly0(property, runnable, 0L, TaskerTime.TICKS, period, periodUnit);
    }

    @Override
    @NotNull
    protected Task runRepeatedly0(@NotNull ThreadProperty property, @NotNull @NotNull Consumer<@NotNull TaskBase> selfCancellable, long period, @NotNull TaskerTime periodUnit) {
        return this.runDelayedAndRepeatedly0(property, selfCancellable, 0L, TaskerTime.TICKS, period, periodUnit);
    }

    @Override
    @NotNull
    protected Task runDelayedAndRepeatedly0(@NotNull ThreadProperty property, @NotNull Runnable runnable, long delay, @NotNull TaskerTime delayUnit, long period, @NotNull TaskerTime periodUnit) {
        if (delay == 0L) {
            delay = 1L;
            delayUnit = TaskerTime.TICKS;
        }
        if (property == DefaultThreads.ASYNC_THREAD) {
            return new FoliaTask(this.asyncScheduler.runAtFixedRate(this.plugin, st -> runnable.run(), periodUnit.getTimeUnit().convert(delayUnit.getTime(delay), delayUnit.getTimeUnit()), periodUnit.getTime(period), periodUnit.getTimeUnit()));
        }
        if (property instanceof Entity) {
            return new FoliaTask(Objects.requireNonNull(((Entity)property).as(org.bukkit.entity.Entity.class).getScheduler().runAtFixedRate(this.plugin, st -> runnable.run(), null, delayUnit.getBukkitTime(delay), periodUnit.getBukkitTime(period))));
        }
        if (property instanceof BlockPlacement || property instanceof Location || property instanceof Chunk) {
            @NotNull Chunk chunk = property instanceof BlockPlacement ? ((BlockPlacement)property).location().getChunk() : (property instanceof Location ? ((Location)property).getChunk() : (Chunk)property);
            return new FoliaTask(this.regionScheduler.runAtFixedRate(this.plugin, chunk.getWorld().as(World.class), chunk.getX(), chunk.getZ(), st -> runnable.run(), delayUnit.getBukkitTime(delay), periodUnit.getBukkitTime(period)));
        }
        return new FoliaTask(this.globalRegionScheduler.runAtFixedRate(this.plugin, st -> runnable.run(), delayUnit.getBukkitTime(delay), periodUnit.getBukkitTime(period)));
    }

    @Override
    @NotNull
    protected Task runDelayedAndRepeatedly0(@NotNull ThreadProperty property, @NotNull @NotNull Consumer<@NotNull TaskBase> selfCancellable, long delay, @NotNull TaskerTime delayUnit, long period, @NotNull TaskerTime periodUnit) {
        if (delay == 0L) {
            delay = 1L;
            delayUnit = TaskerTime.TICKS;
        }
        if (property == DefaultThreads.ASYNC_THREAD) {
            return new FoliaTask(this.asyncScheduler.runAtFixedRate(this.plugin, st -> selfCancellable.accept(() -> ((ScheduledTask)st).cancel()), periodUnit.getTimeUnit().convert(delayUnit.getTime(delay), delayUnit.getTimeUnit()), periodUnit.getTime(period), periodUnit.getTimeUnit()));
        }
        if (property instanceof Entity) {
            return new FoliaTask(Objects.requireNonNull(((Entity)property).as(org.bukkit.entity.Entity.class).getScheduler().runAtFixedRate(this.plugin, st -> selfCancellable.accept(() -> ((ScheduledTask)st).cancel()), null, delayUnit.getBukkitTime(delay), periodUnit.getBukkitTime(period))));
        }
        if (property instanceof BlockPlacement || property instanceof Location || property instanceof Chunk) {
            @NotNull Chunk chunk = property instanceof BlockPlacement ? ((BlockPlacement)property).location().getChunk() : (property instanceof Location ? ((Location)property).getChunk() : (Chunk)property);
            return new FoliaTask(this.regionScheduler.runAtFixedRate(this.plugin, chunk.getWorld().as(World.class), chunk.getX(), chunk.getZ(), st -> selfCancellable.accept(() -> ((ScheduledTask)st).cancel()), delayUnit.getBukkitTime(delay), periodUnit.getBukkitTime(period)));
        }
        return new FoliaTask(this.globalRegionScheduler.runAtFixedRate(this.plugin, st -> selfCancellable.accept(() -> ((ScheduledTask)st).cancel()), delayUnit.getBukkitTime(delay), periodUnit.getBukkitTime(period)));
    }
}

