/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.firework;

import java.lang.reflect.Type;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.BasicConfigurationNode;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.sl.co.FireworkEffectSerializer;
import sba.sl.f.FireworkEffect;
import sba.sl.u.Preconditions;
import sba.sl.u.annotations.ProvidedService;

@ProvidedService
@ApiStatus.Internal
public abstract class FireworkEffectRegistry {
    @Nullable
    private static FireworkEffectRegistry registry;

    public FireworkEffectRegistry() {
        Preconditions.checkArgument(registry == null, "FireworkEffectRegistry is already initialized!");
        registry = this;
    }

    @Nullable
    public static FireworkEffect resolve(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof FireworkEffect) {
            return (FireworkEffect)obj;
        }
        if (obj instanceof ConfigurationNode) {
            try {
                return FireworkEffectSerializer.INSTANCE.deserialize((Type)((Object)FireworkEffect.class), (ConfigurationNode)obj);
            }
            catch (SerializationException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (obj instanceof Map) {
            try {
                return FireworkEffectSerializer.INSTANCE.deserialize((Type)((Object)FireworkEffect.class), BasicConfigurationNode.root().set(obj));
            }
            catch (SerializationException e) {
                e.printStackTrace();
                return null;
            }
        }
        return Preconditions.checkNotNull(registry, "FireworkEffectRegistry is not initialized yet!").resolvePlatform(obj);
    }

    @Nullable
    protected abstract FireworkEffect resolvePlatform(@NotNull Object var1);
}

