/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.utils;

import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.u.Controllable;

public class ControllableImpl
implements Controllable {
    @NotNull
    private final @NotNull List<@NotNull ControllableImpl> controllableList = new LinkedList<ControllableImpl>();
    @Nullable
    private Runnable pluginLoadMethod;
    @Nullable
    private Runnable enableMethod;
    @Nullable
    private Runnable postEnableMethod;
    @Nullable
    private Runnable preDisableMethod;
    @Nullable
    private Runnable disableMethod;

    @Override
    @NotNull
    public Controllable pluginLoad(@NotNull Runnable pluginLoadMethod) {
        this.pluginLoadMethod = pluginLoadMethod;
        return this;
    }

    @Override
    @NotNull
    public Controllable enable(@NotNull Runnable enableMethod) {
        this.enableMethod = enableMethod;
        return this;
    }

    @Override
    @NotNull
    public Controllable postEnable(@NotNull Runnable postEnableMethod) {
        this.postEnableMethod = postEnableMethod;
        return this;
    }

    @Override
    @NotNull
    public Controllable preDisable(@NotNull Runnable preDisableMethod) {
        this.preDisableMethod = preDisableMethod;
        return this;
    }

    @Override
    @NotNull
    public Controllable disable(@NotNull Runnable disableMethod) {
        this.disableMethod = disableMethod;
        return this;
    }

    @Override
    @NotNull
    public Controllable child() {
        ControllableImpl controllable = new ControllableImpl();
        this.controllableList.add(controllable);
        return controllable;
    }

    public void pluginLoad() {
        this.controllableList.forEach(ControllableImpl::pluginLoad);
        if (this.pluginLoadMethod != null) {
            this.pluginLoadMethod.run();
        }
    }

    public void enable() {
        this.controllableList.forEach(ControllableImpl::enable);
        if (this.enableMethod != null) {
            this.enableMethod.run();
        }
    }

    public void postEnable() {
        this.controllableList.forEach(ControllableImpl::postEnable);
        if (this.postEnableMethod != null) {
            this.postEnableMethod.run();
        }
    }

    public void preDisable() {
        if (this.preDisableMethod != null) {
            this.preDisableMethod.run();
        }
        new LinkedList<ControllableImpl>(this.controllableList).descendingIterator().forEachRemaining(ControllableImpl::preDisable);
    }

    public void disable() {
        if (this.disableMethod != null) {
            this.disableMethod.run();
        }
        new LinkedList<ControllableImpl>(this.controllableList).descendingIterator().forEachRemaining(ControllableImpl::disable);
    }

    public void reload() {
        this.preDisable();
        this.disable();
        this.enable();
        this.postEnable();
    }
}

