/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.world.chunk;

import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.types.server.ChunkHolder;
import sba.sl.u.annotations.ProvidedService;
import sba.sl.w.chunk.Chunk;

@ProvidedService
@ApiStatus.Internal
public abstract class Chunks {
    @Nullable
    private static Chunks chunks;

    public Chunks() {
        if (chunks != null) {
            throw new UnsupportedOperationException("Chunks is already initialized.");
        }
        chunks = this;
    }

    @Contract(value="null -> null")
    @Nullable
    public static Chunk wrapChunk(@Nullable Object chunk) {
        if (chunks == null) {
            throw new UnsupportedOperationException("Chunks is not initialized yet.");
        }
        if (chunk instanceof Chunk) {
            return (Chunk)chunk;
        }
        return chunks.wrapChunk0(chunk);
    }

    @Nullable
    protected abstract Chunk wrapChunk0(@Nullable Object var1);

    static {
        ChunkHolder.Provider.registerProvider(o -> Objects.requireNonNull(Chunks.wrapChunk(o), "Cannot wrap " + String.valueOf(o) + " to Chunk"));
    }
}

