/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.npc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import sba.sl.Server;
import sba.sl.e.Entities;
import sba.sl.h.Hologram;
import sba.sl.h.HologramImpl;
import sba.sl.h.HologramManager;
import sba.sl.npc.NPC;
import sba.sl.npc.NPCManager;
import sba.sl.npc.skin.NPCSkin;
import sba.sl.npc.skin.SkinLayerValues;
import sba.sl.p.AbstractPacket;
import sba.sl.p.ClientboundAddPlayerPacket;
import sba.sl.p.ClientboundMoveEntityPacket;
import sba.sl.p.ClientboundPlayerInfoPacket;
import sba.sl.p.ClientboundRemoveEntitiesPacket;
import sba.sl.p.ClientboundRotateHeadPacket;
import sba.sl.p.ClientboundSetPlayerTeamPacket;
import sba.sl.p.ClientboundTeleportEntityPacket;
import sba.sl.p.MetadataItem;
import sba.sl.pa.Player;
import sba.sl.pa.gamemode.GameMode;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.t.DefaultThreads;
import sba.sl.t.Tasker;
import sba.sl.t.TaskerTime;
import sba.sl.t.task.Task;
import sba.sl.u.ProxyType;
import sba.sl.u.visual.TextEntry;
import sba.sl.vi.UpdateStrategy;
import sba.sl.vi.impl.AbstractTouchableVisual;
import sba.sl.w.Location;

public class NPCImpl
extends AbstractTouchableVisual<NPC>
implements NPC {
    @NotNull
    private static final GameMode GAME_MODE = GameMode.of("SURVIVAL");
    private static final boolean IS_BUNGEE = Server.getProxyType() == ProxyType.BUNGEE;
    private final int entityId;
    @NotNull
    private final Hologram hologram;
    @NotNull
    private final String tabName16;
    @NotNull
    private Component tabListName;
    @NotNull
    private final @NotNull List<@NotNull ClientboundPlayerInfoPacket.Property> properties;
    @Nullable
    private NPCSkin skin;
    private volatile boolean lookAtPlayer;
    @NotNull
    private final @NotNull List<@NotNull MetadataItem> metadata;
    private @NotNull ClientboundSetPlayerTeamPacket.CollisionRule collisionRule;
    @NotNull
    private final @NotNull Map<@NotNull UUID, Task> hiderTask;
    private double hologramElevation;

    public NPCImpl(@NotNull UUID uuid, @NotNull Location location, boolean touchable) {
        super(uuid, location, touchable);
        try {
            this.entityId = Entities.getNewEntityIdSynchronously().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.hologramElevation = HologramManager.isPreferDisplayEntities() && HologramImpl.DISPLAY_ENTITIES_AVAILABLE.isSupported() ? 1.7 : 1.5;
        this.tabName16 = "[NPC] " + uuid.toString().replace("-", "").substring(0, 10);
        this.tabListName = Component.fromLegacy(this.tabName16);
        this.hologram = Hologram.of(location.add(0.0, this.hologramElevation, 0.0));
        this.metadata = new ArrayList<MetadataItem>();
        this.properties = new ArrayList<ClientboundPlayerInfoPacket.Property>();
        this.hiderTask = new ConcurrentHashMap<UUID, Task>();
        this.collisionRule = ClientboundSetPlayerTeamPacket.CollisionRule.ALWAYS;
        this.metadata.add(MetadataItem.of((byte)SkinLayerValues.findLayerByVersion(), (byte)127));
    }

    @Override
    @NotNull
    public NPC hologramElevation(double hologramElevation) {
        this.hologramElevation = hologramElevation;
        this.update(UpdateStrategy.POSITION);
        return this;
    }

    @Override
    @NotNull
    public NPC skin(@Nullable NPCSkin skin) {
        this.skin = skin;
        this.properties.removeIf(property -> "textures".equals(property.name()));
        if (skin != null) {
            this.properties.add(new ClientboundPlayerInfoPacket.Property("textures", skin.getValue(), skin.getSignature()));
        }
        if (this.shown()) {
            this.viewers.forEach(this::onViewerRemoved);
            this.viewers.forEach(this::onViewerAdded);
        }
        return this;
    }

    @Override
    public void onViewerAdded(@NotNull Player viewer, boolean checkDistance) {
        if (this.shown() && viewer.isOnline()) {
            this.createSpawnPackets().forEach(packet -> packet.sendPacket(viewer));
            if (!Server.isVersion(1, 19, 3) || viewer.getProtocolVersion() < 761) {
                this.scheduleTabHide(viewer);
            }
        }
    }

    @Override
    public void onViewerRemoved(@NotNull Player viewer, boolean checkDistance) {
        if (viewer.isOnline()) {
            this.createPlayerTeamPacket(ClientboundSetPlayerTeamPacket.Mode.REMOVE).sendPacket(viewer);
            this.createPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.REMOVE_PLAYER).sendPacket(viewer);
            this.removeEntityPacket().sendPacket(viewer);
            this.cancelTabHide(viewer);
        }
    }

    @Override
    public void lookAtLocation(@NotNull Location location, @NotNull Player player) {
        Location direction = this.location().setDirection(player.getLocation().subtract(this.location()).asVector());
        ClientboundMoveEntityPacket.Rot.builder().entityId(this.entityId()).yaw((byte)(direction.getYaw() * 256.0f / 360.0f)).pitch((byte)(direction.getPitch() * 256.0f / 360.0f)).onGround(true).build().sendPacket(player);
        ClientboundRotateHeadPacket.builder().entityId(this.entityId()).headYaw(direction.getYaw()).build().sendPacket(player);
    }

    @Override
    public @Unmodifiable @Nullable List<@NotNull TextEntry> displayName() {
        return List.copyOf(this.hologram.lines().values());
    }

    @Override
    @NotNull
    public NPC displayName(@NotNull @NotNull List<@NotNull Component> name) {
        this.hologram.setLines(name);
        return this;
    }

    @Override
    public boolean hasId(int entityId) {
        return this.entityId == entityId;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public NPC update(@NotNull UpdateStrategy strategy) {
        if (this.shown()) {
            switch (strategy) {
                case POSITION: {
                    this.hologram.location(this.location().add(0.0, 1.5, 0.0));
                    this.hologram.update(UpdateStrategy.POSITION);
                    ClientboundTeleportEntityPacket.builder().location(this.location()).entityId(this.entityId).onGround(true).build().sendPacket(this.viewers());
                    break;
                }
                case ALL: {
                    this.viewers.forEach(this::onViewerRemoved);
                    this.viewers.forEach(this::onViewerAdded);
                    this.hologram.update(UpdateStrategy.ALL);
                }
            }
        }
        return this;
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public NPC show() {
        if (this.visible) {
            return this;
        }
        this.visible = true;
        this.hologram.show();
        this.viewers.forEach(this::onViewerAdded);
        return this;
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public NPC hide() {
        if (!this.visible) {
            return this;
        }
        this.visible = false;
        this.hologram.hide();
        this.viewers.forEach(this::onViewerRemoved);
        return this;
    }

    @Override
    @NotNull
    public NPC addViewer(@NotNull Player viewer) {
        super.addViewer(viewer);
        this.hologram.addViewer(viewer);
        return this;
    }

    @Override
    @NotNull
    public NPC removeViewer(@NotNull Player viewer) {
        super.removeViewer(viewer);
        this.hologram.removeViewer(viewer);
        return this;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.hologram.destroy();
        this.viewers.forEach(this::cancelTabHide);
        this.viewers.clear();
        NPCManager.removeNPC(this);
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public NPC title(@NotNull Component title) {
        this.hologram.title(title);
        return this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public NPC title(@NotNull ComponentLike title) {
        this.hologram.title(title);
        return this;
    }

    private void cancelTabHide(@NotNull Player viewer) {
        this.hiderTask.computeIfPresent(viewer.getUuid(), (uuid, task) -> {
            if (task.isScheduledOrRunning()) {
                task.cancel();
            }
            return null;
        });
    }

    private void scheduleTabHide(@NotNull Player viewer) {
        this.cancelTabHide(viewer);
        Tasker.runDelayed(DefaultThreads.GLOBAL_THREAD, () -> {
            if (!viewer.isOnline()) {
                return;
            }
            ClientboundPlayerInfoPacket.builder().action(ClientboundPlayerInfoPacket.Action.REMOVE_PLAYER).data(this.getNPCInfoData()).build().sendPacket(viewer);
        }, 6L, TaskerTime.SECONDS);
    }

    @NotNull
    private @NotNull List<@NotNull AbstractPacket> createSpawnPackets() {
        ArrayList<AbstractPacket> spawnPackets = new ArrayList<AbstractPacket>();
        if (IS_BUNGEE) {
            spawnPackets.add(this.createPlayerTeamPacket(ClientboundSetPlayerTeamPacket.Mode.REMOVE));
        }
        spawnPackets.add(this.createPlayerTeamPacket(ClientboundSetPlayerTeamPacket.Mode.CREATE));
        spawnPackets.add(this.createPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.ADD_PLAYER));
        spawnPackets.add(ClientboundAddPlayerPacket.builder().entityId(this.entityId).uuid(this.uuid()).location(this.location()).metadata(this.metadata).build());
        spawnPackets.add(ClientboundMoveEntityPacket.Rot.builder().entityId(this.entityId()).yaw((byte)(this.location().getYaw() * 256.0f / 360.0f)).pitch((byte)(this.location().getPitch() * 256.0f / 360.0f)).onGround(true).build());
        spawnPackets.add(ClientboundRotateHeadPacket.builder().entityId(this.entityId()).headYaw(this.location().getYaw()).build());
        return spawnPackets;
    }

    @NotNull
    private ClientboundRemoveEntitiesPacket removeEntityPacket() {
        return ClientboundRemoveEntitiesPacket.builder().entityIds(new int[]{this.entityId()}).build();
    }

    @NotNull
    private ClientboundPlayerInfoPacket createPlayerInfoPacket(@NotNull ClientboundPlayerInfoPacket.Action action) {
        return ClientboundPlayerInfoPacket.builder().action(action).data(this.getNPCInfoData()).build();
    }

    @NotNull
    private ClientboundSetPlayerTeamPacket createPlayerTeamPacket(@NotNull ClientboundSetPlayerTeamPacket.Mode mode) {
        return ClientboundSetPlayerTeamPacket.builder().teamKey(this.tabName16).mode(mode).displayName(this.tabListName).collisionRule(this.collisionRule).tagVisibility(ClientboundSetPlayerTeamPacket.TagVisibility.NEVER).teamColor(ClientboundSetPlayerTeamPacket.TeamColor.BLACK).teamPrefix(Component.empty()).teamSuffix(Component.empty()).friendlyFire(false).seeInvisible(true).entities(Collections.singletonList(this.tabName16)).build();
    }

    @NotNull
    private @NotNull List<@NotNull ClientboundPlayerInfoPacket.PlayerInfoData> getNPCInfoData() {
        return Collections.singletonList(new ClientboundPlayerInfoPacket.PlayerInfoData(this.uuid(), this.tabName16, 1, GAME_MODE, this.tabListName, List.copyOf(this.properties), false));
    }

    @Override
    @Generated
    public int entityId() {
        return this.entityId;
    }

    @Override
    @NotNull
    @Generated
    public Hologram hologram() {
        return this.hologram;
    }

    @NotNull
    @Generated
    public String tabName16() {
        return this.tabName16;
    }

    @Override
    @NotNull
    @Generated
    public Component tabListName() {
        return this.tabListName;
    }

    @Override
    @Nullable
    @Generated
    public NPCSkin skin() {
        return this.skin;
    }

    @Override
    @Generated
    public boolean lookAtPlayer() {
        return this.lookAtPlayer;
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull MetadataItem> metadata() {
        return this.metadata;
    }

    @Override
    @Generated
    public @NotNull ClientboundSetPlayerTeamPacket.CollisionRule collisionRule() {
        return this.collisionRule;
    }

    @NotNull
    @Generated
    public @NotNull Map<@NotNull UUID, Task> hiderTask() {
        return this.hiderTask;
    }

    @Generated
    public double hologramElevation() {
        return this.hologramElevation;
    }

    @Generated
    public NPCImpl tabListName(@NotNull Component tabListName) {
        if (tabListName == null) {
            throw new NullPointerException("tabListName is marked non-null but is null");
        }
        this.tabListName = tabListName;
        return this;
    }

    @Override
    @Generated
    public NPCImpl lookAtPlayer(boolean lookAtPlayer) {
        this.lookAtPlayer = lookAtPlayer;
        return this;
    }

    @Override
    @Generated
    public NPCImpl collisionRule(@NotNull ClientboundSetPlayerTeamPacket.CollisionRule collisionRule) {
        this.collisionRule = collisionRule;
        return this;
    }
}

