/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.p.AbstractPacket;
import sba.sl.p.PacketWriter;
import sba.sl.u.math.Vector3D;
import sba.sl.w.Location;

public class ClientboundAddEntityPacket
extends AbstractPacket {
    private final int entityId;
    @NotNull
    private final UUID uuid;
    @NotNull
    private final Location location;
    @NotNull
    private final Vector3D velocity;
    private final int typeId;
    private final int data;
    @Nullable
    private final Byte headYaw;

    @Override
    public void write(@NotNull PacketWriter writer) {
        writer.writeVarInt(this.entityId);
        if (writer.protocol() >= 49) {
            writer.writeUuid(this.uuid);
        }
        if (writer.protocol() >= 458) {
            writer.writeVarInt(this.typeId);
        } else {
            writer.writeByte((byte)this.typeId);
        }
        if (writer.protocol() >= 100) {
            writer.writeVector(this.location);
        } else {
            writer.writeFixedPointVector(this.location);
        }
        if (writer.protocol() >= 773) {
            writer.writeLpVec3(this.velocity);
        }
        writer.writeByteRotation(this.location);
        if (writer.protocol() >= 759) {
            writer.writeByte(this.headYaw != null ? this.headYaw : (byte)(this.location.getYaw() * 256.0f / 360.0f));
            writer.writeVarInt(this.data);
        } else {
            writer.writeInt(this.data);
        }
        if ((this.data != 0 || writer.protocol() >= 49) && writer.protocol() < 773) {
            writer.writeMotion(this.velocity);
        }
    }

    @Generated
    ClientboundAddEntityPacket(int entityId, @NotNull UUID uuid, @NotNull Location location, @NotNull Vector3D velocity, int typeId, int data, @Nullable Byte headYaw) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (velocity == null) {
            throw new NullPointerException("velocity is marked non-null but is null");
        }
        this.entityId = entityId;
        this.uuid = uuid;
        this.location = location;
        this.velocity = velocity;
        this.typeId = typeId;
        this.data = data;
        this.headYaw = headYaw;
    }

    @Generated
    public static ClientboundAddEntityPacketBuilder builder() {
        return new ClientboundAddEntityPacketBuilder();
    }

    @Generated
    public ClientboundAddEntityPacketBuilder toBuilder() {
        return new ClientboundAddEntityPacketBuilder().entityId(this.entityId).uuid(this.uuid).location(this.location).velocity(this.velocity).typeId(this.typeId).data(this.data).headYaw(this.headYaw);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundAddEntityPacket)) {
            return false;
        }
        ClientboundAddEntityPacket other = (ClientboundAddEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        if (this.typeId() != other.typeId()) {
            return false;
        }
        if (this.data() != other.data()) {
            return false;
        }
        Byte this$headYaw = this.headYaw();
        Byte other$headYaw = other.headYaw();
        if (this$headYaw == null ? other$headYaw != null : !((Object)this$headYaw).equals(other$headYaw)) {
            return false;
        }
        UUID this$uuid = this.uuid();
        UUID other$uuid = other.uuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        Location this$location = this.location();
        Location other$location = other.location();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        Vector3D this$velocity = this.velocity();
        Vector3D other$velocity = other.velocity();
        return !(this$velocity == null ? other$velocity != null : !((Object)this$velocity).equals(other$velocity));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientboundAddEntityPacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        result = result * 59 + this.typeId();
        result = result * 59 + this.data();
        Byte $headYaw = this.headYaw();
        result = result * 59 + ($headYaw == null ? 43 : ((Object)$headYaw).hashCode());
        UUID $uuid = this.uuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        Location $location = this.location();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        Vector3D $velocity = this.velocity();
        result = result * 59 + ($velocity == null ? 43 : ((Object)$velocity).hashCode());
        return result;
    }

    @Generated
    public int entityId() {
        return this.entityId;
    }

    @NotNull
    @Generated
    public UUID uuid() {
        return this.uuid;
    }

    @NotNull
    @Generated
    public Location location() {
        return this.location;
    }

    @NotNull
    @Generated
    public Vector3D velocity() {
        return this.velocity;
    }

    @Generated
    public int typeId() {
        return this.typeId;
    }

    @Generated
    public int data() {
        return this.data;
    }

    @Nullable
    @Generated
    public Byte headYaw() {
        return this.headYaw;
    }

    @Generated
    public String toString() {
        return "ClientboundAddEntityPacket(entityId=" + this.entityId() + ", uuid=" + String.valueOf(this.uuid()) + ", location=" + String.valueOf(this.location()) + ", velocity=" + String.valueOf(this.velocity()) + ", typeId=" + this.typeId() + ", data=" + this.data() + ", headYaw=" + this.headYaw() + ")";
    }

    @Generated
    public static class ClientboundAddEntityPacketBuilder {
        @Generated
        private int entityId;
        @Generated
        private UUID uuid;
        @Generated
        private Location location;
        @Generated
        private Vector3D velocity;
        @Generated
        private int typeId;
        @Generated
        private int data;
        @Generated
        private Byte headYaw;

        @Generated
        ClientboundAddEntityPacketBuilder() {
        }

        @Generated
        public ClientboundAddEntityPacketBuilder entityId(int entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public ClientboundAddEntityPacketBuilder uuid(@NotNull UUID uuid) {
            if (uuid == null) {
                throw new NullPointerException("uuid is marked non-null but is null");
            }
            this.uuid = uuid;
            return this;
        }

        @Generated
        public ClientboundAddEntityPacketBuilder location(@NotNull Location location) {
            if (location == null) {
                throw new NullPointerException("location is marked non-null but is null");
            }
            this.location = location;
            return this;
        }

        @Generated
        public ClientboundAddEntityPacketBuilder velocity(@NotNull Vector3D velocity) {
            if (velocity == null) {
                throw new NullPointerException("velocity is marked non-null but is null");
            }
            this.velocity = velocity;
            return this;
        }

        @Generated
        public ClientboundAddEntityPacketBuilder typeId(int typeId) {
            this.typeId = typeId;
            return this;
        }

        @Generated
        public ClientboundAddEntityPacketBuilder data(int data) {
            this.data = data;
            return this;
        }

        @Generated
        public ClientboundAddEntityPacketBuilder headYaw(@Nullable Byte headYaw) {
            this.headYaw = headYaw;
            return this;
        }

        @Generated
        public ClientboundAddEntityPacket build() {
            return new ClientboundAddEntityPacket(this.entityId, this.uuid, this.location, this.velocity, this.typeId, this.data, this.headYaw);
        }

        @Generated
        public String toString() {
            return "ClientboundAddEntityPacket.ClientboundAddEntityPacketBuilder(entityId=" + this.entityId + ", uuid=" + String.valueOf(this.uuid) + ", location=" + String.valueOf(this.location) + ", velocity=" + String.valueOf(this.velocity) + ", typeId=" + this.typeId + ", data=" + this.data + ", headYaw=" + this.headYaw + ")";
        }
    }
}

