/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.p.AbstractPacket;
import sba.sl.p.ClientboundAddEntityPacket;
import sba.sl.p.ClientboundSetEntityDataPacket;
import sba.sl.p.MetadataItem;
import sba.sl.p.PacketWriter;
import sba.sl.u.math.Vector3D;
import sba.sl.w.Location;

public class ClientboundAddMobPacket
extends AbstractPacket {
    private final int entityId;
    @NotNull
    private final UUID uuid;
    @NotNull
    private final Location location;
    @NotNull
    private final Vector3D velocity;
    private final int typeId;
    @NotNull
    private final @NotNull List<@NotNull MetadataItem> metadata;
    private final byte headYaw;

    @Override
    public void write(@NotNull PacketWriter writer) {
        if (writer.protocol() >= 759) {
            writer.setCancelled(true);
            ClientboundAddEntityPacket packet = ClientboundAddEntityPacket.builder().entityId(this.entityId).uuid(this.uuid).location(this.location).velocity(this.velocity).typeId(this.typeId).headYaw(this.headYaw).build();
            writer.append(packet);
            if (!this.metadata.isEmpty()) {
                writer.append(ClientboundSetEntityDataPacket.builder().entityId(this.entityId).metadata(this.metadata).build());
            }
        }
        writer.writeVarInt(this.entityId);
        if (writer.protocol() >= 49) {
            writer.writeUuid(this.uuid);
        }
        if (writer.protocol() >= 301) {
            writer.writeVarInt(this.typeId);
        } else {
            writer.writeByte((byte)this.typeId);
        }
        if (writer.protocol() >= 100) {
            writer.writeVector(this.location);
        } else {
            writer.writeFixedPointVector(this.location);
        }
        writer.writeByteRotation(this.location);
        writer.writeByte(this.headYaw);
        writer.writeMotion(this.velocity);
        if (writer.protocol() >= 550) {
            if (!this.metadata.isEmpty()) {
                writer.append(ClientboundSetEntityDataPacket.builder().entityId(this.entityId).metadata(this.metadata).build());
            }
        } else {
            writer.writeDataWatcherCollection(this.metadata);
        }
    }

    @Generated
    private static List<@NotNull MetadataItem> $default$metadata() {
        return List.of();
    }

    @Generated
    ClientboundAddMobPacket(int entityId, @NotNull UUID uuid, @NotNull Location location, @NotNull Vector3D velocity, int typeId, @NotNull @NotNull List<@NotNull MetadataItem> metadata, byte headYaw) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (velocity == null) {
            throw new NullPointerException("velocity is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.entityId = entityId;
        this.uuid = uuid;
        this.location = location;
        this.velocity = velocity;
        this.typeId = typeId;
        this.metadata = metadata;
        this.headYaw = headYaw;
    }

    @Generated
    public static ClientboundAddMobPacketBuilder builder() {
        return new ClientboundAddMobPacketBuilder();
    }

    @Generated
    public ClientboundAddMobPacketBuilder toBuilder() {
        return new ClientboundAddMobPacketBuilder().entityId(this.entityId).uuid(this.uuid).location(this.location).velocity(this.velocity).typeId(this.typeId).metadata(this.metadata).headYaw(this.headYaw);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundAddMobPacket)) {
            return false;
        }
        ClientboundAddMobPacket other = (ClientboundAddMobPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        if (this.typeId() != other.typeId()) {
            return false;
        }
        if (this.headYaw() != other.headYaw()) {
            return false;
        }
        UUID this$uuid = this.uuid();
        UUID other$uuid = other.uuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        Location this$location = this.location();
        Location other$location = other.location();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        Vector3D this$velocity = this.velocity();
        Vector3D other$velocity = other.velocity();
        if (this$velocity == null ? other$velocity != null : !((Object)this$velocity).equals(other$velocity)) {
            return false;
        }
        List<MetadataItem> this$metadata = this.metadata();
        List<MetadataItem> other$metadata = other.metadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientboundAddMobPacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        result = result * 59 + this.typeId();
        result = result * 59 + this.headYaw();
        UUID $uuid = this.uuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        Location $location = this.location();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        Vector3D $velocity = this.velocity();
        result = result * 59 + ($velocity == null ? 43 : ((Object)$velocity).hashCode());
        List<MetadataItem> $metadata = this.metadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    @Generated
    public int entityId() {
        return this.entityId;
    }

    @NotNull
    @Generated
    public UUID uuid() {
        return this.uuid;
    }

    @NotNull
    @Generated
    public Location location() {
        return this.location;
    }

    @NotNull
    @Generated
    public Vector3D velocity() {
        return this.velocity;
    }

    @Generated
    public int typeId() {
        return this.typeId;
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull MetadataItem> metadata() {
        return this.metadata;
    }

    @Generated
    public byte headYaw() {
        return this.headYaw;
    }

    @Generated
    public String toString() {
        return "ClientboundAddMobPacket(entityId=" + this.entityId() + ", uuid=" + String.valueOf(this.uuid()) + ", location=" + String.valueOf(this.location()) + ", velocity=" + String.valueOf(this.velocity()) + ", typeId=" + this.typeId() + ", metadata=" + String.valueOf(this.metadata()) + ", headYaw=" + this.headYaw() + ")";
    }

    @Generated
    public static class ClientboundAddMobPacketBuilder {
        @Generated
        private int entityId;
        @Generated
        private UUID uuid;
        @Generated
        private Location location;
        @Generated
        private Vector3D velocity;
        @Generated
        private int typeId;
        @Generated
        private boolean metadata$set;
        @Generated
        private List<@NotNull MetadataItem> metadata$value;
        @Generated
        private byte headYaw;

        @Generated
        ClientboundAddMobPacketBuilder() {
        }

        @Generated
        public ClientboundAddMobPacketBuilder entityId(int entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public ClientboundAddMobPacketBuilder uuid(@NotNull UUID uuid) {
            if (uuid == null) {
                throw new NullPointerException("uuid is marked non-null but is null");
            }
            this.uuid = uuid;
            return this;
        }

        @Generated
        public ClientboundAddMobPacketBuilder location(@NotNull Location location) {
            if (location == null) {
                throw new NullPointerException("location is marked non-null but is null");
            }
            this.location = location;
            return this;
        }

        @Generated
        public ClientboundAddMobPacketBuilder velocity(@NotNull Vector3D velocity) {
            if (velocity == null) {
                throw new NullPointerException("velocity is marked non-null but is null");
            }
            this.velocity = velocity;
            return this;
        }

        @Generated
        public ClientboundAddMobPacketBuilder typeId(int typeId) {
            this.typeId = typeId;
            return this;
        }

        @Generated
        public ClientboundAddMobPacketBuilder metadata(@NotNull @NotNull List<@NotNull MetadataItem> metadata) {
            if (metadata == null) {
                throw new NullPointerException("metadata is marked non-null but is null");
            }
            this.metadata$value = metadata;
            this.metadata$set = true;
            return this;
        }

        @Generated
        public ClientboundAddMobPacketBuilder headYaw(byte headYaw) {
            this.headYaw = headYaw;
            return this;
        }

        @Generated
        public ClientboundAddMobPacket build() {
            List<@NotNull MetadataItem> metadata$value = this.metadata$value;
            if (!this.metadata$set) {
                metadata$value = ClientboundAddMobPacket.$default$metadata();
            }
            return new ClientboundAddMobPacket(this.entityId, this.uuid, this.location, this.velocity, this.typeId, metadata$value, this.headYaw);
        }

        @Generated
        public String toString() {
            return "ClientboundAddMobPacket.ClientboundAddMobPacketBuilder(entityId=" + this.entityId + ", uuid=" + String.valueOf(this.uuid) + ", location=" + String.valueOf(this.location) + ", velocity=" + String.valueOf(this.velocity) + ", typeId=" + this.typeId + ", metadata$value=" + String.valueOf(this.metadata$value) + ", headYaw=" + this.headYaw + ")";
        }
    }
}

