/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import sba.sl.p.AbstractPacket;
import sba.sl.p.PacketWriter;

public class ClientboundRotateHeadPacket
extends AbstractPacket {
    private final int entityId;
    private final byte rotation;

    @Override
    public void write(@NotNull PacketWriter writer) {
        writer.writeVarInt(this.entityId);
        writer.writeByte(this.rotation);
    }

    @Generated
    ClientboundRotateHeadPacket(int entityId, byte rotation) {
        this.entityId = entityId;
        this.rotation = rotation;
    }

    @Generated
    public static ClientboundRotateHeadPacketBuilder builder() {
        return new ClientboundRotateHeadPacketBuilder();
    }

    @Generated
    public ClientboundRotateHeadPacketBuilder toBuilder() {
        return new ClientboundRotateHeadPacketBuilder().entityId(this.entityId).rotation(this.rotation);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRotateHeadPacket)) {
            return false;
        }
        ClientboundRotateHeadPacket other = (ClientboundRotateHeadPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        return this.rotation() == other.rotation();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientboundRotateHeadPacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        result = result * 59 + this.rotation();
        return result;
    }

    @Generated
    public int entityId() {
        return this.entityId;
    }

    @Generated
    public byte rotation() {
        return this.rotation;
    }

    @Generated
    public String toString() {
        return "ClientboundRotateHeadPacket(entityId=" + this.entityId() + ", rotation=" + this.rotation() + ")";
    }

    public static class ClientboundRotateHeadPacketBuilder {
        @Generated
        private int entityId;
        @Generated
        private byte rotation;

        @Contract(value="_ -> this")
        @NotNull
        public ClientboundRotateHeadPacketBuilder headYaw(float headYaw) {
            this.rotation = (byte)(headYaw * 256.0f / 360.0f);
            return this;
        }

        @Generated
        ClientboundRotateHeadPacketBuilder() {
        }

        @Generated
        public ClientboundRotateHeadPacketBuilder entityId(int entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public ClientboundRotateHeadPacketBuilder rotation(byte rotation) {
            this.rotation = rotation;
            return this;
        }

        @Generated
        public ClientboundRotateHeadPacket build() {
            return new ClientboundRotateHeadPacket(this.entityId, this.rotation);
        }

        @Generated
        public String toString() {
            return "ClientboundRotateHeadPacket.ClientboundRotateHeadPacketBuilder(entityId=" + this.entityId + ", rotation=" + this.rotation + ")";
        }
    }
}

