/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.p.PacketWriter;
import sba.sl.spectator.Component;
import sba.sl.u.annotations.ide.LimitedVersionSupport;
import sba.sl.u.math.Vector3Df;
import sba.sl.u.math.Vector3Di;

public abstract class MetadataItem {
    private final byte index;

    public abstract void write(@NotNull PacketWriter var1);

    protected void writeModernHeader(@NotNull PacketWriter writer) {
        if (writer.protocol() <= 56) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is not compatible with protocol < 57!");
        }
        writer.writeByte(this.index);
    }

    protected void writeLegacyHeader(@NotNull PacketWriter writer, int type) {
        writer.writeByte((byte)((type << 5 | this.index & 0x1F) & 0xFF));
    }

    @NotNull
    public static ByteMetadataItem of(byte index, byte value) {
        return new ByteMetadataItem(index, value);
    }

    @NotNull
    public static VarIntMetadataItem of(byte index, int value) {
        return new VarIntMetadataItem(index, value);
    }

    @NotNull
    public static ShortMetadataItem of(byte index, short value) {
        return new ShortMetadataItem(index, value);
    }

    @NotNull
    public static FloatMetadataItem of(byte index, float value) {
        return new FloatMetadataItem(index, value);
    }

    @NotNull
    public static StringMetadataItem of(byte index, @NotNull String value) {
        return new StringMetadataItem(index, value);
    }

    @NotNull
    public static ComponentMetadataItem of(byte index, @NotNull Component value) {
        return new ComponentMetadataItem(index, value);
    }

    @NotNull
    public static BooleanMetadataItem of(byte index, boolean value) {
        return new BooleanMetadataItem(index, value);
    }

    @NotNull
    public static Vector3DfMetadataItem of(byte index, @NotNull Vector3Df value) {
        return new Vector3DfMetadataItem(index, value);
    }

    @NotNull
    public static OptionalComponentMetadataItem ofOpt(byte index, @NotNull Component value) {
        return new OptionalComponentMetadataItem(index, value);
    }

    @NotNull
    public static OptionalBlockPositionMetadataItem ofOpt(byte index, @NotNull Vector3Di value) {
        return new OptionalBlockPositionMetadataItem(index, value);
    }

    public static long blockPosToLong(int x, int y, int z) {
        if (Server.isVersion(1, 14)) {
            return ((long)x & 0x3FFFFFFL) << 38 | ((long)z & 0x3FFFFFFL) << 12 | (long)y & 0xFFFL;
        }
        return ((long)x & 0x3FFFFFFL) << 38 | ((long)y & 0xFFFL) << 26 | (long)z & 0x3FFFFFFL;
    }

    @Generated
    public MetadataItem(byte index) {
        this.index = index;
    }

    @Generated
    public byte getIndex() {
        return this.index;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataItem)) {
            return false;
        }
        MetadataItem other = (MetadataItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getIndex() == other.getIndex();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetadataItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        return result;
    }

    @Generated
    public String toString() {
        return "MetadataItem(index=" + this.getIndex() + ")";
    }

    public static class ByteMetadataItem
    extends MetadataItem {
        private final byte data;

        public ByteMetadataItem(byte index, byte data) {
            super(index);
            this.data = data;
        }

        @Override
        public void write(@NotNull PacketWriter writer) {
            if (writer.protocol() < 57) {
                this.writeLegacyHeader(writer, 0);
            } else {
                this.writeModernHeader(writer);
                writer.writeVarInt(0);
            }
            writer.writeByte(this.data);
        }

        @Generated
        public byte getData() {
            return this.data;
        }

        @Override
        @Generated
        public String toString() {
            return "MetadataItem.ByteMetadataItem(super=" + super.toString() + ", data=" + this.getData() + ")";
        }
    }

    public static class VarIntMetadataItem
    extends MetadataItem {
        private final int data;

        public VarIntMetadataItem(byte index, int data) {
            super(index);
            this.data = data;
        }

        @Override
        public void write(@NotNull PacketWriter writer) {
            if (writer.protocol() < 57) {
                this.writeLegacyHeader(writer, 2);
                writer.writeInt(this.data);
            } else {
                this.writeModernHeader(writer);
                writer.writeVarInt(1);
                writer.writeVarInt(this.data);
            }
        }

        @Generated
        public int getData() {
            return this.data;
        }

        @Override
        @Generated
        public String toString() {
            return "MetadataItem.VarIntMetadataItem(super=" + super.toString() + ", data=" + this.getData() + ")";
        }
    }

    @LimitedVersionSupport(value="Packet version lower than 57")
    public static class ShortMetadataItem
    extends MetadataItem {
        private final short data;

        public ShortMetadataItem(byte index, short data) {
            super(index);
            this.data = data;
        }

        @Override
        public void write(PacketWriter writer) {
            if (writer.protocol() < 57) {
                this.writeLegacyHeader(writer, 1);
                writer.writeShort(this.data);
            }
        }

        @Generated
        public short getData() {
            return this.data;
        }

        @Override
        @Generated
        public String toString() {
            return "MetadataItem.ShortMetadataItem(super=" + super.toString() + ", data=" + this.getData() + ")";
        }
    }

    public static class FloatMetadataItem
    extends MetadataItem {
        private final float data;

        public FloatMetadataItem(byte index, float data) {
            super(index);
            this.data = data;
        }

        @Override
        public void write(@NotNull PacketWriter writer) {
            if (writer.protocol() < 57) {
                this.writeLegacyHeader(writer, 3);
            } else {
                this.writeModernHeader(writer);
                writer.writeVarInt(writer.protocol() >= 761 ? 3 : 2);
            }
            writer.writeFloat(this.data);
        }

        @Generated
        public float getData() {
            return this.data;
        }

        @Override
        @Generated
        public String toString() {
            return "MetadataItem.FloatMetadataItem(super=" + super.toString() + ", data=" + this.getData() + ")";
        }
    }

    public static class StringMetadataItem
    extends MetadataItem {
        @NotNull
        private final String text;

        public StringMetadataItem(byte index, @NotNull String text) {
            super(index);
            this.text = text;
        }

        @Override
        public void write(@NotNull PacketWriter writer) {
            if (writer.protocol() < 57) {
                this.writeLegacyHeader(writer, 4);
            } else {
                this.writeModernHeader(writer);
                writer.writeVarInt(writer.protocol() >= 761 ? 4 : 3);
            }
            writer.writeSizedString(this.text);
        }

        @NotNull
        @Generated
        public String getText() {
            return this.text;
        }

        @Override
        @Generated
        public String toString() {
            return "MetadataItem.StringMetadataItem(super=" + super.toString() + ", text=" + this.getText() + ")";
        }
    }

    public static class ComponentMetadataItem
    extends MetadataItem {
        @NotNull
        private final Component text;

        public ComponentMetadataItem(byte index, @NotNull Component text) {
            super(index);
            this.text = text;
        }

        @Override
        public void write(@NotNull PacketWriter writer) {
            this.writeModernHeader(writer);
            writer.writeVarInt(writer.protocol() >= 761 ? 5 : 4);
            writer.writeComponent(this.text);
        }

        @NotNull
        @Generated
        public Component getText() {
            return this.text;
        }

        @Override
        @Generated
        public String toString() {
            return "MetadataItem.ComponentMetadataItem(super=" + super.toString() + ", text=" + String.valueOf(this.getText()) + ")";
        }
    }

    public static class BooleanMetadataItem
    extends MetadataItem {
        private final boolean val;

        public BooleanMetadataItem(byte index, boolean val) {
            super(index);
            this.val = val;
        }

        @Override
        public void write(@NotNull PacketWriter writer) {
            if (writer.protocol() < 57) {
                this.writeLegacyHeader(writer, 0);
            } else {
                this.writeModernHeader(writer);
                writer.writeVarInt(writer.protocol() < 393 ? 6 : (writer.protocol() >= 761 ? 8 : 7));
            }
            writer.writeBoolean(this.val);
        }

        @Generated
        public boolean isVal() {
            return this.val;
        }

        @Override
        @Generated
        public String toString() {
            return "MetadataItem.BooleanMetadataItem(super=" + super.toString() + ", val=" + this.isVal() + ")";
        }
    }

    public static class Vector3DfMetadataItem
    extends MetadataItem {
        @NotNull
        private final Vector3Df val;

        public Vector3DfMetadataItem(byte index, @NotNull Vector3Df val) {
            super(index);
            this.val = val;
        }

        @Override
        public void write(@NotNull PacketWriter writer) {
            if (writer.protocol() < 57) {
                this.writeLegacyHeader(writer, 7);
            } else {
                this.writeModernHeader(writer);
                writer.writeVarInt(writer.protocol() < 393 ? 7 : (writer.protocol() >= 761 ? 9 : 8));
            }
            writer.writeVector(this.val);
        }

        @NotNull
        @Generated
        public Vector3Df getVal() {
            return this.val;
        }

        @Override
        @Generated
        public String toString() {
            return "MetadataItem.Vector3DfMetadataItem(super=" + super.toString() + ", val=" + String.valueOf(this.getVal()) + ")";
        }
    }

    public static class OptionalComponentMetadataItem
    extends MetadataItem {
        @Nullable
        private final Component val;

        public OptionalComponentMetadataItem(byte index, @Nullable Component val) {
            super(index);
            this.val = val;
        }

        @Override
        public void write(@NotNull PacketWriter writer) {
            this.writeModernHeader(writer);
            writer.writeVarInt(writer.protocol() >= 761 ? 6 : 5);
            boolean flag = this.val != null && !this.val.equals(Component.empty());
            writer.writeBoolean(flag);
            if (flag) {
                writer.writeComponent(this.val);
            }
        }

        @Nullable
        @Generated
        public Component getVal() {
            return this.val;
        }

        @Override
        @Generated
        public String toString() {
            return "MetadataItem.OptionalComponentMetadataItem(super=" + super.toString() + ", val=" + String.valueOf(this.getVal()) + ")";
        }
    }

    public static class OptionalBlockPositionMetadataItem
    extends MetadataItem {
        @Nullable
        private final Vector3Di blockPosition;

        public OptionalBlockPositionMetadataItem(byte index, @Nullable Vector3Di blockPosition) {
            super(index);
            this.blockPosition = blockPosition;
        }

        @Override
        public void write(@NotNull PacketWriter writer) {
            this.writeModernHeader(writer);
            writer.writeVarInt(writer.protocol() < 393 ? 9 : (writer.protocol() >= 761 ? 11 : 10));
            boolean present = this.blockPosition != null;
            writer.writeBoolean(present);
            if (present) {
                writer.writeLong(OptionalBlockPositionMetadataItem.blockPosToLong(this.blockPosition.getX(), this.blockPosition.getY(), this.blockPosition.getZ()));
            }
        }

        @Nullable
        @Generated
        public Vector3Di getBlockPosition() {
            return this.blockPosition;
        }

        @Override
        @Generated
        public String toString() {
            return "MetadataItem.OptionalBlockPositionMetadataItem(super=" + super.toString() + ", blockPosition=" + String.valueOf(this.getBlockPosition()) + ")";
        }
    }
}

