/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.pa;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.pa.ParticleData;
import sba.sl.pa.ParticleType;
import sba.sl.u.math.Vector3D;

public class Particle {
    @NotNull
    private final ParticleType particleType;
    private final int count;
    @NotNull
    private final Vector3D offset;
    private final double particleData;
    private final boolean longDistance;
    @Nullable
    private final ParticleData specialData;

    public Particle(@NotNull ParticleType particleType) {
        this(particleType, 1, Vector3D.ZERO, 1.0, false, null);
    }

    public Particle(@NotNull ParticleType particleType, int count) {
        this(particleType, count, Vector3D.ZERO, 1.0, false, null);
    }

    public Particle(@NotNull ParticleType particleType, int count, @NotNull Vector3D offset) {
        this(particleType, count, offset, 1.0, false, null);
    }

    public Particle(@NotNull ParticleType particleType, int count, @NotNull Vector3D offset, double particleData) {
        this(particleType, count, offset, particleData, false, null);
    }

    public Particle(@NotNull ParticleType particleType, int count, @NotNull Vector3D offset, double particleData, boolean longDistance) {
        this(particleType, count, offset, particleData, longDistance, null);
    }

    @NotNull
    @Generated
    public ParticleType particleType() {
        return this.particleType;
    }

    @Generated
    public int count() {
        return this.count;
    }

    @NotNull
    @Generated
    public Vector3D offset() {
        return this.offset;
    }

    @Generated
    public double particleData() {
        return this.particleData;
    }

    @Generated
    public boolean longDistance() {
        return this.longDistance;
    }

    @Nullable
    @Generated
    public ParticleData specialData() {
        return this.specialData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Particle)) {
            return false;
        }
        Particle other = (Particle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.count() != other.count()) {
            return false;
        }
        if (Double.compare(this.particleData(), other.particleData()) != 0) {
            return false;
        }
        if (this.longDistance() != other.longDistance()) {
            return false;
        }
        ParticleType this$particleType = this.particleType();
        ParticleType other$particleType = other.particleType();
        if (this$particleType == null ? other$particleType != null : !this$particleType.equals(other$particleType)) {
            return false;
        }
        Vector3D this$offset = this.offset();
        Vector3D other$offset = other.offset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        ParticleData this$specialData = this.specialData();
        ParticleData other$specialData = other.specialData();
        return !(this$specialData == null ? other$specialData != null : !this$specialData.equals(other$specialData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Particle;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.count();
        long $particleData = Double.doubleToLongBits(this.particleData());
        result = result * 59 + (int)($particleData >>> 32 ^ $particleData);
        result = result * 59 + (this.longDistance() ? 79 : 97);
        ParticleType $particleType = this.particleType();
        result = result * 59 + ($particleType == null ? 43 : $particleType.hashCode());
        Vector3D $offset = this.offset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        ParticleData $specialData = this.specialData();
        result = result * 59 + ($specialData == null ? 43 : $specialData.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Particle(particleType=" + String.valueOf(this.particleType()) + ", count=" + this.count() + ", offset=" + String.valueOf(this.offset()) + ", particleData=" + this.particleData() + ", longDistance=" + this.longDistance() + ", specialData=" + String.valueOf(this.specialData()) + ")";
    }

    @Generated
    public Particle withParticleType(@NotNull ParticleType particleType) {
        if (particleType == null) {
            throw new NullPointerException("particleType is marked non-null but is null");
        }
        return this.particleType == particleType ? this : new Particle(particleType, this.count, this.offset, this.particleData, this.longDistance, this.specialData);
    }

    @Generated
    public Particle withCount(int count) {
        return this.count == count ? this : new Particle(this.particleType, count, this.offset, this.particleData, this.longDistance, this.specialData);
    }

    @Generated
    public Particle withOffset(@NotNull Vector3D offset) {
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        return this.offset == offset ? this : new Particle(this.particleType, this.count, offset, this.particleData, this.longDistance, this.specialData);
    }

    @Generated
    public Particle withParticleData(double particleData) {
        return this.particleData == particleData ? this : new Particle(this.particleType, this.count, this.offset, particleData, this.longDistance, this.specialData);
    }

    @Generated
    public Particle withLongDistance(boolean longDistance) {
        return this.longDistance == longDistance ? this : new Particle(this.particleType, this.count, this.offset, this.particleData, longDistance, this.specialData);
    }

    @Generated
    public Particle withSpecialData(@Nullable ParticleData specialData) {
        return this.specialData == specialData ? this : new Particle(this.particleType, this.count, this.offset, this.particleData, this.longDistance, specialData);
    }

    @Generated
    public Particle(@NotNull ParticleType particleType, int count, @NotNull Vector3D offset, double particleData, boolean longDistance, @Nullable ParticleData specialData) {
        if (particleType == null) {
            throw new NullPointerException("particleType is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        this.particleType = particleType;
        this.count = count;
        this.offset = offset;
        this.particleData = particleData;
        this.longDistance = longDistance;
        this.specialData = specialData;
    }
}

