/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.si;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.spectator.StaticAudienceComponentLike;
import sba.sl.p.AbstractPacket;
import sba.sl.p.ClientboundSetDisplayObjectivePacket;
import sba.sl.p.ClientboundSetObjectivePacket;
import sba.sl.p.ClientboundSetPlayerTeamPacket;
import sba.sl.p.ClientboundSetScorePacket;
import sba.sl.pa.Player;
import sba.sl.si.ScoreSidebar;
import sba.sl.si.SidebarManager;
import sba.sl.si.team.ScoreboardTeam;
import sba.sl.si.team.ScoreboardTeamImpl;
import sba.sl.spectator.AudienceComponentLike;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.u.data.DataContainer;
import sba.sl.vi.UpdateStrategy;
import sba.sl.vi.impl.AbstractVisual;

public class ScoreSidebarImpl
extends AbstractVisual<ScoreSidebar>
implements ScoreSidebar {
    @NotNull
    protected final @NotNull List<@NotNull ScoreboardTeam> teams = new LinkedList<ScoreboardTeam>();
    @NotNull
    protected final @NotNull List<@NotNull ScoreEntry> entries = new CopyOnWriteArrayList<ScoreEntry>();
    @Nullable
    protected DataContainer data;
    protected boolean ready;
    @NotNull
    protected AudienceComponentLike title = AudienceComponentLike.empty();
    @NotNull
    private final String objectiveKey;
    @NotNull
    private final @NotNull List<@NotNull ScoreEntry> lines = new CopyOnWriteArrayList<ScoreEntry>();

    public ScoreSidebarImpl(@NotNull UUID uuid) {
        super(uuid);
        this.objectiveKey = new Random().ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(16L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    @Override
    @Nullable
    public ScoreboardTeam getTeam(@NotNull String identifier) {
        return this.teams.stream().filter(scoreboardTeam -> identifier.equals(scoreboardTeam.identifier())).findFirst().orElse(null);
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public ScoreSidebar removeTeam(@NotNull String identifier) {
        ScoreboardTeam team = this.getTeam(identifier);
        if (team != null) {
            this.removeTeam(team);
        }
        return this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public ScoreSidebar removeTeam(@NotNull ScoreboardTeam scoreboardTeam) {
        scoreboardTeam.destroy();
        this.teams.remove(scoreboardTeam);
        return this;
    }

    @Override
    public boolean hasData() {
        if (this.data == null) {
            return false;
        }
        return !this.data.isEmpty();
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public ScoreSidebar title(@NotNull Component title) {
        return this.title(AudienceComponentLike.of(title));
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public ScoreSidebar title(@NotNull ComponentLike title) {
        this.title = title instanceof AudienceComponentLike ? (AudienceComponentLike)title : AudienceComponentLike.of(title);
        this.updateTitle0();
        return this;
    }

    @Override
    @NotNull
    public ScoreSidebar entity(@NotNull String identifier, @NotNull Component displayName) {
        this.entries.stream().filter(entryA -> entryA.getIdentifier().equals(identifier)).findFirst().ifPresentOrElse(scoreEntry -> {
            if (!displayName.equals(scoreEntry.getComponent())) {
                scoreEntry.setComponent(displayName);
                scoreEntry.setReloadCache(true);
                this.update();
            }
        }, () -> {
            this.entries.add(new ScoreEntry(identifier, displayName));
            this.update();
        });
        return this;
    }

    @Override
    @NotNull
    public ScoreSidebar score(@NotNull String identifier, int score) {
        this.entries.stream().filter(entryA -> entryA.getIdentifier().equals(identifier)).findFirst().ifPresent(scoreEntry -> {
            scoreEntry.setScore(score);
            this.update();
        });
        return this;
    }

    @Override
    @NotNull
    public ScoreSidebar removeEntity(@NotNull String identifier) {
        this.entries.stream().filter(entryA -> entryA.getIdentifier().equals(identifier)).findFirst().ifPresent(scoreEntry -> {
            this.entries.remove(scoreEntry);
            this.update();
        });
        return this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public ScoreSidebar update(@NotNull UpdateStrategy strategy) {
        if (this.ready) {
            List<ScoreEntry> list = this.entries.stream().sorted(Comparator.comparingInt(ScoreEntry::getScore).reversed()).limit(15L).collect(Collectors.toList());
            ArrayList<AbstractPacket> packets = new ArrayList<AbstractPacket>();
            this.lines.stream().filter(scoreEntry -> !list.contains(scoreEntry)).forEach(scoreEntry -> {
                this.lines.remove(scoreEntry);
                packets.add(this.destroyScore(scoreEntry.getCache()));
            });
            list.forEach(scoreEntry -> {
                if (!this.lines.contains(scoreEntry)) {
                    this.lines.add((ScoreEntry)scoreEntry);
                }
                if (scoreEntry.getCache() == null || scoreEntry.isReloadCache()) {
                    if (scoreEntry.getCache() != null) {
                        packets.add(this.destroyScore(scoreEntry.getCache()));
                    }
                    scoreEntry.setCache(this.crop(scoreEntry.getComponent().toLegacy()));
                    scoreEntry.setReloadCache(false);
                }
                packets.add(this.createScorePacket(scoreEntry.getScore(), scoreEntry.getCache()));
            });
            if (this.visible) {
                packets.forEach(packet -> packet.sendPacket(this.viewers));
            }
            if (!(this.title instanceof StaticAudienceComponentLike)) {
                this.updateTitle0();
            }
        }
        return this;
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public ScoreSidebar show() {
        if (this.shown()) {
            return this;
        }
        this.ready = true;
        this.visible = true;
        this.viewers.forEach(a -> this.onViewerAdded((Player)a, false));
        this.update();
        return this;
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public ScoreSidebar hide() {
        if (!this.shown()) {
            return this;
        }
        this.visible = false;
        this.ready = false;
        this.update();
        return this;
    }

    @Override
    public void destroy() {
        this.data = null;
        this.hide();
        this.viewers.clear();
        SidebarManager.removeSidebar(this);
    }

    @Override
    public void onViewerAdded(@NotNull Player player, boolean checkDistance) {
        if (this.visible && player.isOnline()) {
            this.getCreateObjectivePacket(player).sendPacket(player);
            this.allScores().forEach(packet -> packet.sendPacket(player));
            this.getDisplayObjectivePacket().sendPacket(player);
            this.teams.forEach(scoreboardTeam -> ((ScoreboardTeamImpl)scoreboardTeam).constructCreatePacket().sendPacket(player));
        }
    }

    @Override
    public void onViewerRemoved(@NotNull Player player, boolean checkDistance) {
        if (this.visible && player.isOnline()) {
            this.teams.forEach(scoreboardTeam -> ((ScoreboardTeamImpl)scoreboardTeam).constructDestructPacket().sendPacket(player));
            this.getDestroyObjectivePacket().sendPacket(player);
        }
    }

    @NotNull
    private ClientboundSetObjectivePacket getCreateObjectivePacket(@NotNull Player player) {
        return this.notFinalObjectivePacket(player).mode(ClientboundSetObjectivePacket.Mode.CREATE).build();
    }

    @NotNull
    private ClientboundSetObjectivePacket getUpdateObjectivePacket(@NotNull Player player) {
        return this.notFinalObjectivePacket(player).mode(ClientboundSetObjectivePacket.Mode.UPDATE).build();
    }

    @NotNull
    private ClientboundSetObjectivePacket.ClientboundSetObjectivePacketBuilder notFinalObjectivePacket(@NotNull Player player) {
        return ClientboundSetObjectivePacket.builder().objectiveKey(this.objectiveKey).title(this.title.asComponent(player)).criteriaType(ClientboundSetObjectivePacket.Type.INTEGER);
    }

    @NotNull
    private ClientboundSetObjectivePacket getDestroyObjectivePacket() {
        return ClientboundSetObjectivePacket.builder().objectiveKey(this.objectiveKey).mode(ClientboundSetObjectivePacket.Mode.DESTROY).build();
    }

    @NotNull
    private ClientboundSetDisplayObjectivePacket getDisplayObjectivePacket() {
        return ClientboundSetDisplayObjectivePacket.builder().slot(ClientboundSetDisplayObjectivePacket.DisplaySlot.SIDEBAR).objectiveKey(this.objectiveKey).build();
    }

    @NotNull
    private ClientboundSetScorePacket createScorePacket(int i, @NotNull String value) {
        return ClientboundSetScorePacket.builder().entityName(value).objectiveKey(this.objectiveKey).score(i).action(ClientboundSetScorePacket.ScoreboardAction.CHANGE).build();
    }

    @NotNull
    private ClientboundSetScorePacket destroyScore(@NotNull String value) {
        return ClientboundSetScorePacket.builder().entityName(value).objectiveKey(this.objectiveKey).action(ClientboundSetScorePacket.ScoreboardAction.REMOVE).build();
    }

    @NotNull
    private @NotNull List<@NotNull ClientboundSetScorePacket> allScores() {
        return this.lines.stream().map(entry -> this.createScorePacket(entry.getScore(), entry.getCache())).collect(Collectors.toList());
    }

    @NotNull
    public String crop(@NotNull String baseLine) {
        if (baseLine.length() > 40) {
            return baseLine.substring(0, 40);
        }
        return baseLine;
    }

    @Override
    @NotNull
    public ScoreboardTeam team(@NotNull String identifier) {
        ScoreboardTeamImpl team = new ScoreboardTeamImpl(this, identifier);
        this.teams.add(team);
        if (this.visible && !this.viewers.isEmpty()) {
            ClientboundSetPlayerTeamPacket packet = team.constructCreatePacket();
            packet.sendPacket(this.viewers);
        }
        return team;
    }

    protected void updateTitle0() {
        if (this.visible && !this.viewers.isEmpty()) {
            this.viewers.forEach(p -> this.getUpdateObjectivePacket((Player)p).sendPacket((Player)p));
        }
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull ScoreboardTeam> getTeams() {
        return this.teams;
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull ScoreEntry> getEntries() {
        return this.entries;
    }

    @Override
    @Nullable
    @Generated
    public DataContainer data() {
        return this.data;
    }

    @Override
    @Generated
    public ScoreSidebarImpl data(@Nullable DataContainer data) {
        this.data = data;
        return this;
    }

    public static class ScoreEntry {
        @NotNull
        private final String identifier;
        @NotNull
        private Component component;
        private int score;
        @Nullable
        private String cache;
        private boolean reloadCache;

        @Generated
        public ScoreEntry(@NotNull String identifier, @NotNull Component component) {
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            this.identifier = identifier;
            this.component = component;
        }

        @NotNull
        @Generated
        public String getIdentifier() {
            return this.identifier;
        }

        @NotNull
        @Generated
        public Component getComponent() {
            return this.component;
        }

        @Generated
        public int getScore() {
            return this.score;
        }

        @Nullable
        @Generated
        public String getCache() {
            return this.cache;
        }

        @Generated
        public boolean isReloadCache() {
            return this.reloadCache;
        }

        @Generated
        public void setComponent(@NotNull Component component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            this.component = component;
        }

        @Generated
        public void setScore(int score) {
            this.score = score;
        }

        @Generated
        public void setCache(@Nullable String cache) {
            this.cache = cache;
        }

        @Generated
        public void setReloadCache(boolean reloadCache) {
            this.reloadCache = reloadCache;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScoreEntry)) {
                return false;
            }
            ScoreEntry other = (ScoreEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getScore() != other.getScore()) {
                return false;
            }
            if (this.isReloadCache() != other.isReloadCache()) {
                return false;
            }
            String this$identifier = this.getIdentifier();
            String other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            Component this$component = this.getComponent();
            Component other$component = other.getComponent();
            if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
                return false;
            }
            String this$cache = this.getCache();
            String other$cache = other.getCache();
            return !(this$cache == null ? other$cache != null : !this$cache.equals(other$cache));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ScoreEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getScore();
            result = result * 59 + (this.isReloadCache() ? 79 : 97);
            String $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            Component $component = this.getComponent();
            result = result * 59 + ($component == null ? 43 : $component.hashCode());
            String $cache = this.getCache();
            result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ScoreSidebarImpl.ScoreEntry(identifier=" + this.getIdentifier() + ", component=" + String.valueOf(this.getComponent()) + ", score=" + this.getScore() + ", cache=" + this.getCache() + ", reloadCache=" + this.isReloadCache() + ")";
        }
    }
}

