/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.placeholders;

import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import sba.sl.spectator.BlockNBTComponent;
import sba.sl.spectator.Component;
import sba.sl.spectator.EntityNBTComponent;
import sba.sl.spectator.KeybindComponent;
import sba.sl.spectator.ScoreComponent;
import sba.sl.spectator.SelectorComponent;
import sba.sl.spectator.StorageNBTComponent;
import sba.sl.spectator.TextComponent;
import sba.sl.spectator.TranslatableComponent;
import sba.sl.spectator.mini.MiniMessageParser;
import sba.sl.spectator.mini.placeholders.Placeholder;
import sba.sl.spectator.mini.placeholders.StringLikePlaceholder;

public abstract class ComponentPlaceholder
implements Placeholder,
StringLikePlaceholder {
    @Pattern(value="[a-z\\d_-]+")
    @NotNull
    private final String name;

    @NotNull
    public abstract Component getValue();

    @Override
    @NotNull
    public <B extends Component.Builder<B, C>, C extends Component> B getResult(@NotNull MiniMessageParser parser, @NotNull @NotNull List<@NotNull String> arguments, Placeholder ... placeholders) {
        Component value = this.getValue();
        if (value instanceof TextComponent) {
            return (B)((TextComponent)value).toBuilder();
        }
        if (value instanceof TranslatableComponent) {
            return (B)((TranslatableComponent)value).toBuilder();
        }
        if (value instanceof BlockNBTComponent) {
            return (B)((BlockNBTComponent)value).toBuilder();
        }
        if (value instanceof EntityNBTComponent) {
            return (B)((EntityNBTComponent)value).toBuilder();
        }
        if (value instanceof KeybindComponent) {
            return (B)((KeybindComponent)value).toBuilder();
        }
        if (value instanceof ScoreComponent) {
            return (B)((ScoreComponent)value).toBuilder();
        }
        if (value instanceof SelectorComponent) {
            return (B)((SelectorComponent)value).toBuilder();
        }
        if (value instanceof StorageNBTComponent) {
            return (B)((StorageNBTComponent)value).toBuilder();
        }
        return Component.text().append(value);
    }

    @Override
    @NotNull
    public String getStringResult(@NotNull MiniMessageParser parser, @NotNull @NotNull List<@NotNull String> arguments, Placeholder ... placeholders) {
        return this.getResult(parser, arguments, placeholders).build().toPlainText();
    }

    @Generated
    public ComponentPlaceholder(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Override
    @NotNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentPlaceholder)) {
            return false;
        }
        ComponentPlaceholder other = (ComponentPlaceholder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComponentPlaceholder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ComponentPlaceholder(name=" + this.getName() + ")";
    }

    public static final class Lazy
    extends ComponentPlaceholder {
        @NotNull
        private final @NotNull Supplier<@NotNull Component> supplier;

        public Lazy(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull @NotNull Supplier<@NotNull Component> supplier) {
            super(name);
            this.supplier = supplier;
        }

        @Override
        @NotNull
        public Component getValue() {
            return this.supplier.get();
        }

        @NotNull
        @Generated
        public @NotNull Supplier<@NotNull Component> getSupplier() {
            return this.supplier;
        }
    }

    public static final class Constant
    extends ComponentPlaceholder {
        @NotNull
        private final Component value;

        public Constant(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull Component value) {
            super(name);
            this.value = value;
        }

        @Override
        @NotNull
        @Generated
        public Component getValue() {
            return this.value;
        }
    }
}

