/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.resolvers;

import java.util.ArrayList;
import java.util.List;
import java.util.PrimitiveIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.minitag.nodes.TagNode;
import sba.sl.spectator.BlockNBTComponent;
import sba.sl.spectator.Color;
import sba.sl.spectator.Component;
import sba.sl.spectator.EntityNBTComponent;
import sba.sl.spectator.KeybindComponent;
import sba.sl.spectator.ScoreComponent;
import sba.sl.spectator.SelectorComponent;
import sba.sl.spectator.StorageNBTComponent;
import sba.sl.spectator.TextComponent;
import sba.sl.spectator.TranslatableComponent;
import sba.sl.spectator.mini.MiniMessageParser;
import sba.sl.spectator.mini.placeholders.Placeholder;
import sba.sl.spectator.mini.resolvers.DoubleTagResolver;

public abstract class ColorChangingResolver
implements DoubleTagResolver {
    @Override
    @Nullable
    public <B extends Component.Builder<B, C>, C extends Component> B resolve(@NotNull MiniMessageParser parser, @NotNull B builder, @NotNull TagNode tag, Placeholder ... placeholders) {
        TagInstance instance = this.obtainNewTagInstance(tag);
        if (instance == null) {
            return builder;
        }
        C component = builder.build();
        int size = this.calculateSize((Component)component);
        instance.init(size);
        Component value = this.apply((Component)component, instance);
        if (value instanceof TextComponent) {
            return (B)((TextComponent)value).toBuilder();
        }
        if (value instanceof TranslatableComponent) {
            return (B)((TranslatableComponent)value).toBuilder();
        }
        if (value instanceof BlockNBTComponent) {
            return (B)((BlockNBTComponent)value).toBuilder();
        }
        if (value instanceof EntityNBTComponent) {
            return (B)((EntityNBTComponent)value).toBuilder();
        }
        if (value instanceof KeybindComponent) {
            return (B)((KeybindComponent)value).toBuilder();
        }
        if (value instanceof ScoreComponent) {
            return (B)((ScoreComponent)value).toBuilder();
        }
        if (value instanceof SelectorComponent) {
            return (B)((SelectorComponent)value).toBuilder();
        }
        if (value instanceof StorageNBTComponent) {
            return (B)((StorageNBTComponent)value).toBuilder();
        }
        return Component.text().append(value);
    }

    private int calculateSize(@NotNull Component component) {
        int size = 0;
        if (component instanceof TextComponent) {
            String content = ((TextComponent)component).content();
            size += content.codePointCount(0, content.length());
        } else {
            size = 1;
        }
        for (Component child : component.children()) {
            size += this.calculateSize(child);
        }
        return size;
    }

    @NotNull
    private Component apply(@NotNull Component component, @NotNull TagInstance instance) {
        if (component.color() != null) {
            int len = this.calculateSize(component);
            for (int i = 0; i < len; ++i) {
                instance.advanceColor();
            }
            return component;
        }
        List<Component> originalChildren = component.children();
        if ((component = component.withChildren(List.of())) instanceof TextComponent) {
            String content = ((TextComponent)component).content();
            TextComponent.Builder builder = ((TextComponent)component).toBuilder().content("");
            int[] holder = new int[1];
            PrimitiveIterator.OfInt it = content.codePoints().iterator();
            while (it.hasNext()) {
                holder[0] = it.nextInt();
                builder.append((Component)Component.text(new String(holder, 0, 1), instance.color()));
                instance.advanceColor();
            }
            component = builder.build();
        } else {
            component = component.withColorIfAbsent(instance.color());
            instance.advanceColor();
        }
        ArrayList<Component> newChildren = new ArrayList<Component>();
        for (Component child : originalChildren) {
            newChildren.add(this.apply(child, instance));
        }
        return component.withAppendix(newChildren);
    }

    @Nullable
    protected abstract TagInstance obtainNewTagInstance(@NotNull TagNode var1);

    protected static interface TagInstance {
        public void init(int var1);

        public void advanceColor();

        @NotNull
        public Color color();
    }
}

