/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.spectator.Component;
import sba.sl.spectator.TextComponent;
import sba.sl.spectator.TranslatableComponent;

public class SimpleTextReplacement {
    @NotNull
    private final Pattern matchPattern;
    @NotNull
    private final @NotNull Function<@NotNull MatchResult, @Nullable String> replacement;

    @NotNull
    public Component replace(@NotNull Component component) {
        List<Component> arguments;
        if (component instanceof TextComponent) {
            String content = ((TextComponent)component).content();
            if (!content.isEmpty()) {
                Matcher matcher = this.matchPattern.matcher(content);
                int lastIndex = 0;
                StringBuilder output = new StringBuilder();
                while (matcher.find()) {
                    output.append(content, lastIndex, matcher.start());
                    String replacement = this.replacement.apply(matcher);
                    if (replacement != null) {
                        output.append(replacement);
                    } else {
                        output.append(matcher.group());
                    }
                    lastIndex = matcher.end();
                }
                if (lastIndex < content.length()) {
                    output.append(content, lastIndex, content.length());
                }
                component = ((TextComponent)component).withContent(output.toString());
            }
        } else if (component instanceof TranslatableComponent && !(arguments = ((TranslatableComponent)component).args()).isEmpty()) {
            ArrayList<Component> narguments = new ArrayList<Component>(arguments.size());
            for (Component arg : arguments) {
                narguments.add(this.replace(arg));
            }
            component = ((TranslatableComponent)component).withArgs(narguments);
        }
        List<Component> children = component.children();
        if (!children.isEmpty()) {
            ArrayList<Component> newChildren = new ArrayList<Component>(children.size());
            for (Component child : children) {
                newChildren.add(this.replace(child));
            }
            component = component.withChildren(newChildren);
        }
        return component;
    }

    @Generated
    SimpleTextReplacement(@NotNull Pattern matchPattern, @NotNull @NotNull Function<@NotNull MatchResult, @Nullable String> replacement) {
        if (matchPattern == null) {
            throw new NullPointerException("matchPattern is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        this.matchPattern = matchPattern;
        this.replacement = replacement;
    }

    @Generated
    public static SimpleTextReplacementBuilder builder() {
        return new SimpleTextReplacementBuilder();
    }

    @NotNull
    @Generated
    public Pattern matchPattern() {
        return this.matchPattern;
    }

    @NotNull
    @Generated
    public @NotNull Function<@NotNull MatchResult, @Nullable String> replacement() {
        return this.replacement;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleTextReplacement)) {
            return false;
        }
        SimpleTextReplacement other = (SimpleTextReplacement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Pattern this$matchPattern = this.matchPattern();
        Pattern other$matchPattern = other.matchPattern();
        if (this$matchPattern == null ? other$matchPattern != null : !this$matchPattern.equals(other$matchPattern)) {
            return false;
        }
        Function<MatchResult, String> this$replacement = this.replacement();
        Function<MatchResult, String> other$replacement = other.replacement();
        return !(this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimpleTextReplacement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pattern $matchPattern = this.matchPattern();
        result = result * 59 + ($matchPattern == null ? 43 : $matchPattern.hashCode());
        Function<MatchResult, String> $replacement = this.replacement();
        result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SimpleTextReplacement(matchPattern=" + String.valueOf(this.matchPattern()) + ", replacement=" + String.valueOf(this.replacement()) + ")";
    }

    @Generated
    public static class SimpleTextReplacementBuilder {
        @Generated
        private Pattern matchPattern;
        @Generated
        private Function<@NotNull MatchResult, @Nullable String> replacement;

        @Generated
        SimpleTextReplacementBuilder() {
        }

        @Generated
        public SimpleTextReplacementBuilder matchPattern(@NotNull Pattern matchPattern) {
            if (matchPattern == null) {
                throw new NullPointerException("matchPattern is marked non-null but is null");
            }
            this.matchPattern = matchPattern;
            return this;
        }

        @Generated
        public SimpleTextReplacementBuilder replacement(@NotNull @NotNull Function<@NotNull MatchResult, @Nullable String> replacement) {
            if (replacement == null) {
                throw new NullPointerException("replacement is marked non-null but is null");
            }
            this.replacement = replacement;
            return this;
        }

        @Generated
        public SimpleTextReplacement build() {
            return new SimpleTextReplacement(this.matchPattern, this.replacement);
        }

        @Generated
        public String toString() {
            return "SimpleTextReplacement.SimpleTextReplacementBuilder(matchPattern=" + String.valueOf(this.matchPattern) + ", replacement=" + String.valueOf(this.replacement) + ")";
        }
    }
}

