/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.u.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.u.reflect.ClassMethod;
import sba.sl.u.reflect.Constructor;
import sba.sl.u.reflect.InstanceMethod;
import sba.sl.u.reflect.InvocationResult;
import sun.misc.Unsafe;

public final class Reflect {
    public static <T> Class<T> getClassSafe(String ... classNames) {
        return Reflect.getClassSafe(Map.of(), classNames);
    }

    public static <T> Class<T> getClassSafe(ClassLoader loader, String ... classNames) {
        return Reflect.getClassSafe(loader, Map.of(), classNames);
    }

    public static Class<?> getClassSafe(Map<String, String> replaceRules, String ... classNames) {
        for (String className : classNames) {
            try {
                for (Map.Entry<String, String> rule : replaceRules.entrySet()) {
                    className = className.replace(rule.getKey(), rule.getValue());
                }
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public static Class<?> getClassSafe(ClassLoader loader, Map<String, String> replaceRules, String ... classNames) {
        for (String className : classNames) {
            try {
                for (Map.Entry<String, String> rule : replaceRules.entrySet()) {
                    className = className.replace(rule.getKey(), rule.getValue());
                }
                return Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public static ClassMethod getMethod(@Language(value="JAVA", prefix="class X { void m() { ", suffix=".class; } }") String className, String names, Class<?> ... params) {
        return Reflect.getMethod(Reflect.getClassSafe(className), names.split(","), params);
    }

    public static ClassMethod getMethod(Class<?> clazz, String names, Class<?> ... params) {
        return Reflect.getMethod(clazz, names.split(","), params);
    }

    public static ClassMethod getMethod(@Language(value="JAVA", prefix="class X { void m() { ", suffix=".class; } }") String className, String[] names, Class<?> ... params) {
        return Reflect.getMethod(Reflect.getClassSafe(className), names, params);
    }

    public static ClassMethod getMethod(Class<?> clazz, String[] names, Class<?> ... params) {
        return Reflect.getMethod(Collections.singletonList(clazz), names, params);
    }

    public static ClassMethod getMethod(List<Class<?>> classes, String[] names, Class<?> ... params) {
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            block5: for (String name : names) {
                try {
                    Method method = clazz.getMethod(name.trim(), params);
                    return new ClassMethod(method);
                }
                catch (Throwable ignored) {
                    Class<?> clazz2 = clazz;
                    while (true) {
                        try {
                            Method method = clazz2.getDeclaredMethod(name.trim(), params);
                            method.setAccessible(true);
                            return new ClassMethod(method);
                        }
                        catch (Throwable throwable) {
                            if ((clazz2 = clazz2.getSuperclass()) != null && clazz2 != Object.class) continue;
                            continue block5;
                        }
                        break;
                    }
                }
            }
        }
        return new ClassMethod(null);
    }

    public static ClassMethod getMethod(Method method) {
        return new ClassMethod(method);
    }

    public static InstanceMethod getMethod(Object instance, String names, Class<?> ... params) {
        ClassMethod method = Reflect.getMethod(Reflect.retrieveClasses(instance), names.split(","), params);
        return new InstanceMethod(instance, method.getMethod());
    }

    public static List<InstanceMethod> getMethodsCalled(Object instance, String names, int parametersCount) {
        List<String> namesS = Arrays.asList(names.split(","));
        List<Class<?>> classes = Reflect.retrieveClasses(instance);
        return classes.stream().flatMap(aClass -> Arrays.stream(aClass.getMethods())).filter(method -> namesS.contains(method.getName()) && method.getParameterCount() == parametersCount).map(method -> new InstanceMethod(instance, (Method)method)).collect(Collectors.toList());
    }

    public static InstanceMethod getMethod(Object instance, String[] names, Class<?> ... params) {
        ClassMethod method = Reflect.getMethod(Reflect.retrieveClasses(instance), names, params);
        return new InstanceMethod(instance, method.getMethod());
    }

    public static InstanceMethod getMethod(Object instance, Method method) {
        return new InstanceMethod(instance, method);
    }

    public static InvocationResult getFieldResulted(Object instance, String names) {
        return new InvocationResult(Reflect.getField(instance, names));
    }

    public static InvocationResult getFieldResulted(Object instance, String[] names) {
        return new InvocationResult(Reflect.getField(instance, names));
    }

    public static InvocationResult getFieldResulted(Class<?> clazz, String names) {
        return new InvocationResult(Reflect.getField(clazz, names));
    }

    public static InvocationResult getFieldResulted(Field field) {
        return new InvocationResult(Reflect.getField(field));
    }

    public static InvocationResult getFieldResulted(Object instance, Field field) {
        return new InvocationResult(Reflect.getField(instance, field));
    }

    public static InvocationResult getFieldResulted(Class<?> clazz, String[] names) {
        return new InvocationResult(Reflect.getField(clazz, names));
    }

    public static InvocationResult getFieldResulted(Class<?> clazz, String names, Object instance) {
        return new InvocationResult(Reflect.getField(clazz, names, instance));
    }

    public static InvocationResult getFieldResulted(Class<?> clazz, String[] names, Object instance) {
        return new InvocationResult(Reflect.getField(clazz, names, instance));
    }

    public static Object getField(Object instance, String names) {
        return Reflect.getField(instance.getClass(), names.split(","), instance);
    }

    public static Object getField(Object instance, String[] names) {
        return Reflect.getField(instance.getClass(), names, instance);
    }

    public static Object getField(@Language(value="JAVA", prefix="class X { void m() { ", suffix=".class; } }") String className, String names) {
        Class clazz = Reflect.getClassSafe(className);
        if (clazz == null) {
            return null;
        }
        return Reflect.getField(clazz, names.split(","));
    }

    public static Object getField(Class<?> clazz, String names) {
        return Reflect.getField(clazz, names.split(","), null);
    }

    public static Object getField(Class<?> clazz, String[] names) {
        return Reflect.getField(clazz, names, null);
    }

    public static Object getField(Class<?> clazz, String names, Object instance) {
        return Reflect.getField(clazz, names.split(","), instance);
    }

    public static Object getField(Class<?> clazz, String[] names, Object instance) {
        block4: for (String name : names) {
            try {
                Field field = clazz.getField(name.trim());
                return field.get(instance);
            }
            catch (Throwable ignored) {
                Class<?> clazz1 = clazz;
                while (true) {
                    try {
                        Field field = clazz1.getDeclaredField(name.trim());
                        field.setAccessible(true);
                        return field.get(instance);
                    }
                    catch (Throwable throwable) {
                        if ((clazz1 = clazz1.getSuperclass()) != null && clazz1 != Object.class) continue;
                        continue block4;
                    }
                    break;
                }
            }
        }
        return null;
    }

    public static Object getField(Field field) {
        return Reflect.getField(null, field);
    }

    public static Object getField(Object instance, Field field) {
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object setField(Object instance, String names, Object set) {
        return Reflect.setField(instance.getClass(), names.split(","), instance, set);
    }

    public static Object setField(Object instance, String[] names, Object set) {
        return Reflect.setField(instance.getClass(), names, instance, set);
    }

    public static Object setField(Class<?> clazz, String names, Object set) {
        return Reflect.setField(clazz, names.split(","), null, set);
    }

    public static Object setField(Class<?> clazz, String[] names, Object set) {
        return Reflect.setField(clazz, names, null, set);
    }

    public static Object setField(Class<?> clazz, String names, Object instance, Object set) {
        return Reflect.setField(clazz, names.split(","), instance, set);
    }

    public static Object setField(Class<?> clazz, String[] names, Object instance, Object set) {
        block6: for (String name : names) {
            try {
                Field field = clazz.getField(name.trim());
                field.set(instance, set);
                return field.get(instance);
            }
            catch (Throwable ignored) {
                Class<?> clazz1 = clazz;
                while (true) {
                    try {
                        Field field = clazz1.getDeclaredField(name.trim());
                        field.setAccessible(true);
                        if ((field.getModifiers() & 0x10) == 16) {
                            try {
                                Field modifiersField = Field.class.getDeclaredField("modifiers");
                                modifiersField.setAccessible(true);
                                int modifiers = modifiersField.getInt(field);
                                modifiersField.setInt(field, modifiers &= 0xFFFFFFEF);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        field.set(instance, set);
                        return field.get(instance);
                    }
                    catch (Throwable throwable) {
                        if ((clazz1 = clazz1.getSuperclass()) != null && clazz1 != Object.class) continue;
                        continue block6;
                    }
                    break;
                }
            }
        }
        return null;
    }

    public static Object setField(Field field, Object value) {
        return Reflect.setField(null, field, value);
    }

    public static Object setField(Object instance, Field field, Object value) {
        try {
            field.setAccessible(true);
            if ((field.getModifiers() & 0x10) == 16) {
                try {
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    int modifiers = modifiersField.getInt(field);
                    modifiersField.setInt(field, modifiers &= 0xFFFFFFEF);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            field.set(instance, value);
            return field.get(instance);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object findEnumConstant(Class<?> enumClass, String constantNames) {
        return Reflect.findEnumConstant(enumClass, constantNames.split(","));
    }

    public static Object findEnumConstant(Class<?> enumClass, String[] constantNames) {
        ?[] enums = enumClass.getEnumConstants();
        if (enums != null) {
            for (Object enumeration : enums) {
                Object name = Reflect.getMethod(enumeration, "name", new Class[0]).invoke(new Object[0]);
                for (String constant : constantNames) {
                    if (!constant.equals(name)) continue;
                    return enumeration;
                }
            }
        }
        return null;
    }

    public static Object fastInvoke(Object instance, String names) {
        return Reflect.fastInvoke(instance, names.split(","));
    }

    public static Object fastInvoke(Object instance, String[] names) {
        return Reflect.fastInvoke(instance.getClass(), names, instance);
    }

    public static Object fastInvoke(Class<?> className, String names) {
        return Reflect.fastInvoke(className, names.split(","));
    }

    public static Object fastInvoke(Class<?> className, String[] names) {
        return Reflect.fastInvoke(className, names, null);
    }

    public static Object fastInvoke(Class<?> className, String names, Object instance) {
        return Reflect.fastInvoke(className, names.split(","), instance);
    }

    public static Object fastInvoke(Class<?> className, String[] names, Object instance) {
        ClassMethod method = Reflect.getMethod(className, names, new Class[0]);
        return method.invokeInstance(instance, new Object[0]);
    }

    public static Object fastInvoke(Method method) {
        return Reflect.getMethod(method).invokeStatic(new Object[0]);
    }

    public static Object fastInvoke(Object instance, Method method) {
        return Reflect.getMethod(instance, method).invoke(new Object[0]);
    }

    public static Object fastInvoke(Method method, Object ... params) {
        return Reflect.fastInvoke(null, method, params);
    }

    public static Object fastInvoke(Object instance, Method method, Object ... params) {
        return Reflect.getMethod(instance, method).invoke(params);
    }

    public static InvocationResult fastInvokeResulted(Object instance, String names) {
        return Reflect.fastInvokeResulted(instance, names.split(","));
    }

    public static InvocationResult fastInvokeResulted(Object instance, String[] names) {
        return Reflect.fastInvokeResulted(instance.getClass(), names, instance);
    }

    public static InvocationResult fastInvokeResulted(Class<?> className, String names) {
        return Reflect.fastInvokeResulted(className, names.split(","));
    }

    public static InvocationResult fastInvokeResulted(Class<?> className, String[] names) {
        return Reflect.fastInvokeResulted(className, names, null);
    }

    public static InvocationResult fastInvokeResulted(Class<?> className, String names, Object instance) {
        return Reflect.fastInvokeResulted(className, names.split(","), instance);
    }

    public static InvocationResult fastInvokeResulted(Class<?> className, String[] names, Object instance) {
        ClassMethod method = Reflect.getMethod(className, names, new Class[0]);
        return method.invokeInstanceResulted(instance, new Object[0]);
    }

    public static InvocationResult fastInvokeResulted(Method method) {
        return Reflect.getMethod(method).invokeStaticResulted(new Object[0]);
    }

    public static InvocationResult fastInvokeResulted(Object instance, Method method) {
        return Reflect.getMethod(instance, method).invokeResulted(new Object[0]);
    }

    public static InvocationResult fastInvokeResulted(Method method, Object ... params) {
        return Reflect.fastInvokeResulted(null, method, params);
    }

    public static InvocationResult fastInvokeResulted(Object instance, Method method, Object ... params) {
        return Reflect.getMethod(instance, method).invokeResulted(params);
    }

    public static List<Class<?>> retrieveClasses(Object instance) {
        if (Proxy.isProxyClass(instance.getClass())) {
            return Arrays.asList(instance.getClass().getInterfaces());
        }
        return Collections.singletonList(instance.getClass());
    }

    public static Optional<InvocationHandler> asInvocationHandler(Object instance) {
        if (instance != null && Proxy.isProxyClass(instance.getClass())) {
            return Optional.of(Proxy.getInvocationHandler(instance));
        }
        return Optional.empty();
    }

    public static boolean isInstance(Object instance, @Language(value="JAVA", prefix="class X { void m() { ", suffix=".class; } }") String className) {
        return Reflect.isInstance(instance, Reflect.getClassSafe(className));
    }

    public static boolean isInstance(Object instance, Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.isInstance(instance);
    }

    public static boolean has(@Language(value="JAVA", prefix="class X { void m() { ", suffix=".class; } }") String className) {
        return Reflect.getClassSafe(className) != null;
    }

    public static boolean hasAsInterface(@Language(value="JAVA", prefix="class X { void m() { ", suffix=".class; } }") String className) {
        Class clazz = Reflect.getClassSafe(className);
        return clazz != null && clazz.isInterface();
    }

    public static boolean has(Class<?> clazz) {
        return clazz != null;
    }

    public static boolean hasMethod(@Language(value="JAVA", prefix="class X { void m() { ", suffix=".class; } }") String className, String methodNames, Class<?> ... arguments) {
        return Reflect.getMethod(className, methodNames, arguments).getMethod() != null;
    }

    public static boolean hasMethod(Object instance, String methodNames, Class<?> ... arguments) {
        return Reflect.hasMethod(instance.getClass(), methodNames, arguments);
    }

    public static boolean hasMethod(Class<?> type, String methodNames, Class<?> ... arguments) {
        return Reflect.getMethod(type, methodNames, arguments).getMethod() != null;
    }

    public static Constructor constructor(@Language(value="JAVA", prefix="class X { void m() { ", suffix=".class; } }") String className, Class<?> ... arguments) {
        return Reflect.constructor(Reflect.getClassSafe(className), arguments);
    }

    public static Constructor constructor(Class<?> type, Class<?> ... arguments) {
        try {
            return new Constructor(type.getConstructor(arguments));
        }
        catch (Exception exception) {
            return new Constructor(null);
        }
    }

    @Nullable
    public static <T extends Enum<T>> T newEnumValue(@NotNull Class<T> type, @NotNull String name, int ordinal) {
        try {
            java.lang.reflect.Constructor<?> constructor = Unsafe.class.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            Unsafe unsafe = (Unsafe)constructor.newInstance(new Object[0]);
            Object newValue = unsafe.allocateInstance(type);
            Field ordinalField = Enum.class.getDeclaredField("ordinal");
            unsafe.putInt(newValue, unsafe.objectFieldOffset(ordinalField), ordinal);
            Field nameField = Enum.class.getDeclaredField("name");
            unsafe.putObject(newValue, unsafe.objectFieldOffset(nameField), name);
            return (T)((Enum)newValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Constructor constructor(java.lang.reflect.Constructor<?> constructor) {
        return new Constructor(constructor);
    }

    public static Object construct(@Language(value="JAVA", prefix="class X { void m() { ", suffix=".class; } }") String className) {
        return Reflect.construct(Reflect.getClassSafe(className));
    }

    public static Object construct(Class<?> type) {
        return Reflect.constructor(type, new Class[0]).construct(new Object[0]);
    }

    public static Object construct(java.lang.reflect.Constructor<?> constructor, Object ... params) {
        return Reflect.constructor(constructor).construct(params);
    }

    public static InvocationResult constructResulted(@Language(value="JAVA", prefix="class X { void m() { ", suffix=".class; } }") String className) {
        return Reflect.constructResulted(Reflect.getClassSafe(className));
    }

    public static InvocationResult constructResulted(Class<?> type) {
        return Reflect.constructor(type, new Class[0]).constructResulted(new Object[0]);
    }

    public static InvocationResult constructResulted(java.lang.reflect.Constructor<?> constructor, Object ... params) {
        return Reflect.constructor(constructor).constructResulted(params);
    }

    @Generated
    private Reflect() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

