/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.w;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;
import sba.sl.api.types.server.WorldHolder;
import sba.sl.b.BlockPlacement;
import sba.sl.e.Entity;
import sba.sl.pa.Particle;
import sba.sl.spectator.audience.PlayerAudience;
import sba.sl.u.RawValueHolder;
import sba.sl.w.Location;
import sba.sl.w.chunk.Chunk;
import sba.sl.w.difficulty.DifficultyType;
import sba.sl.w.dimension.DimensionType;
import sba.sl.w.gamerule.GameRuleType;

public interface World
extends Wrapper,
RawValueHolder,
PlayerAudience.ForwardingToMulti,
WorldHolder {
    @NotNull
    public UUID getUuid();

    @NotNull
    public String getName();

    public int getMinY();

    public int getMaxY();

    @NotNull
    public DifficultyType getDifficulty();

    @NotNull
    public DimensionType getDimension();

    @Nullable
    public Chunk getChunkAt(int var1, int var2);

    @Nullable
    public Chunk getChunkAt(@NotNull Location var1);

    @NotNull
    public @NotNull List<@NotNull Entity> getEntities();

    @NotNull
    default public <T extends Entity> @NotNull List<@NotNull T> getEntitiesByClass(Class<T> clazz) {
        return this.getEntities().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    @Nullable
    public <T> T getGameRuleValue(@NotNull GameRuleType var1);

    public <T> void setGameRuleValue(@NotNull GameRuleType var1, @NotNull T var2);

    public long getTime();

    public void setTime(long var1);

    public void sendParticle(@NotNull Particle var1, @NotNull Location var2);

    public boolean isSpawningOfAnimalsAllowed();

    public boolean isSpawningOfMonstersAllowed();

    @NotNull
    public BlockPlacement getHighestBlockAt(int var1, int var2);

    public int getHighestYAt(int var1, int var2);
}

