/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.w.gamerule;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.world.gamerule.GameRuleRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface GameRuleType
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.GAME_RULE_TYPE) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static GameRuleType of(@MinecraftType(value=MinecraftType.Type.GAME_RULE_TYPE) @NotNull Object gameRule) {
        GameRuleType result = GameRuleType.ofNullable(gameRule);
        Preconditions.checkNotNullIllegal(result, "Could not find game rule: " + String.valueOf(gameRule));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static GameRuleType ofNullable(@MinecraftType(value=MinecraftType.Type.GAME_RULE_TYPE) @Nullable Object gameRule) {
        if (gameRule instanceof GameRuleType) {
            return (GameRuleType)gameRule;
        }
        return (GameRuleType)GameRuleRegistry.getInstance().resolveMapping(gameRule);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull GameRuleType> all() {
        return GameRuleRegistry.getInstance().getRegistryItemStream();
    }
}

