/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.pronzelib.scoreboards;

import io.github.pronze.lib.pronzelib.scoreboards.ScoreboardManager;
import io.github.pronze.lib.pronzelib.scoreboards.api.PlaceholderFunction;
import io.github.pronze.lib.pronzelib.scoreboards.api.UpdateCallback;
import io.github.pronze.lib.pronzelib.scoreboards.builder.ScoreboardBuilder;
import io.github.pronze.lib.pronzelib.scoreboards.data.PlaceholderData;
import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.board.BoardPlayer;
import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.board.ConfigBoard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import sba.sl.pa.Players;

public class Scoreboard {
    private ConfigBoard holder;
    protected BukkitTask animationTask;
    protected BukkitTask updateTask;
    private long ANIMATION_TASK_INTERVAL = 2L;
    private long UPDATE_TASK_INTERVAL = 20L;
    private boolean occupyMaxHeight = false;
    private boolean occupyMaxWidth = false;
    private UpdateCallback callback;
    private List<String> animatedTitle;
    private boolean updateTaskRunning = false;
    private boolean animationTaskRunning = false;
    private sba.sl.pa.Player player;
    private List<String> lines;
    private PlaceholderFunction papiFunction;
    private final HashMap<String, Object> persistentPlaceholders = new HashMap();

    public Scoreboard(Player player) {
        if (ScoreboardManager.getPluginInstance() == null) {
            throw new NullPointerException("Plugin instance not set! call ScoreboardManager.install() first");
        }
        this.player = Players.wrapPlayer(player);
        this.holder = new ConfigBoard(player.getName());
        BoardPlayer.getBoardPlayer(player).attachConfigBoard(this.holder);
        this.holder.runTaskTimerAsynchronously((Plugin)ScoreboardManager.getPluginInstance(), 1L, 1L);
        this.startUpdateTask();
        ScoreboardManager.getInstance().addToCache(this);
    }

    public static ScoreboardBuilder builder() {
        return new ScoreboardBuilder();
    }

    public void setLines(List<String> lines) {
        if (lines == null || lines.isEmpty()) {
            return;
        }
        lines = this.resizeContent(lines);
        boolean i = false;
        this.lines = lines;
        this.refresh();
    }

    public void setVisibility(boolean visible) {
        if (visible) {
            BoardPlayer.getBoardPlayer(this.player.as(Player.class)).attachConfigBoard(this.holder);
        } else {
            BoardPlayer.getBoardPlayer(this.player.as(Player.class)).kill();
        }
        this.refresh();
    }

    public void refresh() {
        if (this.lines != null) {
            this.holder.setLines(this.lines.stream().map(l -> this.setPlaceholders((String)l)).collect(Collectors.toList()));
        }
    }

    @NotNull
    private String setPlaceholders(String content) {
        Objects.requireNonNull(content, "Content cannot be null");
        if (this.papiFunction != null) {
            content = this.papiFunction.handleReplace(new PlaceholderData(this.player, this, content));
        }
        for (Map.Entry<String, Object> entry : this.persistentPlaceholders.entrySet()) {
            content = content.replace(entry.getKey(), entry.getValue().toString());
        }
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            content = PlaceholderAPI.setPlaceholders((Player)this.player.as(Player.class), (String)content);
        }
        return content;
    }

    public void setTitle(String title, boolean animate) {
        Objects.requireNonNull(title, "Title cannot be null");
        this.holder.setTitle(List.of(title), this.ANIMATION_TASK_INTERVAL);
    }

    public void setAnimatedTitle(List<String> animatedTitle) {
        if (animatedTitle == null || animatedTitle.isEmpty()) {
            throw new IllegalArgumentException("Animated title cannot be null or empty");
        }
        if (animatedTitle.size() == 1) {
            this.setTitle(animatedTitle.get(0), false);
            return;
        }
        this.holder.setTitle(animatedTitle, this.ANIMATION_TASK_INTERVAL);
    }

    private void cancelUpdateTask() {
        if (this.updateTask != null) {
            if (Bukkit.getScheduler().isQueued(this.updateTask.getTaskId()) || Bukkit.getScheduler().isCurrentlyRunning(this.updateTask.getTaskId()) || this.updateTaskRunning) {
                this.updateTask.cancel();
            }
            this.updateTask = null;
        }
    }

    public String makeUnique(String toUnique, List<String> from) {
        if (toUnique == null) {
            toUnique = " ";
        }
        StringBuilder stringBuilder = new StringBuilder(toUnique);
        while (from.contains(stringBuilder.toString()) || this.occupyMaxWidth && !from.contains(stringBuilder.toString()) && stringBuilder.length() < 40) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public List<String> resizeContent(List<String> lines) {
        ArrayList<String> newList = new ArrayList<String>();
        lines.forEach(line -> newList.add(this.makeUnique((String)line, (List<String>)newList)));
        if (newList.size() > 15) {
            return newList.subList(0, 15);
        }
        if (this.occupyMaxHeight) {
            while (newList.size() < 16) {
                newList.add(this.makeUnique(" ", newList));
            }
        }
        return newList;
    }

    public void destroy() {
        this.holder.cancel();
        this.cancelTasks();
        ScoreboardManager.getInstance().removeFromCache(this.player.getUniqueId());
    }

    public void setObjective(String objectiveName) {
        this.holder.setObjective(objectiveName);
    }

    public void setPlaceholderHook(PlaceholderFunction papiFunction) {
        this.papiFunction = papiFunction;
    }

    public void addInternalPlaceholder(String placeholder, Object value) {
        this.persistentPlaceholders.put(placeholder, value.toString());
    }

    public void setUpdateTaskInterval(long interval) {
        this.UPDATE_TASK_INTERVAL = interval;
        this.startUpdateTask();
    }

    public void setAnimationTaskInterval(long interval) {
        this.ANIMATION_TASK_INTERVAL = interval;
    }

    public void setCallback(UpdateCallback callback) {
        this.callback = callback;
    }

    protected void startUpdateTask() {
        this.cancelUpdateTask();
        this.updateTaskRunning = true;
        this.updateTask = new BukkitRunnable(){

            public void run() {
                boolean cancelled;
                if (Scoreboard.this.holder == null) {
                    this.cancel();
                    return;
                }
                if (Scoreboard.this.callback != null && (cancelled = Scoreboard.this.callback.onCallback(Scoreboard.this))) {
                    return;
                }
                Scoreboard.this.refresh();
            }
        }.runTaskTimer((Plugin)ScoreboardManager.getPluginInstance(), 0L, this.UPDATE_TASK_INTERVAL);
    }

    protected void cancelTasks() {
        this.cancelUpdateTask();
    }

    public ConfigBoard getHolder() {
        return this.holder;
    }

    public void setOccupyMaxHeight(boolean occupyMaxHeight) {
        this.occupyMaxHeight = occupyMaxHeight;
    }

    public void setOccupyMaxWidth(boolean occupyMaxWidth) {
        this.occupyMaxWidth = occupyMaxWidth;
    }

    public sba.sl.pa.Player getPlayer() {
        return this.player;
    }
}

