/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.pronzelib.scoreboards.builder;

import io.github.pronze.lib.pronzelib.scoreboards.Scoreboard;
import io.github.pronze.lib.pronzelib.scoreboards.api.PlaceholderFunction;
import io.github.pronze.lib.pronzelib.scoreboards.api.UpdateCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.entity.Player;

public class ScoreboardBuilder {
    private final Map<String, String> placeholders = new HashMap<String, String>();
    private Scoreboard scoreboard;
    private Player holder;
    private boolean animation;
    private boolean occupyWidth;
    private boolean occupyHeight;
    private long interval = 20L;
    private long animationInterval = 2L;
    private String title;
    private String objectiveName = "";
    private List<String> lines;
    private List<String> animatedTitle;
    private PlaceholderFunction papiFunction;
    private UpdateCallback updateCallback;

    public ScoreboardBuilder updateCallback(UpdateCallback callback) {
        this.updateCallback = callback;
        return this;
    }

    public ScoreboardBuilder placeholder(String placeholder, Object value) {
        this.placeholders.put(placeholder, value.toString());
        return this;
    }

    public ScoreboardBuilder placeholderHook(PlaceholderFunction papiFunction) {
        this.papiFunction = papiFunction;
        return this;
    }

    public ScoreboardBuilder player(Player player) {
        this.holder = player;
        return this;
    }

    public ScoreboardBuilder lines(List<String> lines) {
        this.lines = lines;
        return this;
    }

    public ScoreboardBuilder animate(boolean animate) {
        this.animation = animate;
        return this;
    }

    public ScoreboardBuilder title(String title) {
        this.title = title;
        return this;
    }

    public ScoreboardBuilder animatedTitle(List<String> title) {
        this.animatedTitle = title;
        return this;
    }

    public ScoreboardBuilder occupyMaxHeight(boolean bool) {
        this.occupyHeight = bool;
        return this;
    }

    public ScoreboardBuilder occupyMaxWidth(boolean bool) {
        this.occupyWidth = bool;
        return this;
    }

    public ScoreboardBuilder displayObjective(String objectiveName) {
        this.objectiveName = objectiveName;
        return this;
    }

    public ScoreboardBuilder updateInterval(long interval) {
        this.interval = interval;
        return this;
    }

    public ScoreboardBuilder animationInterval(long interval) {
        this.animationInterval = interval;
        return this;
    }

    public Scoreboard build() {
        Objects.requireNonNull(this.holder, "Holder cannot be null");
        this.scoreboard = new Scoreboard(this.holder);
        this.scoreboard.setAnimationTaskInterval(this.animationInterval);
        this.scoreboard.setOccupyMaxHeight(this.occupyHeight);
        this.scoreboard.setOccupyMaxWidth(this.occupyWidth);
        this.scoreboard.setUpdateTaskInterval(this.interval);
        if (this.title != null) {
            this.scoreboard.setAnimatedTitle(List.of(this.title));
        }
        if (this.lines != null) {
            this.scoreboard.setLines(this.lines);
        }
        if (this.papiFunction != null) {
            this.scoreboard.setPlaceholderHook(this.papiFunction);
        }
        if (this.animatedTitle != null) {
            this.scoreboard.setAnimatedTitle(this.animatedTitle);
        }
        if (this.updateCallback != null) {
            this.scoreboard.setCallback(this.updateCallback);
        }
        Map<String, String> placeholders = this.placeholders;
        Scoreboard scoreboard = this.scoreboard;
        Objects.requireNonNull(scoreboard);
        scoreboard.setObjective(this.objectiveName);
        placeholders.forEach(scoreboard::addInternalPlaceholder);
        return this.scoreboard;
    }
}

