/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.plugin;

import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.plugin.Session;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigControl {
    private static ConfigControl instance = null;
    HashMap<String, FileConfiguration> designations = new HashMap();

    public static ConfigControl get() {
        if (instance != null) {
            return instance;
        }
        return new ConfigControl();
    }

    private ConfigControl() {
        instance = this;
        this.createDataFiles();
    }

    public void createDataFiles() {
        if (!Session.getSession().plugin.getDataFolder().exists()) {
            Session.getSession().plugin.getDataFolder().mkdirs();
        }
        this.createConfigFile("settings");
        this.createConfigFile("language");
    }

    public void purge() {
        this.designations.clear();
    }

    public void createConfigFile(String name) {
        File f = new File(Session.getSession().plugin.getDataFolder(), name + ".yml");
        boolean needCopyDefaults = false;
        try {
            if (!f.exists()) {
                f.createNewFile();
                needCopyDefaults = true;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (needCopyDefaults) {
            try {
                InputStreamReader defConfigStream = new InputStreamReader(ConfigControl.class.getResourceAsStream("/" + name + ".yml"), "UTF-8");
                PrintWriter writer = new PrintWriter(f, "UTF-8");
                writer.print(this.read(defConfigStream));
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        YamlConfiguration fc = YamlConfiguration.loadConfiguration((File)f);
        this.designations.put(name, (FileConfiguration)fc);
    }

    public void reloadConfigs() {
        this.purge();
        this.createDataFiles();
    }

    public FileConfiguration gc(String fc) {
        return this.designations.get(fc);
    }

    public String read(Reader r) throws IOException {
        int numCharsRead;
        char[] arr = new char[8192];
        StringBuilder buffer = new StringBuilder();
        while ((numCharsRead = r.read(arr, 0, arr.length)) != -1) {
            buffer.append(arr, 0, numCharsRead);
        }
        r.close();
        return buffer.toString();
    }
}

