/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.utils.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Scanner;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import sba.sl.pu.ServiceManager;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.methods.OnPostEnable;
import sba.sl.u.reflect.Reflect;

@Service
@ServiceDependencies(dependsOn={SBAConfig.class})
public class UpdateChecker {
    private String version;
    private boolean isPendingUpdate = false;
    private JavaPlugin plugin;

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public static UpdateChecker getInstance() {
        return ServiceManager.get(UpdateChecker.class);
    }

    @OnPostEnable
    public void checkForUpdates() {
        if (SBA.isBroken()) {
            return;
        }
        if (SBA.getInstance().isSnapshot()) {
            return;
        }
        if (SBAConfig.getInstance().shouldCheckUpdate()) {
            new Thread(() -> {
                try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=99149").openStream();
                     Scanner scanner = new Scanner(inputStream);){
                    if (scanner.hasNext()) {
                        this.promptUpdate(scanner.next());
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }).start();
        }
    }

    private void promptUpdate(@NotNull String version) {
        this.version = version;
        if (!version.equalsIgnoreCase(SBA.getInstance().getVersion())) {
            if (SBAConfig.getInstance().shouldWarnConsoleAboutUpdate()) {
                Bukkit.getLogger().info("\u00a7e\u00a7lTHERE IS A NEW UPDATE AVAILABLE Version: " + version);
                Bukkit.getLogger().info("Download it from here: https://www.spigotmc.org/resources/sba-screaming-bedwars-addon-1-9-4-1-18-1.99149/ or run \u00a7e/sba updateplugin");
            }
            this.isPendingUpdate = true;
        } else {
            Bukkit.getLogger().info("No updates found");
        }
    }

    public void sendToUser(@NotNull Player player) {
        player.sendMessage("[SBA] \u00a7eTHERE IS A NEW UPDATE AVAILABLE Version: " + this.version);
        player.sendMessage("Download it from here: https://www.spigotmc.org/resources/sba-screaming-bedwars-addon-1-9-4-1-18-1.99149/ or run \u00a7e/sba updateplugin");
    }

    public void update(final @NotNull CommandSender sender) {
        String newVersion = this.version;
        if (!newVersion.equalsIgnoreCase(SBA.getInstance().getVersion())) {
            try {
                new BukkitRunnable(){

                    public void run() {
                        try {
                            int grab;
                            URL downloadUrl = new URL("https://api.spiget.org/v2/resources/99149/download");
                            HttpURLConnection httpConnection = (HttpURLConnection)downloadUrl.openConnection();
                            httpConnection.setRequestProperty("User-Agent", "SpigotResourceUpdater");
                            int grabSize = 2048;
                            BufferedInputStream in = new BufferedInputStream(httpConnection.getInputStream());
                            File pluginFile = (File)Reflect.fastInvoke((Object)UpdateChecker.this.plugin, "getFile");
                            FileOutputStream fos = new FileOutputStream(pluginFile);
                            BufferedOutputStream bout = new BufferedOutputStream(fos, grabSize);
                            byte[] data = new byte[grabSize];
                            while ((grab = in.read(data, 0, grabSize)) >= 0) {
                                bout.write(data, 0, grab);
                            }
                            bout.close();
                            in.close();
                            fos.close();
                            try {
                                sender.sendMessage("Plugin JAR updated, please restart your server to receive the update");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Bukkit.getServer().shutdown();
                        }
                        catch (Exception ex) {
                            Logger.error("Error occurred while updating . {}", ex);
                        }
                    }
                }.runTaskAsynchronously((Plugin)this.plugin);
            }
            catch (Exception ex) {
                Logger.error("Error occurred while updating . {}", ex);
            }
        }
    }

    public boolean isPendingUpdate() {
        return this.isPendingUpdate;
    }
}

