/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.api.Team;

public class GameTeamData {
    private int sharpness;
    private int protection;
    private int efficiency;
    private int knockback;
    private boolean purchasedPool;
    private boolean purchasedBlindTrap;
    private boolean purchasedMinerTrap;
    private boolean purchasedDragonUpgrade;
    private final Location targetBlockLoc;
    private Map<String, Boolean> isPurchased = new HashMap<String, Boolean>();
    private Map<String, Integer> enchantLevel = new HashMap<String, Integer>();

    public static GameTeamData of(@NotNull Team team) {
        return new GameTeamData(team.getTargetBlock());
    }

    public Integer get(String propertyName) {
        if (this.enchantLevel.containsKey(propertyName)) {
            return this.enchantLevel.get(propertyName);
        }
        return 0;
    }

    public void set(String propertyName, @NotNull Integer level) {
        this.enchantLevel.put(propertyName, level);
    }

    public void setPurchased(boolean b, String trap_identifier) {
        this.isPurchased.put(trap_identifier, b);
    }

    public boolean isPuchased(String trap_identifier) {
        return this.isPurchased.get(trap_identifier) != null && this.isPurchased.get(trap_identifier) != false;
    }

    public Iterable<String> getEnabledTraps() {
        List<String> ret = this.isPurchased.entrySet().stream().filter(x -> (Boolean)x.getValue()).map(x -> (String)x.getKey()).collect(Collectors.toList());
        return ret;
    }

    private GameTeamData(Location targetBlockLoc) {
        this.targetBlockLoc = targetBlockLoc;
    }

    public static GameTeamData of(Location targetBlockLoc) {
        return new GameTeamData(targetBlockLoc);
    }

    public int getSharpness() {
        return this.sharpness;
    }

    public int getProtection() {
        return this.protection;
    }

    public int getEfficiency() {
        return this.efficiency;
    }

    public int getKnockback() {
        return this.knockback;
    }

    public boolean isPurchasedPool() {
        return this.purchasedPool;
    }

    public boolean isPurchasedBlindTrap() {
        return this.purchasedBlindTrap;
    }

    public boolean isPurchasedMinerTrap() {
        return this.purchasedMinerTrap;
    }

    public boolean isPurchasedDragonUpgrade() {
        return this.purchasedDragonUpgrade;
    }

    public Location getTargetBlockLoc() {
        return this.targetBlockLoc;
    }

    public Map<String, Boolean> getIsPurchased() {
        return this.isPurchased;
    }

    public Map<String, Integer> getEnchantLevel() {
        return this.enchantLevel;
    }

    public void setSharpness(int sharpness) {
        this.sharpness = sharpness;
    }

    public void setProtection(int protection) {
        this.protection = protection;
    }

    public void setEfficiency(int efficiency) {
        this.efficiency = efficiency;
    }

    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    public void setPurchasedPool(boolean purchasedPool) {
        this.purchasedPool = purchasedPool;
    }

    public void setPurchasedBlindTrap(boolean purchasedBlindTrap) {
        this.purchasedBlindTrap = purchasedBlindTrap;
    }

    public void setPurchasedMinerTrap(boolean purchasedMinerTrap) {
        this.purchasedMinerTrap = purchasedMinerTrap;
    }

    public void setPurchasedDragonUpgrade(boolean purchasedDragonUpgrade) {
        this.purchasedDragonUpgrade = purchasedDragonUpgrade;
    }

    public void setIsPurchased(Map<String, Boolean> isPurchased) {
        this.isPurchased = isPurchased;
    }

    public void setEnchantLevel(Map<String, Integer> enchantLevel) {
        this.enchantLevel = enchantLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GameTeamData)) {
            return false;
        }
        GameTeamData other = (GameTeamData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSharpness() != other.getSharpness()) {
            return false;
        }
        if (this.getProtection() != other.getProtection()) {
            return false;
        }
        if (this.getEfficiency() != other.getEfficiency()) {
            return false;
        }
        if (this.getKnockback() != other.getKnockback()) {
            return false;
        }
        if (this.isPurchasedPool() != other.isPurchasedPool()) {
            return false;
        }
        if (this.isPurchasedBlindTrap() != other.isPurchasedBlindTrap()) {
            return false;
        }
        if (this.isPurchasedMinerTrap() != other.isPurchasedMinerTrap()) {
            return false;
        }
        if (this.isPurchasedDragonUpgrade() != other.isPurchasedDragonUpgrade()) {
            return false;
        }
        Location this$targetBlockLoc = this.getTargetBlockLoc();
        Location other$targetBlockLoc = other.getTargetBlockLoc();
        if (this$targetBlockLoc == null ? other$targetBlockLoc != null : !this$targetBlockLoc.equals(other$targetBlockLoc)) {
            return false;
        }
        Map<String, Boolean> this$isPurchased = this.getIsPurchased();
        Map<String, Boolean> other$isPurchased = other.getIsPurchased();
        if (this$isPurchased == null ? other$isPurchased != null : !((Object)this$isPurchased).equals(other$isPurchased)) {
            return false;
        }
        Map<String, Integer> this$enchantLevel = this.getEnchantLevel();
        Map<String, Integer> other$enchantLevel = other.getEnchantLevel();
        return !(this$enchantLevel == null ? other$enchantLevel != null : !((Object)this$enchantLevel).equals(other$enchantLevel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GameTeamData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSharpness();
        result = result * 59 + this.getProtection();
        result = result * 59 + this.getEfficiency();
        result = result * 59 + this.getKnockback();
        result = result * 59 + (this.isPurchasedPool() ? 79 : 97);
        result = result * 59 + (this.isPurchasedBlindTrap() ? 79 : 97);
        result = result * 59 + (this.isPurchasedMinerTrap() ? 79 : 97);
        result = result * 59 + (this.isPurchasedDragonUpgrade() ? 79 : 97);
        Location $targetBlockLoc = this.getTargetBlockLoc();
        result = result * 59 + ($targetBlockLoc == null ? 43 : $targetBlockLoc.hashCode());
        Map<String, Boolean> $isPurchased = this.getIsPurchased();
        result = result * 59 + ($isPurchased == null ? 43 : ((Object)$isPurchased).hashCode());
        Map<String, Integer> $enchantLevel = this.getEnchantLevel();
        result = result * 59 + ($enchantLevel == null ? 43 : ((Object)$enchantLevel).hashCode());
        return result;
    }

    public String toString() {
        return "GameTeamData(sharpness=" + this.getSharpness() + ", protection=" + this.getProtection() + ", efficiency=" + this.getEfficiency() + ", knockback=" + this.getKnockback() + ", purchasedPool=" + this.isPurchasedPool() + ", purchasedBlindTrap=" + this.isPurchasedBlindTrap() + ", purchasedMinerTrap=" + this.isPurchasedMinerTrap() + ", purchasedDragonUpgrade=" + this.isPurchasedDragonUpgrade() + ", targetBlockLoc=" + String.valueOf(this.getTargetBlockLoc()) + ", isPurchased=" + String.valueOf(this.getIsPurchased()) + ", enchantLevel=" + String.valueOf(this.getEnchantLevel()) + ")";
    }
}

