/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.data.GamePlayerData;
import io.github.pronze.sba.game.CitizensWrapper;
import io.github.pronze.sba.game.GameStorage;
import io.github.pronze.sba.game.IArena;
import io.github.pronze.sba.game.IGameStorage;
import io.github.pronze.sba.game.IRotatingGenerator;
import io.github.pronze.sba.game.InvisiblePlayer;
import io.github.pronze.sba.game.InvisiblePlayerImpl;
import io.github.pronze.sba.game.RotatingGenerator;
import io.github.pronze.sba.game.tasks.BaseGameTask;
import io.github.pronze.sba.game.tasks.GameTaskManager;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.manager.ScoreboardManager;
import io.github.pronze.sba.service.DynamicSpawnerLimiterService;
import io.github.pronze.sba.service.NPCStoreService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.utils.citizens.HologramTrait;
import io.github.pronze.sba.utils.citizens.ReturnToStoreTrait;
import io.github.pronze.sba.visuals.GameScoreboardManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.SkinTrait;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.events.BedwarsGameEndingEvent;
import org.screamingsandals.bedwars.api.events.BedwarsGameTickEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPostRebuildingEvent;
import org.screamingsandals.bedwars.api.events.BedwarsTargetBlockDestroyedEvent;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStore;
import org.screamingsandals.bedwars.api.game.ItemSpawner;
import org.screamingsandals.bedwars.game.TeamColor;
import sba.c.ConfigurationNode;
import sba.sl.npc.NPC;
import sba.sl.npc.skin.NPCSkin;
import sba.sl.pa.Player;
import sba.sl.pa.Players;
import sba.sl.s.CommandSender;
import sba.sl.spectator.Component;
import sba.sl.t.DefaultThreads;
import sba.sl.t.Tasker;
import sba.sl.u.reflect.Reflect;
import sba.sl.vi.Visual;
import sba.sl.w.Location;

public class Arena
implements IArena {
    private static LivingEntity mockEntity = null;
    private final List<IRotatingGenerator> rotatingGenerators;
    private final Map<UUID, InvisiblePlayer> invisiblePlayers;
    private final Map<UUID, GamePlayerData> playerDataMap;
    private final Map<UUID, String> displayNames;
    private final List<BaseGameTask> gameTasks;
    private final Map<GameStore, NPC> stores;
    private final GameScoreboardManager scoreboardManager;
    private final Game game;
    private final IGameStorage storage;
    private CitizensWrapper citizens;
    Map<org.bukkit.entity.Player, org.bukkit.entity.Player> tracking = new HashMap<org.bukkit.entity.Player, org.bukkit.entity.Player>();

    public Arena(@NotNull Game game) {
        this.game = game;
        this.rotatingGenerators = new ArrayList<IRotatingGenerator>();
        this.invisiblePlayers = new HashMap<UUID, InvisiblePlayer>();
        this.playerDataMap = new HashMap<UUID, GamePlayerData>();
        this.displayNames = new HashMap<UUID, String>();
        this.gameTasks = new ArrayList<BaseGameTask>();
        this.stores = new HashMap<GameStore, NPC>();
        this.storage = new GameStorage(game);
        this.gameTasks.addAll(GameTaskManager.getInstance().startTasks(this));
        this.scoreboardManager = new GameScoreboardManager(this);
        this.game.getConnectedPlayers().forEach(player -> this.registerPlayerData(player.getUniqueId(), GamePlayerData.of(player)));
    }

    @Override
    @NotNull
    public List<org.bukkit.entity.Player> getInvisiblePlayers() {
        return this.invisiblePlayers.values().stream().map(InvisiblePlayer::getHiddenPlayer).collect(Collectors.toList());
    }

    @Override
    public void addHiddenPlayer(@NotNull org.bukkit.entity.Player player) {
        if (this.invisiblePlayers.containsKey(player.getUniqueId())) {
            return;
        }
        InvisiblePlayerImpl invisiblePlayer = new InvisiblePlayerImpl(player, this);
        this.invisiblePlayers.put(player.getUniqueId(), invisiblePlayer);
        Tasker.run(DefaultThreads.GLOBAL_THREAD, invisiblePlayer::vanish);
    }

    @Override
    public void updateHiddenPlayer(@NotNull org.bukkit.entity.Player player) {
        this.invisiblePlayers.get(player.getUniqueId()).refresh();
    }

    @Override
    public void removeHiddenPlayer(@NotNull org.bukkit.entity.Player player) {
        if (player == null) {
            return;
        }
        InvisiblePlayer invisiblePlayer = this.invisiblePlayers.get(player.getUniqueId());
        if (invisiblePlayer != null) {
            invisiblePlayer.setHidden(false);
            this.invisiblePlayers.remove(player.getUniqueId());
        }
    }

    @Override
    public void registerPlayerData(@NotNull UUID uuid, @NotNull GamePlayerData data) {
        if (this.playerDataMap.containsKey(uuid)) {
            throw new UnsupportedOperationException("PlayerData of uuid: " + String.valueOf(uuid) + " is already registered!");
        }
        this.playerDataMap.put(uuid, data);
    }

    @Override
    public void unregisterPlayerData(@NotNull UUID uuid) {
        if (!this.playerDataMap.containsKey(uuid)) {
            throw new UnsupportedOperationException("PlayerData of uuid: " + String.valueOf(uuid) + " is not registered!");
        }
        this.playerDataMap.remove(uuid);
    }

    @Override
    public Optional<GamePlayerData> getPlayerData(@NotNull UUID uuid) {
        return Optional.ofNullable(this.playerDataMap.get(uuid));
    }

    @Override
    @NotNull
    public IGameStorage getStorage() {
        return this.storage;
    }

    @Override
    @NotNull
    public Game getGame() {
        return this.game;
    }

    @Override
    @NotNull
    public ScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    @Override
    public boolean isPlayerHidden(@NotNull org.bukkit.entity.Player player) {
        return this.invisiblePlayers.containsKey(player.getUniqueId());
    }

    public void onGameStarted() {
        LanguageService.getInstance().get(MessageKeys.GAME_START_MESSAGE).send((CommandSender[])this.game.getConnectedPlayers().stream().map(Players::wrapPlayer).toArray(Player[]::new));
        if (SBAConfig.getInstance().node("floating-generator", "enabled").getBoolean()) {
            this.game.getItemSpawners().forEach(itemSpawner -> {
                if (itemSpawner.getItemSpawnerType() == null) {
                    return;
                }
                boolean found = false;
                for (Map.Entry<Object, ? extends ConfigurationNode> entry : SBAConfig.getInstance().node("floating-generator", "mapping").childrenMap().entrySet()) {
                    if (!itemSpawner.getItemSpawnerType().getMaterial().name().equalsIgnoreCase(((String)entry.getKey()).toUpperCase())) continue;
                    found = true;
                    Material material = Material.valueOf((String)entry.getValue().getString("AIR"));
                    this.createRotatingGenerator((org.screamingsandals.bedwars.game.ItemSpawner)itemSpawner, material);
                }
                if (!found) {
                    this.createRotatingGenerator((org.screamingsandals.bedwars.game.ItemSpawner)itemSpawner, Material.AIR);
                }
            });
        }
        if (SBAConfig.getInstance().replaceStoreWithNpc()) {
            try {
                if (this.game.getGameStores().size() == 0) {
                    Logger.error("Game does not contain GameStore, is something preventing the spawning of the stores?", new Object[0]);
                }
                this.game.getGameStores().forEach(store -> {
                    block10: {
                        Logger.trace("Replacing store {}", store);
                        org.screamingsandals.bedwars.game.GameStore nonAPIStore = (org.screamingsandals.bedwars.game.GameStore)store;
                        try {
                            LivingEntity villager = nonAPIStore.kill();
                            if (villager != null) {
                                Main.unregisterGameEntity((Entity)villager);
                            }
                            if (SBA.sbw_0_2_30) break block10;
                            if (mockEntity == null) {
                                mockEntity = (Bat)this.game.getGameWorld().spawnEntity(this.game.getSpectatorSpawn().clone().add(0.0, 300.0, 0.0), EntityType.BAT);
                                try {
                                    mockEntity.setAI(false);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            Reflect.setField((Object)nonAPIStore, "entity", (Object)mockEntity);
                        }
                        catch (Throwable t) {
                            Logger.error("SBA cannot unspawn the store, is something preventing the spawning of the stores?", new Object[0]);
                            t.printStackTrace();
                        }
                    }
                    String file = store.getShopFile();
                    List<Object> name = new ArrayList();
                    NPCSkin skin = null;
                    try {
                        if (file != null && StringUtils.containsIgnoreCase((String)file, (String)"upgrade")) {
                            skin = NPCStoreService.getInstance().getUpgradeShopSkin();
                            name = NPCStoreService.getInstance().getUpgradeShopText();
                        } else {
                            skin = NPCStoreService.getInstance().getShopSkin();
                            name = NPCStoreService.getInstance().getShopText();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    NPC npc = (NPC)NPC.of(Objects.requireNonNull(Location.fromPlatform(store.getStoreLocation()))).displayName(name).lookAtPlayer(true).skin(skin).touchable(true);
                    this.stores.putIfAbsent((GameStore)store, npc);
                    this.game.getConnectedPlayers().stream().map(Players::wrapPlayer).forEach(npc::addViewer);
                    npc.show();
                });
            }
            catch (Throwable t) {
                Logger.warn("Disabling NPC due to an exception during creation of NPC: {}. ", t);
            }
        } else if (SBAConfig.getInstance().replaceStoreWithCitizen()) {
            try {
                this.citizens = new CitizensWrapper();
                if (this.game.getGameStores().size() == 0) {
                    Logger.error("Game does not contain GameStore, is something preventing the spawning of the stores?", new Object[0]);
                }
                this.game.getGameStores().forEach(store -> {
                    block15: {
                        Logger.trace("Replacing store {}", store);
                        org.screamingsandals.bedwars.game.GameStore nonAPIStore = (org.screamingsandals.bedwars.game.GameStore)store;
                        try {
                            LivingEntity villager = nonAPIStore.kill();
                            if (villager == null) break block15;
                            Main.unregisterGameEntity((Entity)villager);
                            net.citizensnpcs.api.npc.NPC npc = this.citizens.getCitizenRegistry().createNPC(villager.getType(), "Name");
                            LookClose look = (LookClose)npc.getOrAddTrait(LookClose.class);
                            look.lookClose(true);
                            Gravity gravity = (Gravity)npc.getOrAddTrait(Gravity.class);
                            try {
                                gravity.setHasGravity(false);
                            }
                            catch (Throwable t) {
                                Reflect.getMethod((Object)gravity, "gravitate", Boolean.TYPE).invoke(true);
                                Reflect.getMethod((Object)gravity, "setEnabled", Boolean.TYPE).invoke(true);
                            }
                            if (nonAPIStore.getEntityType() == EntityType.PLAYER) {
                                SkinTrait trait = (SkinTrait)npc.getOrAddTrait(SkinTrait.class);
                                trait.setSkinName(nonAPIStore.getSkinName());
                            }
                            try {
                                npc.data().setPersistent(NPC.Metadata.SWIM, (Object)false);
                            }
                            catch (Throwable t) {
                                npc.data().setPersistent((NPC.Metadata)Reflect.getField(NPC.Metadata.class, "SWIMMING"), (Object)false);
                            }
                            npc.spawn(nonAPIStore.getStoreLocation());
                            npc.getOrAddTrait(ReturnToStoreTrait.class);
                            LivingEntity entity = (LivingEntity)npc.getEntity();
                            entity.setCustomNameVisible(false);
                            npc.data().setPersistent(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)false);
                            npc.getNavigator().setTarget(nonAPIStore.getStoreLocation());
                            if (!SBA.sbw_0_2_30) {
                                if (mockEntity == null) {
                                    mockEntity = (Bat)this.game.getGameWorld().spawnEntity(this.game.getSpectatorSpawn().clone().add(0.0, 300.0, 0.0), EntityType.BAT);
                                    try {
                                        mockEntity.setAI(false);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                Reflect.setField((Object)nonAPIStore, "entity", (Object)mockEntity);
                            }
                            String file = store.getShopFile();
                            List<Object> name = new ArrayList();
                            NPCSkin skin = null;
                            try {
                                if (file != null && StringUtils.containsIgnoreCase((String)file, (String)"upgrade")) {
                                    skin = NPCStoreService.getInstance().getUpgradeShopSkin();
                                    name = NPCStoreService.getInstance().getUpgradeShopText();
                                } else {
                                    skin = NPCStoreService.getInstance().getShopSkin();
                                    name = NPCStoreService.getInstance().getShopText();
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            HologramTrait holo = (HologramTrait)npc.getOrAddTrait(HologramTrait.class);
                            holo.setLines(name);
                            this.citizens.getCitizensStores().putIfAbsent((GameStore)store, npc);
                        }
                        catch (Throwable t) {
                            Logger.error("SBA cannot unspawn the store, is something preventing the spawning of the stores?", new Object[0]);
                            t.printStackTrace();
                        }
                    }
                });
            }
            catch (Throwable t) {
                Logger.warn("Disabling NPC due to an exception during creation of NPC: {}. ", t);
            }
        }
        this.game.getConnectedPlayers().forEach(p -> this.displayNames.put(p.getUniqueId(), p.getDisplayName() + String.valueOf(ChatColor.RESET)));
    }

    public void onTargetBlockDestroyed(BedwarsTargetBlockDestroyedEvent e) {
        RunningTeam team = e.getTeam();
        Component title = LanguageService.getInstance().get(MessageKeys.BED_DESTROYED_TITLE).toComponent();
        Component subtitle = LanguageService.getInstance().get(MessageKeys.BED_DESTROYED_SUBTITLE).toComponent();
        team.getConnectedPlayers().forEach(player -> SBAUtil.sendTitle(Players.wrapPlayer(player), title, subtitle, 0, 40, 20));
        org.bukkit.entity.Player destroyer = e.getPlayer();
        if (destroyer != null) {
            this.getPlayerData(destroyer.getUniqueId()).ifPresent(destroyerData -> destroyerData.setBedDestroys(destroyerData.getBedDestroys() + 1));
        }
    }

    public void onOver(BedwarsPostRebuildingEvent e) {
        this.scoreboardManager.destroy();
        this.gameTasks.forEach(BaseGameTask::stop);
        this.gameTasks.clear();
        this.rotatingGenerators.forEach(IRotatingGenerator::destroy);
        this.rotatingGenerators.clear();
        this.stores.values().forEach(Visual::destroy);
        this.stores.clear();
        if (this.citizens != null) {
            this.citizens.getCitizensStores().values().forEach(npc -> npc.destroy());
            this.citizens.getCitizensStores().clear();
            this.citizens.getCitizenRegistry().deregisterAll();
        }
        this.getInvisiblePlayers().forEach(this::removeHiddenPlayer);
    }

    @Override
    public void removeVisualsForPlayer(org.bukkit.entity.Player player) {
        this.rotatingGenerators.forEach(gen -> {
            if (((RotatingGenerator)gen).getStack().getType() != Material.AIR) {
                gen.removeViewer(player);
            }
        });
        this.stores.values().forEach(npc -> npc.removeViewer(Players.wrapPlayer(player)));
    }

    @Override
    public void addVisualsForPlayer(org.bukkit.entity.Player player) {
        this.rotatingGenerators.forEach(gen -> {
            if (((RotatingGenerator)gen).getStack().getType() != Material.AIR) {
                gen.addViewer(player);
            }
        });
        this.stores.values().forEach(npc -> npc.addViewer(Players.wrapPlayer(player)));
    }

    @Override
    public void removePlayerFromGame(org.bukkit.entity.Player player) {
        this.scoreboardManager.removeScoreboard(player);
        this.removeVisualsForPlayer(player);
    }

    public void onOver(BedwarsGameEndingEvent e) {
        RunningTeam winner = e.getWinningTeam();
        if (winner != null) {
            String nullStr;
            String firstKillerName = nullStr = LanguageService.getInstance().get(MessageKeys.NONE).toString();
            String firstKillerUsername = nullStr;
            int firstKillerScore = 0;
            UUID firstKillerUUID = null;
            for (Map.Entry<UUID, GamePlayerData> entry : this.playerDataMap.entrySet()) {
                GamePlayerData playerData = this.playerDataMap.get(entry.getKey());
                int kills = playerData.getKills();
                if (kills <= 0 || kills <= firstKillerScore) continue;
                firstKillerScore = kills;
                firstKillerName = playerData.getName();
                firstKillerUUID = entry.getKey();
            }
            Object secondKillerName = nullStr;
            String secondKillerUsername = nullStr;
            int secondKillerScore = 0;
            UUID secondKillerUUID = null;
            for (Map.Entry<UUID, GamePlayerData> entry : this.playerDataMap.entrySet()) {
                GamePlayerData playerData = this.playerDataMap.get(entry.getKey());
                int kills = playerData.getKills();
                String name = playerData.getName();
                if (kills <= 0 || kills <= secondKillerScore || name.equalsIgnoreCase(firstKillerName)) continue;
                secondKillerName = name;
                secondKillerScore = kills;
                secondKillerUUID = entry.getKey();
            }
            String thirdKillerName = nullStr;
            String thirdKillerUsername = nullStr;
            int thirdKillerScore = 0;
            UUID thirdKillerUUID = null;
            for (Map.Entry entry : this.playerDataMap.entrySet()) {
                GamePlayerData playerData = this.playerDataMap.get(entry.getKey());
                int kills = playerData.getKills();
                String name = playerData.getName();
                if (kills <= 0 || kills <= thirdKillerScore || name.equalsIgnoreCase(firstKillerName) || name.equalsIgnoreCase((String)secondKillerName)) continue;
                thirdKillerName = name;
                thirdKillerScore = kills;
                thirdKillerUUID = (UUID)entry.getKey();
            }
            firstKillerUsername = firstKillerName;
            secondKillerUsername = secondKillerName;
            thirdKillerUsername = thirdKillerName;
            firstKillerName = this.replaceNameWithDisplayName(nullStr, firstKillerName, firstKillerUUID);
            secondKillerName = this.replaceNameWithDisplayName(nullStr, (String)secondKillerName, secondKillerUUID);
            thirdKillerName = this.replaceNameWithDisplayName(nullStr, thirdKillerName, thirdKillerUUID);
            Component victoryTitle = LanguageService.getInstance().get(MessageKeys.VICTORY_TITLE).toComponent();
            ArrayList arrayList = new ArrayList();
            winner.getConnectedPlayers().forEach(player -> WinTeamPlayers.add(player.getDisplayName() + String.valueOf(ChatColor.RESET)));
            winner.getConnectedPlayers().forEach(pl -> SBAUtil.sendTitle(Players.wrapPlayer(pl), victoryTitle, Component.empty(), 0, 90, 0));
            LanguageService.getInstance().get(MessageKeys.OVERSTATS_MESSAGE).replace("%color%", TeamColor.valueOf((String)winner.getColor().name()).chatColor.toString()).replace("%win_team%", winner.getName()).replace("%winners%", arrayList.toString()).replace("%first_killer_name%", firstKillerName).replace("%first_killer_username%", firstKillerUsername).replace("%second_killer_name%", (String)secondKillerName).replace("%second_killer_username%", secondKillerUsername).replace("%third_killer_name%", thirdKillerName).replace("%third_killer_username%", thirdKillerUsername).replace("%first_killer_score%", String.valueOf(firstKillerScore)).replace("%second_killer_score%", String.valueOf(secondKillerScore)).replace("%third_killer_score%", String.valueOf(thirdKillerScore)).send((CommandSender[])this.game.getConnectedPlayers().stream().map(Players::wrapPlayer).toArray(Player[]::new));
        }
    }

    private String replaceNameWithDisplayName(String nullStr, String firstKillerName, UUID playeruuid) {
        if (!((String)firstKillerName).equals(nullStr)) {
            org.bukkit.entity.Player firstPlayer = Bukkit.getPlayer((String)firstKillerName);
            firstKillerName = firstPlayer != null ? firstPlayer.getDisplayName() + String.valueOf(ChatColor.RESET) : this.displayNames.get(playeruuid);
        }
        return firstKillerName;
    }

    @Override
    public void createRotatingGenerator(@NotNull org.screamingsandals.bedwars.game.ItemSpawner itemSpawner, @NotNull Material rotationMaterial) {
        RotatingGenerator generator = new RotatingGenerator(itemSpawner, new ItemStack(rotationMaterial), itemSpawner.getLocation());
        if (generator.getStack().getType() != Material.AIR) {
            generator.spawn(this.game.getConnectedPlayers());
        }
        DynamicSpawnerLimiterService dyn = DynamicSpawnerLimiterService.getInstance();
        generator.setTierLevel(dyn.getStartingTier(this.game, (ItemSpawner)itemSpawner));
        dyn.setAccordingly(this.game, false);
        this.rotatingGenerators.add(generator);
    }

    @Override
    public <T extends BaseGameTask> Optional<T> getTask(@NotNull Class<T> taskClass) {
        return this.getGameTasks().stream().filter(gameTask -> gameTask.getClass().isAssignableFrom(taskClass)).findAny();
    }

    @Override
    public List<BaseGameTask> getGameTasks() {
        return List.copyOf(this.gameTasks);
    }

    @Override
    public List<IRotatingGenerator> getRotatingGenerators() {
        return List.copyOf(this.rotatingGenerators);
    }

    @Override
    public Optional<InvisiblePlayer> getHiddenPlayer(UUID playerUUID) {
        return Optional.ofNullable(this.invisiblePlayers.get(playerUUID));
    }

    @Override
    @NotNull
    public Map<GameStore, NPC> getStores() {
        return Map.copyOf(this.stores);
    }

    @Override
    @NotNull
    public Map<GameStore, net.citizensnpcs.api.npc.NPC> getCitizensStores() {
        return Map.copyOf(this.citizens.getCitizensStores());
    }

    public void track(org.bukkit.entity.Player source, org.bukkit.entity.Player target) {
        if (!this.game.isPlayerInAnyTeam(source)) {
            return;
        }
        if (!this.game.isPlayerInAnyTeam(target)) {
            return;
        }
        this.tracking.put(source, target);
    }

    public void onGameTick(BedwarsGameTickEvent e) {
        Game game = e.getGame();
        for (org.bukkit.entity.Player p : game.getConnectedPlayers()) {
            org.bukkit.entity.Player target = this.tracking.get(p);
            if (target != null) {
                if (game.getConnectedPlayers().contains(target)) {
                    p.setCompassTarget(target.getLocation());
                    continue;
                }
                this.tracking.remove(p);
                continue;
            }
            RunningTeam rt = game.getTeamOfPlayer(p);
            if (rt == null) continue;
            if (rt.isTargetBlockExists()) {
                p.setCompassTarget(rt.getTargetBlock());
                continue;
            }
            p.setCompassTarget(rt.getTeamSpawn());
        }
    }
}

