/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game;

import io.github.pronze.lib.pronzelib.scoreboards.Scoreboard;
import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.board.implementations.WrapperBoard;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.game.Arena;
import io.github.pronze.sba.game.InvisiblePlayer;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.visuals.GameScoreboardManager;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.TeamColor;
import sba.sl.i.builder.ItemStackFactory;
import sba.sl.p.ClientboundSetEquipmentPacket;
import sba.sl.pa.Players;
import sba.sl.sl.EquipmentSlot;
import sba.sl.t.DefaultThreads;
import sba.sl.t.Tasker;

public class InvisiblePlayerImpl
implements InvisiblePlayer {
    private final Player hiddenPlayer;
    private final Arena arena;
    private boolean justEquipped = false;
    private boolean isHidden;
    protected BukkitTask armorHider;

    @Override
    public void vanish() {
        Logger.trace("InvisiblePlayerImpl.vanish{}", this.hiddenPlayer);
        RunningTeam team = this.arena.getGame().getTeamOfPlayer(this.hiddenPlayer);
        if (team == null) {
            return;
        }
        if (this.isHidden) {
            return;
        }
        String invisTeamName = "i-" + team.getName();
        this.arena.getGame().getConnectedPlayers().forEach(connectedPlayers -> {
            GameScoreboardManager gameScoreboardManager = (GameScoreboardManager)this.arena.getScoreboardManager();
            Optional<Scoreboard> maybeHolder = gameScoreboardManager.getScoreboard(connectedPlayers.getUniqueId());
            if (maybeHolder.isEmpty()) {
                return;
            }
            WrapperBoard holder = maybeHolder.get().getHolder().of((Player)connectedPlayers);
            if (holder != null) {
                if (!holder.hasTeamEntry(invisTeamName)) {
                    holder.addTeam(invisTeamName, TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)team.getColor()).chatColor);
                    holder.getTeamEntry(invisTeamName).ifPresent(invisibleScoreboardTeam -> invisibleScoreboardTeam.setNameTagVisibility(NameTagVisibility.NEVER));
                }
                Team invisibleScoreboardTeam2 = holder.getTeamOrRegister(invisTeamName);
                try {
                    invisibleScoreboardTeam2.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                holder.getTeamEntry(team.getName()).ifPresent(entry -> {
                    if (entry.hasEntry(this.hiddenPlayer.getName())) {
                        entry.removeEntry(this.hiddenPlayer.getName());
                    }
                });
                if (!invisibleScoreboardTeam2.hasEntry(this.hiddenPlayer.getName())) {
                    invisibleScoreboardTeam2.addEntry(this.hiddenPlayer.getName());
                }
            }
        });
        this.isHidden = true;
        this.hideArmor();
        this.armorHider = new BukkitRunnable(){

            public void run() {
                if (!InvisiblePlayerImpl.this.isElligble() || !InvisiblePlayerImpl.this.isHidden) {
                    InvisiblePlayerImpl.this.showPlayer();
                    this.cancel();
                    InvisiblePlayerImpl.this.arena.removeHiddenPlayer(InvisiblePlayerImpl.this.hiddenPlayer);
                }
            }
        }.runTaskTimer((Plugin)SBA.getPluginInstance(), 0L, 20L);
    }

    private boolean isElligble() {
        return this.arena.getGame().getStatus() == GameStatus.RUNNING && (this.hiddenPlayer.getGameMode() == GameMode.SURVIVAL || this.hiddenPlayer.getGameMode() == GameMode.CREATIVE || this.hiddenPlayer.getGameMode() == GameMode.ADVENTURE) && this.hiddenPlayer.isOnline() && this.hiddenPlayer.hasPotionEffect(PotionEffectType.INVISIBILITY) && this.arena.getGame().getConnectedPlayers().contains(this.hiddenPlayer);
    }

    private void showArmor() {
        ItemStack item;
        ItemStack boots = this.hiddenPlayer.getInventory().getBoots();
        ItemStack helmet = this.hiddenPlayer.getInventory().getHelmet();
        ItemStack chestplate = this.hiddenPlayer.getInventory().getChestplate();
        ItemStack leggings = this.hiddenPlayer.getInventory().getLeggings();
        try {
            item = this.hiddenPlayer.getInventory().getItemInMainHand();
        }
        catch (Throwable ignored) {
            item = this.hiddenPlayer.getInventory().getItemInHand();
        }
        ItemStack currentHand = item;
        this.arena.getGame().getConnectedPlayers().forEach(pl -> this.getEquipPacket(this.convert(helmet), this.convert(chestplate), this.convert(leggings), this.convert(boots), this.convert(currentHand)).sendPacket(Players.wrapPlayer(pl)));
    }

    public sba.sl.i.ItemStack convert(ItemStack itemStack) {
        return Objects.requireNonNullElse(ItemStackFactory.build(itemStack), ItemStackFactory.getAir());
    }

    private void hideArmor() {
        RunningTeam hiddenPlayerTeam = this.arena.getGame().getTeamOfPlayer(this.hiddenPlayer);
        sba.sl.i.ItemStack airStack = ItemStackFactory.getAir();
        this.arena.getGame().getConnectedPlayers().stream().filter(pl -> !hiddenPlayerTeam.getConnectedPlayers().contains(pl)).forEach(pl -> {
            ItemStack item;
            try {
                item = this.hiddenPlayer.getInventory().getItemInMainHand();
            }
            catch (Throwable ignored) {
                item = this.hiddenPlayer.getInventory().getItemInHand();
            }
            this.getEquipPacket(airStack, airStack, airStack, airStack, this.convert(item)).sendPacket(Players.wrapPlayer(pl));
        });
    }

    @Override
    public void refresh() {
        sba.sl.i.ItemStack airStack = ItemStackFactory.getAir();
        RunningTeam hiddenPlayerTeam = this.arena.getGame().getTeamOfPlayer(this.hiddenPlayer);
        Tasker.run(DefaultThreads.GLOBAL_THREAD, () -> this.arena.getGame().getConnectedPlayers().stream().filter(pl -> hiddenPlayerTeam == null || !hiddenPlayerTeam.getConnectedPlayers().contains(pl)).forEach(pl -> {
            ItemStack item;
            try {
                item = this.hiddenPlayer.getInventory().getItemInMainHand();
            }
            catch (Throwable ignored) {
                item = this.hiddenPlayer.getInventory().getItemInHand();
            }
            this.getEquipPacket(airStack, airStack, airStack, airStack, this.convert(item)).sendPacket(Players.wrapPlayer(pl));
        }));
    }

    private ClientboundSetEquipmentPacket getEquipPacket(sba.sl.i.ItemStack helmet, sba.sl.i.ItemStack chestPlate, sba.sl.i.ItemStack leggings, sba.sl.i.ItemStack boots, sba.sl.i.ItemStack hand) {
        ClientboundSetEquipmentPacket.ClientboundSetEquipmentPacketBuilder packet = ClientboundSetEquipmentPacket.builder();
        packet.entityId(this.hiddenPlayer.getEntityId());
        HashMap<EquipmentSlot, sba.sl.i.ItemStack> slots = new HashMap<EquipmentSlot, sba.sl.i.ItemStack>();
        if (hand != null) {
            slots.put(EquipmentSlot.of("HAND"), hand);
        }
        if (helmet != null) {
            slots.put(EquipmentSlot.of("HEAD"), helmet);
        }
        if (chestPlate != null) {
            slots.put(EquipmentSlot.of("CHEST"), chestPlate);
        }
        if (leggings != null) {
            slots.put(EquipmentSlot.of("LEGS"), leggings);
        }
        if (boots != null) {
            slots.put(EquipmentSlot.of("FEET"), boots);
        }
        packet.slots(slots);
        return packet.build();
    }

    @Override
    public void showPlayer() {
        RunningTeam team = this.arena.getGame().getTeamOfPlayer(this.hiddenPlayer);
        if (team == null) {
            return;
        }
        String invisTeamName = "i-" + team.getName();
        this.arena.getGame().getConnectedPlayers().forEach(connectedPlayers -> {
            GameScoreboardManager gameScoreboardManager = (GameScoreboardManager)this.arena.getScoreboardManager();
            Optional<Scoreboard> maybeHolder = gameScoreboardManager.getScoreboard(connectedPlayers.getUniqueId());
            if (maybeHolder.isEmpty()) {
                return;
            }
            WrapperBoard holder = maybeHolder.get().getHolder().of((Player)connectedPlayers);
            if (holder != null) {
                if (!holder.hasTeamEntry(invisTeamName)) {
                    holder.addTeam(invisTeamName, TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)team.getColor()).chatColor);
                    holder.getTeamEntry(invisTeamName).ifPresent(invisibleScoreboardTeam -> invisibleScoreboardTeam.setNameTagVisibility(NameTagVisibility.NEVER));
                }
                Team invisibleScoreboardTeam2 = holder.getTeamOrRegister(invisTeamName);
                try {
                    invisibleScoreboardTeam2.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (invisibleScoreboardTeam2.hasEntry(this.hiddenPlayer.getName())) {
                    invisibleScoreboardTeam2.removeEntry(this.hiddenPlayer.getName());
                }
                holder.getTeamEntry(team.getName()).ifPresent(entry -> {
                    if (!entry.hasEntry(this.hiddenPlayer.getName())) {
                        entry.addEntry(this.hiddenPlayer.getName());
                    }
                });
            }
        });
        SBAUtil.cancelTask(this.armorHider);
        this.showArmor();
        this.isHidden = false;
        this.hiddenPlayer.removePotionEffect(PotionEffectType.INVISIBILITY);
    }

    @Override
    public Player getHiddenPlayer() {
        return null;
    }

    @Override
    public void setHidden(boolean hidden) {
    }

    @Override
    public boolean isJustEquipped() {
        return false;
    }

    @Override
    public void setJustEquipped(boolean justEquipped) {
    }

    public InvisiblePlayerImpl(Player hiddenPlayer, Arena arena) {
        this.hiddenPlayer = hiddenPlayer;
        this.arena = arena;
    }

    public Arena getArena() {
        return this.arena;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public BukkitTask getArmorHider() {
        return this.armorHider;
    }

    public void setArmorHider(BukkitTask armorHider) {
        this.armorHider = armorHider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvisiblePlayerImpl)) {
            return false;
        }
        InvisiblePlayerImpl other = (InvisiblePlayerImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isJustEquipped() != other.isJustEquipped()) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        Player this$hiddenPlayer = this.getHiddenPlayer();
        Player other$hiddenPlayer = other.getHiddenPlayer();
        if (this$hiddenPlayer == null ? other$hiddenPlayer != null : !this$hiddenPlayer.equals(other$hiddenPlayer)) {
            return false;
        }
        Arena this$arena = this.getArena();
        Arena other$arena = other.getArena();
        if (this$arena == null ? other$arena != null : !this$arena.equals(other$arena)) {
            return false;
        }
        BukkitTask this$armorHider = this.getArmorHider();
        BukkitTask other$armorHider = other.getArmorHider();
        return !(this$armorHider == null ? other$armorHider != null : !this$armorHider.equals(other$armorHider));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvisiblePlayerImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isJustEquipped() ? 79 : 97);
        result = result * 59 + (this.isHidden() ? 79 : 97);
        Player $hiddenPlayer = this.getHiddenPlayer();
        result = result * 59 + ($hiddenPlayer == null ? 43 : $hiddenPlayer.hashCode());
        Arena $arena = this.getArena();
        result = result * 59 + ($arena == null ? 43 : $arena.hashCode());
        BukkitTask $armorHider = this.getArmorHider();
        result = result * 59 + ($armorHider == null ? 43 : $armorHider.hashCode());
        return result;
    }

    public String toString() {
        return "InvisiblePlayerImpl(hiddenPlayer=" + String.valueOf(this.getHiddenPlayer()) + ", arena=" + String.valueOf(this.getArena()) + ", justEquipped=" + this.isJustEquipped() + ", isHidden=" + this.isHidden() + ", armorHider=" + String.valueOf(this.getArmorHider()) + ")";
    }
}

