/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.lang;

import io.github.pronze.sba.AddonAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import sba.sl.s.CommandSender;
import sba.sl.spectator.Component;
import sba.sl.spectator.TextComponent;

public class Message
implements Cloneable {
    private List<Component> original = new ArrayList<Component>();
    private boolean prefix;

    public Message clone() {
        Message newMessage = new Message(this.original);
        newMessage.prefix = this.prefix;
        return newMessage;
    }

    public static Component toMiniMessage(String legacyString) {
        String workingString = ChatColor.translateAlternateColorCodes((char)'&', (String)legacyString);
        workingString = workingString.replaceAll("[\u00a7&]x[\u00a7&]([0-9a-z])[\u00a7&]([0-9a-z])[\u00a7&]([0-9a-z])[\u00a7&]([0-9a-z])[\u00a7&]([0-9a-z])[\u00a7&]([0-9a-z])", "<#$1$2$3$4$5$6>");
        workingString = workingString.replaceAll("[\u00a7&]#([0-9a-fA-F]{6})", "<#$1>");
        workingString = workingString.replaceAll("\u00a70", "<black>");
        workingString = workingString.replaceAll("\u00a71", "<dark_blue>");
        workingString = workingString.replaceAll("\u00a72", "<dark_green>");
        workingString = workingString.replaceAll("\u00a73", "<dark_aqua>");
        workingString = workingString.replaceAll("\u00a74", "<dark_red>");
        workingString = workingString.replaceAll("\u00a75", "<dark_purple>");
        workingString = workingString.replaceAll("\u00a76", "<gold>");
        workingString = workingString.replaceAll("\u00a77", "<gray>");
        workingString = workingString.replaceAll("\u00a78", "<dark_gray>");
        workingString = workingString.replaceAll("\u00a79", "<blue>");
        workingString = workingString.replaceAll("\u00a7a", "<green>");
        workingString = workingString.replaceAll("\u00a7A", "<green>");
        workingString = workingString.replaceAll("\u00a7b", "<aqua>");
        workingString = workingString.replaceAll("\u00a7B", "<aqua>");
        workingString = workingString.replaceAll("\u00a7c", "<red>");
        workingString = workingString.replaceAll("\u00a7C", "<red>");
        workingString = workingString.replaceAll("\u00a7d", "<light_purple>");
        workingString = workingString.replaceAll("\u00a7D", "<light_purple>");
        workingString = workingString.replaceAll("\u00a7e", "<yellow>");
        workingString = workingString.replaceAll("\u00a7E", "<yellow>");
        workingString = workingString.replaceAll("\u00a7f", "<white>");
        workingString = workingString.replaceAll("\u00a7F", "<white>");
        workingString = workingString.replaceAll("\u00a7k", "<obfuscated>");
        workingString = workingString.replaceAll("\u00a7K", "<obfuscated>");
        workingString = workingString.replaceAll("\u00a7l", "<bold>");
        workingString = workingString.replaceAll("\u00a7L", "<bold>");
        workingString = workingString.replaceAll("\u00a7m", "<strikethrough>");
        workingString = workingString.replaceAll("\u00a7M", "<strikethrough>");
        workingString = workingString.replaceAll("\u00a7n", "<underlined>");
        workingString = workingString.replaceAll("\u00a7N", "<underlined>");
        workingString = workingString.replaceAll("\u00a7o", "<italic>");
        workingString = workingString.replaceAll("\u00a7O", "<italic>");
        workingString = workingString.replaceAll("\u00a7r", "<reset>");
        workingString = workingString.replaceAll("\u00a7R", "<reset>");
        workingString = ChatColor.stripColor((String)workingString);
        return Component.fromMiniMessage(workingString);
    }

    public static Message of(List<String> text) {
        return new Message(text.stream().map(Message::toMiniMessage).collect(Collectors.toList()));
    }

    public static Message ofComponent(List<Component> text) {
        return new Message(text);
    }

    private Message(List<Component> text) {
        this.original.addAll(text);
    }

    public Message replace(String key, String value) {
        this.original = this.original.stream().map(str -> str.replaceText(key, value)).collect(Collectors.toList());
        return this;
    }

    public Message replace(String key, Component value) {
        this.original = this.original.stream().map(str -> str.replaceText(key, value.toLegacy())).collect(Collectors.toList());
        return this;
    }

    public Message replace(Function<String, String> replacer) {
        Pattern pattern = Pattern.compile("[%]([^%]+)[%]");
        this.original = this.original.stream().map(str -> str.replaceText(pattern, mr -> (String)replacer.apply(mr.group(1)))).collect(Collectors.toList());
        return this;
    }

    public Message withPrefix() {
        this.prefix = true;
        return this;
    }

    @NotNull
    public Message placeholderFor(@NotNull Player player) {
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return this.replace(placeholder -> PlaceholderAPI.setPlaceholders((Player)player, (String)("%" + placeholder + "%")));
        }
        return this;
    }

    @NotNull
    public Message placeholderFor(@NotNull Player player, @NotNull Player relativeTo) {
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return this.replace(placeholder -> PlaceholderAPI.setRelationalPlaceholders((Player)player, (Player)relativeTo, (String)("%" + placeholder + "%")));
        }
        return this;
    }

    public Component toComponent() {
        TextComponent.Builder component = Component.text();
        this.original.forEach(str -> {
            if (this.prefix) {
                component.append(Message.toMiniMessage(AddonAPI.getInstance().getConfigurator().getString("prefix", "[SBA]") + ": "));
            }
            component.append((Component)str);
            if (this.original.indexOf(str) + 1 != this.original.size()) {
                component.append((Component)Component.text("\n"));
            }
        });
        return component.build();
    }

    public String toString() {
        Object string = this.original.get(0).toLegacy();
        if (this.prefix) {
            string = AddonAPI.getInstance().getConfigurator().getString("prefix", "[SBA]") + ": " + (String)string;
        }
        return string;
    }

    public List<String> toStringList() {
        return this.toComponentList().stream().map(Component::toLegacy).collect(Collectors.toList());
    }

    public List<Component> toComponentList() {
        return this.original.stream().map(str -> {
            if (this.prefix) {
                str = ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Message.toMiniMessage(AddonAPI.getInstance().getConfigurator().getString("prefix", "[SBA]") + ": "))).append((Component)str)).build();
            }
            return str;
        }).collect(Collectors.toList());
    }

    public void send(CommandSender ... wrapper) {
        for (CommandSender receiver : wrapper) {
            Player target = null;
            if (receiver.getType() == CommandSender.Type.PLAYER) {
                target = receiver.as(Player.class);
            }
            this.clone().placeholderFor(target).toComponentList().forEach(receiver::sendMessage);
        }
    }

    public void send(List<CommandSender> wrapperList) {
        wrapperList.forEach(receiver -> {
            Player target = null;
            if (receiver.getType() == CommandSender.Type.PLAYER) {
                target = receiver.as(Player.class);
            }
            this.clone().placeholderFor(target).toComponentList().forEach(receiver::sendMessage);
        });
    }

    private Message() {
    }

    private static Message of() {
        return new Message();
    }
}

