/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.listener;

import io.github.pronze.lib.pronzelib.scoreboards.Scoreboard;
import io.github.pronze.lib.pronzelib.scoreboards.ScoreboardManager;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBAFinalKillEvent;
import io.github.pronze.sba.game.Arena;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.game.IArena;
import io.github.pronze.sba.inventories.PlayerTrackerInventory;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.party.PartySetting;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.utils.ShopUtil;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.events.BedwarsGameEndingEvent;
import org.screamingsandals.bedwars.api.events.BedwarsGameStartedEvent;
import org.screamingsandals.bedwars.api.events.BedwarsGameTickEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerJoinedEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerLeaveEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPostRebuildingEvent;
import org.screamingsandals.bedwars.api.events.BedwarsTargetBlockDestroyedEvent;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.lib.lang.I18n;
import org.screamingsandals.bedwars.utils.MiscUtils;
import sba.sl.pa.Players;
import sba.sl.s.CommandSender;
import sba.sl.spectator.Component;
import sba.sl.t.DefaultThreads;
import sba.sl.t.Tasker;
import sba.sl.t.TaskerTime;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class BedWarsListener
implements Listener {
    private final Map<UUID, BukkitTask> runnableCache = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, ItemStack[]> inventoryContent = new HashMap<UUID, ItemStack[]>();
    private final Map<UUID, Boolean> collidableValue = new HashMap<UUID, Boolean>();

    @OnPostEnable
    public void registerListener() {
        if (SBA.isBroken()) {
            return;
        }
        SBA.getInstance().registerListener(this);
    }

    @EventHandler
    public void onStarted(BedwarsGameStartedEvent e) {
        Logger.trace("SBA onStarted{}", e);
        org.screamingsandals.bedwars.api.game.Game game = e.getGame();
        IArena arena = ArenaManager.getInstance().createArena(game);
        ((Arena)arena).onGameStarted();
    }

    @EventHandler
    public void onBwReload(PluginEnableEvent event) {
        String pluginName = event.getPlugin().getName();
        if (pluginName.equalsIgnoreCase(Main.getInstance().getName())) {
            if (!SBA.getPluginInstance().isEnabled()) {
                return;
            }
            Logger.trace("Re registering listeners!", new Object[0]);
            List<Listener> listeners = SBA.getInstance().getRegisteredListeners();
            listeners.forEach(SBA.getInstance()::unregisterListener);
            listeners.forEach(SBA.getInstance()::registerListener);
            Logger.trace("Registration complete!", new Object[0]);
        }
    }

    @EventHandler
    public void onTargetBlockDestroyed(BedwarsTargetBlockDestroyedEvent e) {
        org.screamingsandals.bedwars.api.game.Game game = e.getGame();
        ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> ((Arena)arena).onTargetBlockDestroyed(e));
    }

    @EventHandler
    public void onPostRebuildingEvent(BedwarsPostRebuildingEvent e) {
        org.screamingsandals.bedwars.api.game.Game game = e.getGame();
        ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> ((Arena)arena).onOver(e));
        ArenaManager.getInstance().removeArena(game);
    }

    @EventHandler
    public void onGameTick(BedwarsGameTickEvent e) {
        org.screamingsandals.bedwars.api.game.Game game = e.getGame();
        ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> ((Arena)arena).onGameTick(e));
    }

    @EventHandler
    public void onOver(BedwarsGameEndingEvent e) {
        Logger.trace("SBA onOver{}", e);
        org.screamingsandals.bedwars.api.game.Game game = e.getGame();
        ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> ((Arena)arena).onOver(e));
    }

    public PartySetting.GameMode gamemodeOf(Player connectedPlayer) {
        AtomicReference<PartySetting.GameMode> ref = new AtomicReference<PartySetting.GameMode>(PartySetting.GameMode.PUBLIC);
        SBA.getInstance().getPartyManager().getPartyOf(SBA.getInstance().getPlayerWrapper(connectedPlayer)).ifPresent(party -> ref.set(party.getSettings().getGamemode()));
        return ref.get();
    }

    @EventHandler
    public void onBWLobbyJoin(BedwarsPlayerJoinedEvent e) {
        Logger.trace("SBA onBWLobbyJoin{}", e);
        final Player player = e.getPlayer();
        SBAPlayerWrapper wrappedPlayer = SBA.getInstance().getPlayerWrapper(player);
        BukkitTask task = this.runnableCache.get(player.getUniqueId());
        final Game game = (Game)e.getGame();
        if (task != null) {
            SBAUtil.cancelTask(task);
        }
        AtomicBoolean isCancelled = new AtomicBoolean();
        isCancelled.set(false);
        Optional<IParty> maybeParty = SBA.getInstance().getPartyManager().getPartyOf(wrappedPlayer);
        maybeParty.ifPresentOrElse(party -> {
            Logger.trace("Player {} has a party ", player);
            if (party.getSettings().getGamemode() == PartySetting.GameMode.PRIVATE) {
                Logger.trace("Player {} party is private ", player);
                game.getConnectedPlayers().forEach(connectedPlayer -> {
                    if (connectedPlayer == player) {
                        return;
                    }
                    if (!party.getMembers().contains(SBA.getInstance().getPlayerWrapper((Player)connectedPlayer))) {
                        isCancelled.set(true);
                        Logger.trace("Preventing join as someone from outside the party is already in the game: {}", connectedPlayer);
                        LanguageService.getInstance().get(MessageKeys.MESSAGE_ARENA_BUSY).replace("%game%", game.getName()).send(wrappedPlayer);
                        return;
                    }
                });
            } else {
                Logger.trace("Player {} party is public ", player);
                game.getConnectedPlayers().forEach(connectedPlayer -> {
                    if (connectedPlayer == player) {
                        return;
                    }
                    if (this.gamemodeOf((Player)connectedPlayer) == PartySetting.GameMode.PRIVATE) {
                        isCancelled.set(true);
                        Logger.trace("Preventing join due as a private party is in the lobby", new Object[0]);
                        LanguageService.getInstance().get(MessageKeys.MESSAGE_ARENA_BUSY).replace("%game%", game.getName()).send(wrappedPlayer);
                        return;
                    }
                });
            }
            if (!wrappedPlayer.equals(party.getPartyLeader()) && game != Main.getInstance().getGameOfPlayer(party.getPartyLeader().getInstance())) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCESS_DENIED).send(wrappedPlayer);
                isCancelled.set(true);
                return;
            }
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_WARP).send(wrappedPlayer);
        }, () -> game.getConnectedPlayers().forEach(connectedPlayer -> {
            if (this.gamemodeOf((Player)connectedPlayer) == PartySetting.GameMode.PRIVATE) {
                Logger.trace("Preventing join due as a private party is in the lobby", new Object[0]);
                isCancelled.set(true);
                LanguageService.getInstance().get(MessageKeys.MESSAGE_ARENA_BUSY).replace("%game%", game.getName()).send(wrappedPlayer);
                return;
            }
        }));
        if (!isCancelled.get()) {
            if (SBAConfig.getInstance().party().autojoin()) {
                maybeParty.ifPresent(party -> party.getMembers().stream().filter(member -> !wrappedPlayer.equals(member)).forEach(member -> {
                    org.screamingsandals.bedwars.api.game.Game memberGame = Main.getInstance().getGameOfPlayer(member.getInstance());
                    Bukkit.getScheduler().runTask((Plugin)SBA.getPluginInstance(), () -> {
                        if (game != memberGame) {
                            if (memberGame != null) {
                                memberGame.leaveFromGame(member.getInstance());
                            }
                            game.joinToGame(member.getInstance());
                            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_WARP).send((CommandSender)member);
                        }
                    });
                }));
            }
        } else {
            game.leaveFromGame(player);
            maybeParty.ifPresent(party -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCESS_DENIED).send(wrappedPlayer));
            return;
        }
        switch (game.getStatus()) {
            case WAITING: {
                BukkitTask bukkitTask = new BukkitRunnable(){
                    int buffer = 1;

                    public void run() {
                        if (game.getStatus() == GameStatus.WAITING) {
                            String time;
                            if (game.getConnectedPlayers().size() >= game.getMinPlayers() && !(time = game.getFormattedTimeLeft()).contains("0-1")) {
                                String[] units = time.split(":");
                                int seconds = Integer.parseInt(units[1]) + 1 + Integer.parseInt(units[0]) * 60;
                                if (this.buffer == seconds) {
                                    return;
                                }
                                this.buffer = seconds;
                                if (seconds <= 10) {
                                    String message = LanguageService.getInstance().get(MessageKeys.GAME_STARTS_IN_MESSAGE).replace("%seconds%", seconds <= 60 ? String.valueOf(seconds) : game.getFormattedTimeLeft()).toString();
                                    message = seconds == 1 ? message.replace("seconds", "second") : message;
                                    player.sendMessage(message);
                                    SBAUtil.sendTitle(Players.wrapPlayer(player), Component.fromLegacy(ShopUtil.translateColors("&c" + seconds)), Component.empty(), 0, 20, 0);
                                }
                            }
                        } else {
                            this.cancel();
                            BedWarsListener.this.runnableCache.remove(player.getUniqueId());
                        }
                    }
                }.runTaskTimer((Plugin)SBA.getPluginInstance(), 3L, 20L);
                this.runnableCache.put(player.getUniqueId(), bukkitTask);
                break;
            }
            case RUNNING: {
                IArena arena = ArenaManager.getInstance().get(game.getName()).orElseThrow();
                if (SBAConfig.getInstance().getBoolean("game-scoreboard.enabled", true).booleanValue()) {
                    arena.getScoreboardManager().createScoreboard(player);
                }
                ((Arena)arena).getRotatingGenerators().forEach(generator -> generator.addViewer(player));
            }
        }
    }

    @EventHandler
    public void onBedWarsPlayerLeave(BedwarsPlayerLeaveEvent e) {
        Logger.trace("SBA EonBedWarsPlayerLeave{}", e);
        Player player = e.getPlayer();
        BukkitTask task = this.runnableCache.get(player.getUniqueId());
        org.screamingsandals.bedwars.api.game.Game game = e.getGame();
        ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> {
            arena.removeVisualsForPlayer(player);
            arena.removePlayerFromGame(player);
        });
        if (task != null) {
            SBAUtil.cancelTask(task);
        }
        this.runnableCache.remove(player.getUniqueId());
        ScoreboardManager.getInstance().fromCache(player.getUniqueId()).ifPresent(Scoreboard::destroy);
        player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        Optional<IParty> maybeParty = PartyManager.getInstance().getPartyOf(SBA.getInstance().getPlayerWrapper(e.getPlayer()));
        if (SBAConfig.getInstance().party().autojoin()) {
            maybeParty.ifPresent(party -> {
                if (party.getPartyLeader().getInstance() == e.getPlayer()) {
                    party.getMembers().forEach(member -> {
                        if (member != e.getPlayer()) {
                            Tasker.run(DefaultThreads.GLOBAL_THREAD, () -> {
                                org.screamingsandals.bedwars.api.game.Game memberGame = Main.getInstance().getGameOfPlayer(member.getInstance());
                                if (memberGame != null) {
                                    memberGame.leaveFromGame(member.getInstance());
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBedWarsPlayerRespawnEvent(PlayerRespawnEvent e) {
        Player victim = e.getPlayer();
        if (!Main.isPlayerInGame((Player)victim)) {
            return;
        }
        org.screamingsandals.bedwars.api.game.Game game = Main.getInstance().getGameOfPlayer(victim);
        Tasker.run(DefaultThreads.GLOBAL_THREAD, () -> ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> arena.addVisualsForPlayer(victim)));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBedwarsPlayerPlay(PlayerGameModeChangeEvent e) {
        Player player = e.getPlayer();
        if (!Main.isPlayerInGame((Player)player)) {
            return;
        }
        if (player.getGameMode() == GameMode.SURVIVAL) {
            return;
        }
        if (e.getNewGameMode() != GameMode.SURVIVAL) {
            return;
        }
        if (player.getGameMode() == GameMode.ADVENTURE) {
            player.getInventory().remove(SBAConfig.getInstance().spectator().teleporter().get());
            player.getInventory().remove(SBAConfig.getInstance().spectator().leave().get());
            if (!SBAConfig.getInstance().spectator().tracker().keepOnStart()) {
                player.getInventory().remove(SBAConfig.getInstance().spectator().tracker().get());
            }
        }
        if (SBAConfig.getInstance().spectator().adventure()) {
            player.closeInventory();
            player.setFlying(false);
            player.setAllowFlight(false);
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
            org.screamingsandals.bedwars.api.game.Game game = Main.getInstance().getGameOfPlayer(player);
            Optional<IArena> arena = ArenaManager.getInstance().get(game.getName());
            arena.ifPresent(arena_ -> arena_.removeHiddenPlayer(player));
        }
        Tasker.runDelayed(DefaultThreads.GLOBAL_THREAD, () -> {
            if (this.inventoryContent.containsKey(player.getUniqueId())) {
                player.getInventory().clear();
                player.getInventory().setContents(this.inventoryContent.get(player.getUniqueId()));
                this.inventoryContent.remove(player.getUniqueId());
            }
            if (this.collidableValue.containsKey(player.getUniqueId())) {
                player.setCollidable(this.collidableValue.get(player.getUniqueId()).booleanValue());
            }
            org.screamingsandals.bedwars.api.game.Game game = Main.getInstance().getGameOfPlayer(player);
            ShopUtil.applyTeamUpgrades(player, game);
        }, 2L, TaskerTime.TICKS);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBedwarsPlayerSpectate(PlayerGameModeChangeEvent e) {
        Player player = e.getPlayer();
        if (!Main.isPlayerInGame((Player)player)) {
            return;
        }
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (e.getNewGameMode() != GameMode.SPECTATOR) {
            return;
        }
        if (!SBAConfig.getInstance().spectator().adventure()) {
            return;
        }
        if (Main.getInstance().getGameOfPlayer(player).getOriginalOrInheritedKeepInventory() && !this.inventoryContent.containsKey(player.getUniqueId())) {
            this.inventoryContent.put(player.getUniqueId(), (ItemStack[])Arrays.asList(player.getInventory().getContents()).stream().map(i -> i != null ? i.clone() : i).collect(Collectors.toList()).toArray(new ItemStack[0]).clone());
        }
        if (!this.collidableValue.containsKey(player.getUniqueId())) {
            try {
                this.collidableValue.put(player.getUniqueId(), player.isCollidable());
            }
            catch (Throwable t) {
                this.collidableValue.put(player.getUniqueId(), false);
            }
        }
        Tasker.runDelayed(DefaultThreads.GLOBAL_THREAD, () -> {
            int leavePosition;
            int compassPosition;
            ItemStack compass;
            player.getInventory().clear();
            if (SBAConfig.getInstance().spectator().teleporter().enabled()) {
                compass = SBAConfig.getInstance().spectator().teleporter().get();
                compassPosition = SBAConfig.getInstance().spectator().teleporter().slot();
                player.getInventory().setItem(compassPosition, compass);
            }
            if (SBAConfig.getInstance().spectator().tracker().enabled()) {
                compass = SBAConfig.getInstance().spectator().tracker().get();
                compassPosition = SBAConfig.getInstance().spectator().tracker().slot();
                org.screamingsandals.bedwars.api.game.Game game = Main.getInstance().getGameOfPlayer(player);
                RunningTeam team = game.getTeamOfPlayer(player);
                if (team != null) {
                    player.setCompassTarget(team.getTargetBlock());
                }
                player.getInventory().setItem(compassPosition, compass);
            }
            if ((leavePosition = SBAConfig.getInstance().spectator().leave().position()) >= 0 && leavePosition <= 8) {
                player.getInventory().setItem(leavePosition, SBAConfig.getInstance().spectator().leave().get());
            }
            player.setGameMode(GameMode.ADVENTURE);
        }, 1L, TaskerTime.TICKS);
    }

    @EventHandler
    public void onCompassClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack compass = SBAConfig.getInstance().spectator().teleporter().get();
        if (!compass.isSimilar(player.getInventory().getItemInHand())) {
            return;
        }
        Logger.info("{} clicked on players teleporter", player);
        PlayerTrackerInventory playerTrackerInventory = new PlayerTrackerInventory(Main.getInstance().getGameOfPlayer(player), SBAConfig.getInstance().spectator().teleporter().name(), target -> player.teleport((Entity)target)).openForPlayer(player);
    }

    @EventHandler
    public void onTrackerClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack compass = SBAConfig.getInstance().spectator().tracker().get();
        if (!compass.isSimilar(player.getInventory().getItemInHand())) {
            return;
        }
        Logger.info("{} clicked on players tracker", player);
        PlayerTrackerInventory playerTrackerInventory = new PlayerTrackerInventory(Main.getInstance().getGameOfPlayer(player), SBAConfig.getInstance().spectator().teleporter().name(), target -> {
            org.screamingsandals.bedwars.api.game.Game game = Main.getInstance().getGameOfPlayer(player);
            ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> ((Arena)arena).track(player, (Player)target));
        }).openForPlayer(player);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent ice) {
        if (ice.getClickedInventory() == null) {
            return;
        }
        if (ice.getClickedInventory().getHolder() instanceof PlayerTrackerInventory) {
            PlayerTrackerInventory playerTrackerInventory = (PlayerTrackerInventory)ice.getClickedInventory().getHolder();
            playerTrackerInventory.onInventoryClick(ice);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBedwarsPlayerFakeSpectate(PlayerGameModeChangeEvent e) {
        Player player = e.getPlayer();
        if (!Main.isPlayerInGame((Player)player)) {
            return;
        }
        if (player.getGameMode() == GameMode.ADVENTURE) {
            return;
        }
        if (e.getNewGameMode() != GameMode.ADVENTURE) {
            return;
        }
        if (!SBAConfig.getInstance().spectator().adventure()) {
            return;
        }
        Tasker.runDelayed(DefaultThreads.GLOBAL_THREAD, () -> {
            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 360000, 0));
            player.setAllowFlight(true);
            player.setFlying(true);
            player.setCollidable(false);
            org.screamingsandals.bedwars.api.game.Game game = Main.getInstance().getGameOfPlayer(player);
            Optional<IArena> arena = ArenaManager.getInstance().get(game.getName());
            arena.ifPresent(arena_ -> arena_.addHiddenPlayer(player));
        }, 1L, TaskerTime.TICKS);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBedWarsPlayerKilledEvent(EntityDamageByEntityEvent e) {
        if (!(e.getDamager() instanceof Player)) {
            return;
        }
        Player attacker = (Player)e.getDamager();
        if (!Main.isPlayerInGame((Player)attacker)) {
            return;
        }
        Game game = (Game)Main.getInstance().getGameOfPlayer(attacker);
        if (!game.isProtectionActive(attacker)) {
            return;
        }
        game.removeProtectedPlayer(attacker);
        if (Main.getConfigurator().config.getBoolean("respawn.show-messages")) {
            MiscUtils.sendActionBarMessage((Player)attacker, (String)I18n.i18nonly((String)"respawn_protection_end"));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBedWarsPlayerKilledEvent(PlayerDeathEvent e) {
        Player victim = e.getEntity();
        if (!Main.isPlayerInGame((Player)victim)) {
            return;
        }
        org.screamingsandals.bedwars.api.game.Game game = Main.getInstance().getGameOfPlayer(victim);
        ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> {
            arena.removeVisualsForPlayer(victim);
            arena.getPlayerData(victim.getUniqueId()).ifPresent(victimData -> victimData.setDeaths(victimData.getDeaths() + 1));
            Player killer = victim.getKiller();
            Logger.trace("Killer: {}", killer);
            if (killer != null) {
                GamePlayer gVictim = Main.getPlayerGameProfile((Player)victim);
                Logger.trace("gVictim: {}", gVictim);
                if (gVictim == null) {
                    return;
                }
                RunningTeam victimTeam = game.getTeamOfPlayer(victim);
                Logger.trace("victimTeam: {}", victimTeam);
                if (victimTeam != null) {
                    arena.getPlayerData(killer.getUniqueId()).ifPresent(killerData -> {
                        Logger.trace("Incrementing killer kills to: {}", killerData.getKills() + 1);
                        killerData.setKills(killerData.getKills() + 1);
                        if (!victimTeam.isAlive()) {
                            killerData.setFinalKills(killerData.getFinalKills() + 1);
                            Bukkit.getPluginManager().callEvent((Event)new SBAFinalKillEvent(game, victim, killer));
                            if (SBAConfig.getInstance().node("final-kill-lightning").getBoolean(true)) {
                                victim.getWorld().strikeLightningEffect(victim.getLocation());
                            }
                        }
                    });
                }
            }
        });
    }
}

