/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.listener;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.specials.SpawnerProtection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.Game;
import sba.sl.pa.Players;
import sba.sl.spectator.Component;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
@ServiceDependencies(dependsOn={SpawnerProtection.class})
public class SpawnerProtectionListener
implements Listener {
    @OnPostEnable
    public void registerListener() {
        if (SBA.isBroken()) {
            return;
        }
        SBA.getInstance().registerListener(this);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (!Main.isPlayerInGame((Player)player)) {
            return;
        }
        Game playerGame = Main.getInstance().getGameOfPlayer(player);
        if (SpawnerProtection.getInstance().isProtected(playerGame, event.getBlock().getLocation())) {
            event.setCancelled(true);
            Component component = LanguageService.getInstance().get(MessageKeys.SPAWNER_PROTECTION).toComponent();
            Players.wrapSender(player).sendMessage(component);
        }
    }
}

