/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.service;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.events.SBAPlayerWrapperPostUnregisterEvent;
import io.github.pronze.sba.events.SBAPlayerWrapperPreUnregisterEvent;
import io.github.pronze.sba.events.SBAPlayerWrapperRegisteredEvent;
import io.github.pronze.sba.service.WrapperService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import sba.sl.pa.Players;
import sba.sl.pu.ServiceManager;
import sba.sl.s.CommandSender;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
@ServiceDependencies(dependsOn={Logger.class})
public class PlayerWrapperService
implements WrapperService<Player, SBAPlayerWrapper> {
    private final Map<UUID, SBAPlayerWrapper> playerData = new ConcurrentHashMap<UUID, SBAPlayerWrapper>();
    private static boolean init = false;

    public static PlayerWrapperService getInstance() {
        return ServiceManager.get(PlayerWrapperService.class);
    }

    @OnPostEnable
    public void registerMapping() {
        if (SBA.isBroken()) {
            return;
        }
        if (!init) {
            Players.UNSAFE_getPlayerConverter().registerW2P(SBAPlayerWrapper.class, wrapper -> {
                if (wrapper.getType() == CommandSender.Type.PLAYER) {
                    if (!this.playerData.containsKey(wrapper.getUuid())) {
                        Player player = wrapper.as(Player.class);
                        this.register(player);
                    }
                    return this.playerData.get(wrapper.getUuid());
                }
                return null;
            });
        }
        init = true;
        Bukkit.getOnlinePlayers().forEach(this::register);
    }

    @Override
    public void register(Player player) {
        if (this.playerData.containsKey(player.getUniqueId())) {
            return;
        }
        SBAPlayerWrapper playerWrapper = new SBAPlayerWrapper(player);
        this.playerData.put(player.getUniqueId(), playerWrapper);
        SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)new SBAPlayerWrapperRegisteredEvent(playerWrapper));
    }

    @Override
    public void unregister(Player player) {
        if (!this.playerData.containsKey(player.getUniqueId())) {
            return;
        }
        SBAPlayerWrapper playerWrapper = this.playerData.get(player.getUniqueId());
        SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)new SBAPlayerWrapperPreUnregisterEvent(playerWrapper));
        this.playerData.remove(player.getUniqueId());
        SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)new SBAPlayerWrapperPostUnregisterEvent(player));
    }

    @Override
    public Optional<SBAPlayerWrapper> get(Player param) {
        return Optional.ofNullable(this.playerData.get(param.getUniqueId()));
    }
}

