/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.utils.citizens;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import sba.sl.h.Hologram;
import sba.sl.h.HologramManager;
import sba.sl.pa.Players;
import sba.sl.spectator.Component;
import sba.sl.w.Location;

public class HologramTrait
extends Trait {
    Hologram holo;
    org.bukkit.Location loc;
    List<Component> lines = new ArrayList<Component>();

    public HologramTrait() {
        super("SBAHologramTrait");
    }

    public void run() {
        org.bukkit.Location newLoc;
        NPC npc = this.getNPC();
        Entity entity = npc.getEntity();
        if (this.holo != null && entity != null && !this.loc.equals((Object)(newLoc = this.getNPC().getEntity().getLocation().add(0.0, 1.5, 0.0))) && this.loc.distance(newLoc) > 1.0) {
            this.loc = newLoc;
            this.holo.hide();
            this.holo.destroy();
            this.holo = HologramManager.hologram(Objects.requireNonNull(Location.fromPlatform(newLoc)));
            this.holo.setLines(this.lines);
            this.getNPC().getEntity().getLocation().getWorld().getPlayers().forEach(player -> this.holo.addViewer(Players.wrapPlayer(player)));
            this.holo.spawn();
        }
    }

    public void onDespawn() {
        if (this.holo != null) {
            this.holo.hide();
            this.holo.destroy();
        }
        this.holo = null;
    }

    public void onRemove() {
        if (this.holo != null) {
            this.holo.hide();
            this.holo.destroy();
        }
        this.holo = null;
    }

    public void onSpawn() {
        this.onDespawn();
        this.loc = this.getNPC().getEntity().getLocation().add(0.0, 1.5, 0.0);
        this.holo = HologramManager.hologram(Objects.requireNonNull(Location.fromPlatform(this.loc)));
        this.holo.setLines(this.lines);
        this.getNPC().getEntity().getLocation().getWorld().getPlayers().forEach(player -> this.holo.addViewer(Players.wrapPlayer(player)));
        this.holo.spawn();
    }

    public void setLines(List<Component> lines) {
        this.lines.clear();
        this.lines.addAll(lines);
        if (this.holo != null) {
            this.holo.setLines(this.lines);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        if (this.holo != null) {
            this.holo.removeViewer(Players.wrapPlayer(event.getPlayer()));
            Player player = event.getPlayer();
            if (this.holo.location().getWorld().getName().equals(player.getWorld().getName())) {
                this.holo.addViewer(Players.wrapPlayer(player));
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.holo != null) {
            Player player = event.getPlayer();
            if (this.holo.location().getWorld().getName().equals(player.getWorld().getName())) {
                this.holo.addViewer(Players.wrapPlayer(player));
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (this.holo != null) {
            this.holo.removeViewer(Players.wrapPlayer(event.getPlayer()));
            Player player = event.getPlayer();
            if (this.holo.location().getWorld().getName().equals(player.getWorld().getName())) {
                this.holo.addViewer(Players.wrapPlayer(player));
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerLeave(PlayerQuitEvent event) {
        if (this.holo != null) {
            this.holo.removeViewer(Players.wrapPlayer(event.getPlayer()));
        }
    }
}

