/*
 * Decompiled with CFR 0.152.
 */
package sba.si.builder;

import java.util.List;
import sba.sl.i.ItemStack;
import sba.sl.i.builder.ItemStackBuilder;
import sba.sl.i.builder.ItemStackFactory;
import sba.sl.u.ReceiverConsumer;

public class AnimationBuilder {
    private final List<ItemStack> stacks;

    public AnimationBuilder stack(Object material) {
        ItemStack item = ItemStackFactory.build(material);
        this.stacks.add(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public AnimationBuilder stack(Object material, ReceiverConsumer<ItemStackBuilder> consumer) {
        ItemStack item = ItemStackFactory.build(material, consumer);
        this.stacks.add(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public AnimationBuilder stack(ReceiverConsumer<ItemStackBuilder> consumer) {
        ItemStack item = ItemStackFactory.build(consumer);
        this.stacks.add(item != null ? item : ItemStackFactory.getAir());
        return this;
    }

    public AnimationBuilder clear() {
        this.stacks.clear();
        return this;
    }

    private AnimationBuilder(List<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public static AnimationBuilder of(List<ItemStack> stacks) {
        return new AnimationBuilder(stacks);
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }
}

