/*
 * Decompiled with CFR 0.152.
 */
package sba.si.placeholders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import sba.si.inventory.PlayerItemInfo;
import sba.si.placeholders.PlaceholderParser;
import sba.sl.pa.Player;

public class RuntimeDefinedPlaceholder
implements PlaceholderParser {
    private Map<String, String> map = new HashMap<String, String>();
    private String defstr = null;

    @Override
    public String processPlaceholder(String key, Player player, PlayerItemInfo item, String[] arguments) {
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String keys = entry.getKey();
            String value = entry.getValue();
            String[] split = keys.split("(?<!\\.)\\.(?!\\.)");
            if (split.length > arguments.length) continue;
            ArrayList<String> dollars = new ArrayList<String>();
            for (int i = 0; i < arguments.length && i < split.length && (split[i].equals("$") || arguments[i].equals(split[i])); ++i) {
                if (split[i].equals("$")) {
                    dollars.add(arguments[i]);
                }
                if (i != arguments.length - 1) continue;
                Object parsedOutput = "";
                int lastIndexOfEscape = -2;
                for (int j = 0; j < value.length(); ++j) {
                    if (lastIndexOfEscape != j - 1 && value.charAt(j) == '$' && !dollars.isEmpty()) {
                        parsedOutput = (String)parsedOutput + (String)dollars.get(0);
                        dollars.remove(0);
                        continue;
                    }
                    if (lastIndexOfEscape != j - 1 && value.charAt(j) == '\\') {
                        lastIndexOfEscape = j;
                        continue;
                    }
                    parsedOutput = (String)parsedOutput + value.charAt(j);
                }
                return item.getFormat().processPlaceholders(player, (String)parsedOutput, item);
            }
        }
        if (this.defstr != null) {
            return item.getFormat().processPlaceholders(player, this.defstr, item);
        }
        return null;
    }

    public void putDefault(String defstr) {
        this.defstr = defstr;
    }

    public void register(String keys, String value) {
        this.map.put(keys, value);
    }

    public void unregister(String keys) {
        this.map.remove(keys);
    }
}

