/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.a;

import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.api.Wrapper;
import sba.sl.impl.attribute.AttributeModifierIds;
import sba.sl.impl.attribute.Attributes;
import sba.sl.u.Pair;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.ide.LimitedVersionSupport;

public class AttributeModifier
implements Wrapper {
    @NotNull
    private final ResourceLocation location;
    @Nullable
    private final UUID uuid;
    @Nullable
    private final String name;
    private final double amount;
    @NotNull
    private final Operation operation;

    public AttributeModifier(@NotNull ResourceLocation location, double amount, @NotNull Operation operation) {
        this.location = location;
        if (!Server.isVersion(1, 21)) {
            Pair<UUID, String> downgrade = AttributeModifierIds.downgradeResourceLocation(location);
            this.uuid = downgrade.first();
            this.name = downgrade.second();
        } else {
            this.uuid = null;
            this.name = null;
        }
        this.amount = amount;
        this.operation = operation;
    }

    public AttributeModifier(@NotNull UUID uuid, @NotNull String name, double amount, @NotNull Operation operation) {
        this.location = AttributeModifierIds.getResourceLocation(uuid, name);
        this.uuid = uuid;
        this.name = name;
        this.amount = amount;
        this.operation = operation;
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        return Attributes.convertAttributeModifierHolder(this, type);
    }

    @NotNull
    @Generated
    public ResourceLocation getLocation() {
        return this.location;
    }

    @Generated
    public double getAmount() {
        return this.amount;
    }

    @NotNull
    @Generated
    public Operation getOperation() {
        return this.operation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeModifier)) {
            return false;
        }
        AttributeModifier other = (AttributeModifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        ResourceLocation this$location = this.getLocation();
        ResourceLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Operation this$operation = this.getOperation();
        Operation other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AttributeModifier;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        ResourceLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AttributeModifier(location=" + String.valueOf(this.getLocation()) + ", uuid=" + String.valueOf(this.getUuid()) + ", name=" + this.getName() + ", amount=" + this.getAmount() + ", operation=" + String.valueOf((Object)this.getOperation()) + ")";
    }

    @ApiStatus.Obsolete
    @LimitedVersionSupport(value="<= 1.20.6; most likely contains null on 1.21+")
    @Nullable
    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @ApiStatus.Obsolete
    @LimitedVersionSupport(value="<= 1.20.6; most likely contains null on 1.21+")
    @Nullable
    @Generated
    public String getName() {
        return this.name;
    }

    public static enum Operation {
        ADD_VALUE,
        ADD_MULTIPLIED_BASE,
        ADD_MULTIPLIED_TOTAL;


        @NotNull
        public static Operation byOrdinal(int ordinal) {
            return Operation.values()[ordinal];
        }
    }
}

