/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types.server;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
public interface BlockSnapshotHolder
extends Wrapper {
    @NotNull
    public static BlockSnapshotHolder of(@NotNull Object blockSnapshot) {
        BlockSnapshotHolder result = BlockSnapshotHolder.ofNullable(blockSnapshot);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap block snapshot: " + String.valueOf(blockSnapshot));
        }
        return result;
    }

    @Nullable
    public static BlockSnapshotHolder ofNullable(@Nullable Object blockSnapshot) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + BlockSnapshotHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (blockSnapshot == null) {
            return null;
        }
        return Provider.provider.apply(blockSnapshot);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable BlockSnapshotHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable BlockSnapshotHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + BlockSnapshotHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

