/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.e.villager;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.entity.villager.VillagerTypeRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.LimitedVersionSupport;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

@LimitedVersionSupport(value=">= 1.14; <= 1.13.2: the only existing villager type is minecraft:plains")
public interface VillagerType
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.VILLAGER_TYPE) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static VillagerType of(@MinecraftType(value=MinecraftType.Type.VILLAGER_TYPE) @NotNull Object villagerTypes) {
        VillagerType result = VillagerType.ofNullable(villagerTypes);
        Preconditions.checkNotNullIllegal(result, "Could not find villager type: " + String.valueOf(villagerTypes));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static VillagerType ofNullable(@MinecraftType(value=MinecraftType.Type.VILLAGER_TYPE) @Nullable Object villagerType) {
        if (villagerType instanceof VillagerType) {
            return (VillagerType)villagerType;
        }
        return (VillagerType)VillagerTypeRegistry.getInstance().resolveMapping(villagerType);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull VillagerType> all() {
        return VillagerTypeRegistry.getInstance().getRegistryItemStream();
    }
}

