/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.compat.v1_12_2;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.NetherWartsState;
import org.bukkit.block.BlockFace;
import org.bukkit.material.Banner;
import org.bukkit.material.Bed;
import org.bukkit.material.Button;
import org.bukkit.material.Cake;
import org.bukkit.material.Cauldron;
import org.bukkit.material.Chest;
import org.bukkit.material.CocoaPlant;
import org.bukkit.material.Command;
import org.bukkit.material.Crops;
import org.bukkit.material.Diode;
import org.bukkit.material.DirectionalContainer;
import org.bukkit.material.Dispenser;
import org.bukkit.material.Door;
import org.bukkit.material.EnderChest;
import org.bukkit.material.ExtendedRails;
import org.bukkit.material.Furnace;
import org.bukkit.material.Gate;
import org.bukkit.material.Ladder;
import org.bukkit.material.Lever;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Mushroom;
import org.bukkit.material.NetherWarts;
import org.bukkit.material.PistonBaseMaterial;
import org.bukkit.material.PistonExtensionMaterial;
import org.bukkit.material.PressurePlate;
import org.bukkit.material.Pumpkin;
import org.bukkit.material.Rails;
import org.bukkit.material.RedstoneTorch;
import org.bukkit.material.RedstoneWire;
import org.bukkit.material.Sign;
import org.bukkit.material.Skull;
import org.bukkit.material.Stairs;
import org.bukkit.material.Torch;
import org.bukkit.material.TrapDoor;
import org.bukkit.material.Tree;
import org.bukkit.material.Tripwire;
import org.bukkit.material.TripwireHook;
import org.bukkit.material.Vine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.BukkitFeature;

public final class LegacyMaterialDataToFlatteningConverter {
    @NotNull
    public static MaterialData set(@NotNull MaterialData materialData, @NotNull String key, @NotNull String value) {
        block1032: {
            materialData = materialData.clone();
            String materialName = materialData.getItemType().name();
            try {
                block1034: {
                    block1033: {
                        if ("ANVIL".equals(materialName)) {
                            if ("facing".equalsIgnoreCase(key)) {
                                switch (value.toLowerCase(Locale.ROOT)) {
                                    case "east": {
                                        materialData.setData((byte)(materialData.getData() & 0xC | 2));
                                        break;
                                    }
                                    case "west": {
                                        materialData.setData((byte)(materialData.getData() & 0xC));
                                        break;
                                    }
                                    case "north": {
                                        materialData.setData((byte)(materialData.getData() & 0xC | 1));
                                        break;
                                    }
                                    case "south": {
                                        materialData.setData((byte)(materialData.getData() & 0xC | 3));
                                    }
                                }
                            }
                            break block1032;
                        }
                        if (materialData instanceof Banner) {
                            if (((Banner)materialData).isWallBanner()) {
                                if ("facing".equalsIgnoreCase(key)) {
                                    switch (value.toLowerCase(Locale.ROOT)) {
                                        case "east": {
                                            ((Banner)materialData).setFacingDirection(BlockFace.EAST);
                                            break;
                                        }
                                        case "west": {
                                            ((Banner)materialData).setFacingDirection(BlockFace.WEST);
                                            break;
                                        }
                                        case "north": {
                                            ((Banner)materialData).setFacingDirection(BlockFace.NORTH);
                                            break;
                                        }
                                        case "south": {
                                            ((Banner)materialData).setFacingDirection(BlockFace.SOUTH);
                                        }
                                    }
                                }
                            } else if ("rotation".equalsIgnoreCase(key)) {
                                Banner c = ((Banner)materialData).clone();
                                c.setData(Byte.parseByte(value));
                                return c;
                            }
                            break block1032;
                        }
                        if (materialData instanceof Bed) {
                            block29 : switch (key.toLowerCase(Locale.ROOT)) {
                                case "facing": {
                                    switch (value.toLowerCase(Locale.ROOT)) {
                                        case "east": {
                                            ((Bed)materialData).setFacingDirection(BlockFace.EAST);
                                            break block29;
                                        }
                                        case "west": {
                                            ((Bed)materialData).setFacingDirection(BlockFace.WEST);
                                            break block29;
                                        }
                                        case "north": {
                                            ((Bed)materialData).setFacingDirection(BlockFace.NORTH);
                                            break block29;
                                        }
                                        case "south": {
                                            ((Bed)materialData).setFacingDirection(BlockFace.SOUTH);
                                        }
                                    }
                                    break;
                                }
                                case "part": {
                                    if ("head".equalsIgnoreCase(value)) {
                                        ((Bed)materialData).setHeadOfBed(true);
                                        break;
                                    }
                                    if (!"foot".equalsIgnoreCase(value)) break;
                                    ((Bed)materialData).setHeadOfBed(false);
                                }
                            }
                            break block1032;
                        }
                        if (materialData instanceof Crops || "CARROT".equals(materialName) || "POTATO".equals(materialName)) {
                            if ("age".equalsIgnoreCase(key)) {
                                byte age = Byte.parseByte(value);
                                if ("BEETROOT_BLOCK".equals(materialName) || "NETHER_WARTS".equals(materialName)) {
                                    if (age < 0 || age > 3) {
                                        age = 0;
                                    }
                                } else if (age < 0 || age > 7) {
                                    age = 0;
                                }
                                materialData.setData(age);
                            }
                            break block1032;
                        }
                        if (materialData instanceof NetherWarts) {
                            if ("age".equalsIgnoreCase(key)) {
                                byte age = Byte.parseByte(value);
                                if (age < 0 || age > 3) {
                                    age = 0;
                                }
                                ((NetherWarts)materialData).setState(NetherWartsState.values()[age]);
                            }
                            break block1032;
                        }
                        if ("BREWING_STAND".equals(materialName)) {
                            switch (key.toLowerCase(Locale.ROOT)) {
                                case "has_bottle_0": {
                                    if (Boolean.parseBoolean(value)) {
                                        materialData.setData((byte)(materialData.getData() | 1));
                                        break;
                                    }
                                    materialData.setData((byte)(materialData.getData() & 0xFFFFFFFE));
                                    break;
                                }
                                case "has_bottle_1": {
                                    if (Boolean.parseBoolean(value)) {
                                        materialData.setData((byte)(materialData.getData() | 2));
                                        break;
                                    }
                                    materialData.setData((byte)(materialData.getData() & 0xFFFFFFFD));
                                    break;
                                }
                                case "has_bottle_2": {
                                    if (Boolean.parseBoolean(value)) {
                                        materialData.setData((byte)(materialData.getData() | 4));
                                        break;
                                    }
                                    materialData.setData((byte)(materialData.getData() & 0xFFFFFFFB));
                                }
                            }
                            break block1032;
                        }
                        if (!(materialData instanceof Button)) break block1033;
                        block60 : switch (key.toLowerCase(Locale.ROOT)) {
                            case "powered": {
                                ((Button)materialData).setPowered(Boolean.parseBoolean(value));
                                break;
                            }
                            case "facing": {
                                if (((Button)materialData).getFacing() == BlockFace.UP || ((Button)materialData).getFacing() == BlockFace.DOWN) break;
                                switch (value.toLowerCase(Locale.ROOT)) {
                                    case "east": {
                                        ((Button)materialData).setFacingDirection(BlockFace.EAST);
                                        break block60;
                                    }
                                    case "west": {
                                        ((Button)materialData).setFacingDirection(BlockFace.WEST);
                                        break block60;
                                    }
                                    case "north": {
                                        ((Button)materialData).setFacingDirection(BlockFace.NORTH);
                                        break block60;
                                    }
                                    case "south": {
                                        ((Button)materialData).setFacingDirection(BlockFace.SOUTH);
                                    }
                                }
                                break;
                            }
                            case "face": {
                                switch (value.toLowerCase(Locale.ROOT)) {
                                    case "wall": {
                                        if (((Button)materialData).getFacing() == BlockFace.UP || ((Button)materialData).getFacing() == BlockFace.DOWN) {
                                            ((Button)materialData).setFacingDirection(BlockFace.NORTH);
                                            break block60;
                                        }
                                        break block1032;
                                    }
                                    case "ceiling": {
                                        ((Button)materialData).setFacingDirection(BlockFace.DOWN);
                                        break block60;
                                    }
                                    case "floor": {
                                        ((Button)materialData).setFacingDirection(BlockFace.UP);
                                    }
                                }
                            }
                        }
                        break block1032;
                    }
                    if ("CACTUS".equals(materialName) || "SUGAR_CANE_BLOCK".equals(materialName)) {
                        if ("age".equalsIgnoreCase(key)) {
                            byte age = Byte.parseByte(value);
                            if (age < 0 || age > 15) {
                                age = 0;
                            }
                            materialData.setData(age);
                        }
                        break block1032;
                    }
                    if (materialData instanceof Cake) {
                        if ("bites".equalsIgnoreCase(key)) {
                            byte bites = Byte.parseByte(value);
                            if (bites < 0 || bites > 6) {
                                bites = 0;
                            }
                            materialData.setData(bites);
                        }
                        break block1032;
                    }
                    if (materialData instanceof Cauldron) {
                        if ("level".equalsIgnoreCase(key)) {
                            byte level = Byte.parseByte(value);
                            if (level < 0 || level > 3) {
                                level = 0;
                            }
                            materialData.setData(level);
                        }
                        break block1032;
                    }
                    if (materialData instanceof DirectionalContainer) {
                        if (materialData instanceof Chest || materialData instanceof EnderChest) {
                            if ("facing".equalsIgnoreCase(key)) {
                                switch (value.toLowerCase(Locale.ROOT)) {
                                    case "east": {
                                        ((DirectionalContainer)materialData).setFacingDirection(BlockFace.EAST);
                                        break;
                                    }
                                    case "west": {
                                        ((DirectionalContainer)materialData).setFacingDirection(BlockFace.WEST);
                                        break;
                                    }
                                    case "north": {
                                        ((DirectionalContainer)materialData).setFacingDirection(BlockFace.NORTH);
                                        break;
                                    }
                                    case "south": {
                                        ((DirectionalContainer)materialData).setFacingDirection(BlockFace.SOUTH);
                                    }
                                }
                            }
                        } else if (materialData instanceof Dispenser) {
                            block103 : switch (key.toLowerCase(Locale.ROOT)) {
                                case "facing": {
                                    switch (value.toLowerCase(Locale.ROOT)) {
                                        case "down": {
                                            materialData.setData((byte)(materialData.getData() & 8));
                                            break block103;
                                        }
                                        case "up": {
                                            materialData.setData((byte)(materialData.getData() & 8 | 1));
                                            break block103;
                                        }
                                        case "east": {
                                            materialData.setData((byte)(materialData.getData() & 8 | 5));
                                            break block103;
                                        }
                                        case "west": {
                                            materialData.setData((byte)(materialData.getData() & 8 | 4));
                                            break block103;
                                        }
                                        case "north": {
                                            materialData.setData((byte)(materialData.getData() & 8 | 2));
                                            break block103;
                                        }
                                        case "south": {
                                            materialData.setData((byte)(materialData.getData() & 8 | 3));
                                        }
                                    }
                                    break;
                                }
                                case "triggered": {
                                    boolean bool = Boolean.parseBoolean(value);
                                    if (bool) {
                                        materialData.setData((byte)(materialData.getData() | 8));
                                        break;
                                    }
                                    materialData.setData((byte)(materialData.getData() & 0xFFFFFFF7));
                                }
                            }
                        } else if (materialData instanceof Furnace) {
                            block127 : switch (key.toLowerCase(Locale.ROOT)) {
                                case "facing": {
                                    switch (value.toLowerCase(Locale.ROOT)) {
                                        case "east": {
                                            ((Furnace)materialData).setFacingDirection(BlockFace.EAST);
                                            break block127;
                                        }
                                        case "west": {
                                            ((Furnace)materialData).setFacingDirection(BlockFace.WEST);
                                            break block127;
                                        }
                                        case "north": {
                                            ((Furnace)materialData).setFacingDirection(BlockFace.NORTH);
                                            break block127;
                                        }
                                        case "south": {
                                            ((Furnace)materialData).setFacingDirection(BlockFace.SOUTH);
                                        }
                                    }
                                    break;
                                }
                                case "lit": {
                                    boolean bool = Boolean.parseBoolean(value);
                                    if (bool && "FURNACE".equals(materialName)) {
                                        materialData = new Furnace(Material.valueOf((String)"BURNING_FURNACE"), materialData.getData());
                                        break;
                                    }
                                    if (bool || !"BURNING_FURNACE".equals(materialName)) break;
                                    materialData = new Furnace(Material.valueOf((String)"FURNACE"), materialData.getData());
                                }
                            }
                        }
                        break block1032;
                    }
                    if ("CHORUS_FLOWER".equalsIgnoreCase(materialName)) {
                        if ("age".equalsIgnoreCase(key)) {
                            byte age = Byte.parseByte(value);
                            if (age < 0 || age > 5) {
                                age = 0;
                            }
                            materialData.setData(age);
                        }
                        break block1032;
                    }
                    if (materialData instanceof CocoaPlant) {
                        block147 : switch (key.toLowerCase(Locale.ROOT)) {
                            case "age": {
                                byte age = Byte.parseByte(value);
                                if (age < 0 || age > 2) {
                                    age = 0;
                                }
                                ((CocoaPlant)materialData).setSize(CocoaPlant.CocoaPlantSize.values()[age]);
                                break;
                            }
                            case "facing": {
                                switch (value.toLowerCase(Locale.ROOT)) {
                                    case "east": {
                                        ((CocoaPlant)materialData).setFacingDirection(BlockFace.WEST);
                                        break block147;
                                    }
                                    case "west": {
                                        ((CocoaPlant)materialData).setFacingDirection(BlockFace.EAST);
                                        break block147;
                                    }
                                    case "north": {
                                        ((CocoaPlant)materialData).setFacingDirection(BlockFace.SOUTH);
                                        break block147;
                                    }
                                    case "south": {
                                        ((CocoaPlant)materialData).setFacingDirection(BlockFace.NORTH);
                                    }
                                }
                            }
                        }
                        break block1032;
                    }
                    if (materialData instanceof Command) {
                        if (BukkitFeature.COMMAND_BLOCK_VERBOSE_BLOCK_STATE.isSupported()) {
                            block167 : switch (key.toLowerCase(Locale.ROOT)) {
                                case "conditional": {
                                    materialData.setData((byte)(Boolean.parseBoolean(value) ? materialData.getData() | 8 : materialData.getData() & 0xFFFFFFF7));
                                    break;
                                }
                                case "facing": {
                                    switch (value.toLowerCase(Locale.ROOT)) {
                                        case "down": {
                                            materialData.setData((byte)(materialData.getData() & 8));
                                            break block167;
                                        }
                                        case "east": {
                                            materialData.setData((byte)(materialData.getData() & 8 | 5));
                                            break block167;
                                        }
                                        case "north": {
                                            materialData.setData((byte)(materialData.getData() & 8 | 2));
                                            break block167;
                                        }
                                        case "south": {
                                            materialData.setData((byte)(materialData.getData() & 8 | 3));
                                            break block167;
                                        }
                                        case "up": {
                                            materialData.setData((byte)(materialData.getData() & 8 | 1));
                                            break block167;
                                        }
                                        case "west": {
                                            materialData.setData((byte)(materialData.getData() & 8 | 4));
                                        }
                                    }
                                }
                            }
                        }
                        break block1032;
                    }
                    if ("DAYLIGHT_DETECTOR".equals(materialName) || "DAYLIGHT_DETECTOR_INVERTED".equals(materialName)) {
                        switch (key.toLowerCase(Locale.ROOT)) {
                            case "inverted": {
                                boolean bool = Boolean.parseBoolean(value);
                                if (bool) {
                                    materialData = new MaterialData(Material.valueOf((String)"DAYLIGHT_DETECTOR_INVERTED"), materialData.getData());
                                    break;
                                }
                                materialData = new MaterialData(Material.valueOf((String)"DAYLIGHT_DETECTOR"), materialData.getData());
                                break;
                            }
                            case "power": {
                                byte power = Byte.parseByte(value);
                                if (power < 0 || power > 15) {
                                    power = 0;
                                }
                                materialData.setData(power);
                            }
                        }
                        break block1032;
                    }
                    if (materialData instanceof Door) {
                        if (((Door)materialData).isTopHalf()) {
                            switch (key.toLowerCase(Locale.ROOT)) {
                                case "half": {
                                    if (!"lower".equalsIgnoreCase(value)) break;
                                    materialData.setData((byte)0);
                                    ((Door)materialData).setTopHalf(false);
                                    break;
                                }
                                case "powered": {
                                    boolean bool = Boolean.parseBoolean(value);
                                    if (bool) {
                                        materialData.setData((byte)(materialData.getData() | 2));
                                        break;
                                    }
                                    materialData.setData((byte)(materialData.getData() & 0xFFFFFFFD));
                                    break;
                                }
                                case "hinge": {
                                    if ("left".equalsIgnoreCase(value)) {
                                        ((Door)materialData).setHinge(false);
                                        break;
                                    }
                                    if (!"right".equalsIgnoreCase(value)) break;
                                    ((Door)materialData).setHinge(true);
                                }
                            }
                        } else {
                            block210 : switch (key.toLowerCase(Locale.ROOT)) {
                                case "half": {
                                    if (!"upper".equalsIgnoreCase(value)) break;
                                    materialData.setData((byte)0);
                                    ((Door)materialData).setTopHalf(true);
                                    break;
                                }
                                case "open": {
                                    ((Door)materialData).setOpen(Boolean.parseBoolean(value));
                                    break;
                                }
                                case "facing": {
                                    switch (value.toLowerCase(Locale.ROOT)) {
                                        case "east": {
                                            ((Door)materialData).setFacingDirection(BlockFace.EAST);
                                            break block210;
                                        }
                                        case "north": {
                                            ((Door)materialData).setFacingDirection(BlockFace.NORTH);
                                            break block210;
                                        }
                                        case "south": {
                                            ((Door)materialData).setFacingDirection(BlockFace.SOUTH);
                                            break block210;
                                        }
                                        case "west": {
                                            ((Door)materialData).setFacingDirection(BlockFace.WEST);
                                        }
                                    }
                                }
                            }
                        }
                        break block1032;
                    }
                    if ("ENDER_PORTAL_FRAME".equals(materialName)) {
                        block231 : switch (key.toLowerCase(Locale.ROOT)) {
                            case "eye": {
                                boolean bool = Boolean.parseBoolean(value);
                                if (bool) {
                                    materialData.setData((byte)(materialData.getData() | 4));
                                    break;
                                }
                                materialData.setData((byte)(materialData.getData() & 0xFFFFFFFB));
                                break;
                            }
                            case "facing": {
                                switch (value.toLowerCase(Locale.ROOT)) {
                                    case "east": {
                                        materialData.setData((byte)(materialData.getData() & 4 | 3));
                                        break block231;
                                    }
                                    case "north": {
                                        materialData.setData((byte)(materialData.getData() & 4 | 2));
                                        break block231;
                                    }
                                    case "south": {
                                        materialData.setData((byte)(materialData.getData() & 4));
                                        break block231;
                                    }
                                    case "west": {
                                        materialData.setData((byte)(materialData.getData() & 4 | 1));
                                    }
                                }
                            }
                        }
                        break block1032;
                    }
                    if ("END_ROD".equals(materialName)) {
                        if ("facing".equalsIgnoreCase(key)) {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "up": {
                                    materialData.setData((byte)1);
                                    break;
                                }
                                case "down": {
                                    materialData.setData((byte)0);
                                    break;
                                }
                                case "east": {
                                    materialData.setData((byte)5);
                                    break;
                                }
                                case "north": {
                                    materialData.setData((byte)2);
                                    break;
                                }
                                case "south": {
                                    materialData.setData((byte)3);
                                    break;
                                }
                                case "west": {
                                    materialData.setData((byte)4);
                                }
                            }
                        }
                        break block1032;
                    }
                    if ("SOIL".equals(materialName)) {
                        if ("moisture".equalsIgnoreCase(key)) {
                            byte moisture = Byte.parseByte(value);
                            if (moisture < 0 || moisture > 7) {
                                moisture = 0;
                            }
                            materialData.setData(moisture);
                        }
                        break block1032;
                    }
                    if (materialData instanceof Gate) {
                        block267 : switch (key.toLowerCase(Locale.ROOT)) {
                            case "facing": {
                                switch (value.toLowerCase(Locale.ROOT)) {
                                    case "east": {
                                        materialData.setData((byte)(materialData.getData() & 4 | 3));
                                        break block267;
                                    }
                                    case "north": {
                                        materialData.setData((byte)(materialData.getData() & 4 | 2));
                                        break block267;
                                    }
                                    case "south": {
                                        materialData.setData((byte)(materialData.getData() & 4));
                                        break block267;
                                    }
                                    case "west": {
                                        materialData.setData((byte)(materialData.getData() & 4 | 1));
                                    }
                                }
                                break;
                            }
                            case "open": {
                                ((Gate)materialData).setOpen(Boolean.parseBoolean(value));
                            }
                        }
                        break block1032;
                    }
                    if ("FIRE".equals(materialName)) {
                        if ("age".equalsIgnoreCase(key)) {
                            byte fire = Byte.parseByte(value);
                            if (fire < 0 || fire > 15) {
                                fire = 0;
                            }
                            materialData.setData(fire);
                        }
                        break block1032;
                    }
                    if ("DOUBLE_PLANT".equals(materialName)) {
                        if ("half".equalsIgnoreCase(key)) {
                            if ("lower".equalsIgnoreCase(value)) {
                                materialData.setData((byte)(materialData.getData() & 0xFFFFFFF7));
                            } else if ("upper".equalsIgnoreCase(value)) {
                                materialData.setData((byte)(materialData.getData() | 8));
                            }
                        }
                        break block1032;
                    }
                    if ("FROSTED_ICE".equals(materialName)) {
                        if ("age".equalsIgnoreCase(key)) {
                            byte age = Byte.parseByte(value);
                            if (age < 0 || age > 3) {
                                age = 0;
                            }
                            materialData.setData(age);
                        }
                        break block1032;
                    }
                    if (materialName.endsWith("GLAZED_TERRACOTTA")) {
                        if ("facing".equalsIgnoreCase(key)) {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "east": {
                                    materialData.setData((byte)3);
                                    break;
                                }
                                case "north": {
                                    materialData.setData((byte)2);
                                    break;
                                }
                                case "south": {
                                    materialData.setData((byte)0);
                                    break;
                                }
                                case "west": {
                                    materialData.setData((byte)1);
                                }
                            }
                        }
                        break block1032;
                    }
                    if ("HOPPER".equalsIgnoreCase(materialName)) {
                        block299 : switch (key.toLowerCase(Locale.ROOT)) {
                            case "enabled": {
                                boolean bool = Boolean.parseBoolean(value);
                                if (bool) {
                                    materialData.setData((byte)(materialData.getData() & 0xFFFFFFF7));
                                    break;
                                }
                                materialData.setData((byte)(materialData.getData() | 8));
                                break;
                            }
                            case "facing": {
                                switch (value.toLowerCase(Locale.ROOT)) {
                                    case "down": {
                                        materialData.setData((byte)(materialData.getData() & 8));
                                        break block299;
                                    }
                                    case "east": {
                                        materialData.setData((byte)(materialData.getData() & 8 | 5));
                                        break block299;
                                    }
                                    case "north": {
                                        materialData.setData((byte)(materialData.getData() & 8 | 2));
                                        break block299;
                                    }
                                    case "south": {
                                        materialData.setData((byte)(materialData.getData() & 8 | 3));
                                        break block299;
                                    }
                                    case "west": {
                                        materialData.setData((byte)(materialData.getData() & 8 | 4));
                                    }
                                }
                            }
                        }
                        break block1032;
                    }
                    if (materialData instanceof Pumpkin) {
                        if ("facing".equalsIgnoreCase(key)) {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "east": {
                                    ((Pumpkin)materialData).setFacingDirection(BlockFace.EAST);
                                    break;
                                }
                                case "north": {
                                    ((Pumpkin)materialData).setFacingDirection(BlockFace.NORTH);
                                    break;
                                }
                                case "south": {
                                    ((Pumpkin)materialData).setFacingDirection(BlockFace.SOUTH);
                                    break;
                                }
                                case "west": {
                                    ((Pumpkin)materialData).setFacingDirection(BlockFace.WEST);
                                }
                            }
                        }
                        break block1032;
                    }
                    if ("JUKEBOX".equals(materialName)) {
                        if ("has_record".equalsIgnoreCase(key)) {
                            boolean bool = Boolean.parseBoolean(value);
                            if (bool) {
                                materialData.setData((byte)0);
                            } else {
                                materialData.setData((byte)1);
                            }
                        }
                        break block1032;
                    }
                    if (materialData instanceof Ladder) {
                        if ("facing".equalsIgnoreCase(key)) {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "east": {
                                    ((Ladder)materialData).setFacingDirection(BlockFace.EAST);
                                    break;
                                }
                                case "north": {
                                    ((Ladder)materialData).setFacingDirection(BlockFace.NORTH);
                                    break;
                                }
                                case "south": {
                                    ((Ladder)materialData).setFacingDirection(BlockFace.SOUTH);
                                    break;
                                }
                                case "west": {
                                    ((Ladder)materialData).setFacingDirection(BlockFace.WEST);
                                }
                            }
                        }
                        break block1032;
                    }
                    if ("WATER".equals(materialName) || "STATIONARY_WATER".equals(materialName) || "LAVA".equals(materialName) || "STATIONARY_LAVA".equals(materialName)) {
                        if ("level".equalsIgnoreCase(key)) {
                            byte level = Byte.parseByte(value);
                            if (level < 0 || level > 15) {
                                level = 0;
                            }
                            materialData.setData(level);
                        }
                        break block1032;
                    }
                    if ("LEAVES".equals(materialName) || "LEAVES_2".equals(materialName)) {
                        if ("persistent".equalsIgnoreCase(key)) {
                            boolean bool = Boolean.parseBoolean(value);
                            if (bool) {
                                materialData.setData((byte)(materialData.getData() | 4));
                            } else {
                                materialData.setData((byte)(materialData.getData() & 0xFFFFFFFB));
                            }
                        }
                        break block1032;
                    }
                    if (!(materialData instanceof Lever)) break block1034;
                    block346 : switch (key.toLowerCase(Locale.ROOT)) {
                        case "face": {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "ceiling": {
                                    if (((Lever)materialData).getAttachedFace() != BlockFace.UP) {
                                        byte oldData = materialData.getData();
                                        materialData.setData((byte)(oldData & 8));
                                        int oldFacing = oldData & 7;
                                        if (oldFacing == 3 || oldFacing == 4 || oldFacing == 5) {
                                            ((Lever)materialData).setFacingDirection(BlockFace.SOUTH);
                                            break;
                                        }
                                        break block1032;
                                    }
                                    break block1032;
                                }
                                case "wall": {
                                    if (((Lever)materialData).getAttachedFace() == BlockFace.UP || ((Lever)materialData).getAttachedFace() == BlockFace.DOWN) {
                                        byte oldData = materialData.getData();
                                        materialData.setData((byte)(oldData & 8 | 3));
                                        int oldFacing = oldData & 7;
                                        if (oldFacing == 5 || oldFacing == 7) {
                                            ((Lever)materialData).setFacingDirection(BlockFace.SOUTH);
                                            break;
                                        }
                                        break block1032;
                                    }
                                    break block1032;
                                }
                                case "floor": {
                                    if (((Lever)materialData).getAttachedFace() != BlockFace.DOWN) {
                                        byte oldData = materialData.getData();
                                        materialData.setData((byte)(oldData & 8 | 6));
                                        int oldFacing = oldData & 7;
                                        if (oldFacing == 3 || oldFacing == 4 || oldFacing == 7) {
                                            ((Lever)materialData).setFacingDirection(BlockFace.SOUTH);
                                        } else {
                                            break;
                                        }
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break block1032;
                        }
                        case "facing": {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "east": {
                                    ((Lever)materialData).setFacingDirection(BlockFace.EAST);
                                    break block346;
                                }
                                case "north": {
                                    ((Lever)materialData).setFacingDirection(BlockFace.NORTH);
                                    break block346;
                                }
                                case "south": {
                                    ((Lever)materialData).setFacingDirection(BlockFace.SOUTH);
                                    break block346;
                                }
                                case "west": {
                                    ((Lever)materialData).setFacingDirection(BlockFace.WEST);
                                }
                            }
                            break;
                        }
                        case "powered": {
                            ((Lever)materialData).setPowered(Boolean.parseBoolean(value));
                        }
                    }
                    break block1032;
                }
                if (materialData instanceof Tree) {
                    if ("axis".equalsIgnoreCase(key) && ((Tree)materialData).getDirection() != BlockFace.SELF) {
                        switch (value.toLowerCase(Locale.ROOT)) {
                            case "x": {
                                ((Tree)materialData).setDirection(BlockFace.EAST);
                                break;
                            }
                            case "y": {
                                ((Tree)materialData).setDirection(BlockFace.UP);
                                break;
                            }
                            case "z": {
                                ((Tree)materialData).setDirection(BlockFace.SOUTH);
                            }
                        }
                    }
                } else if ("MELON_STEM".equals(materialName) || "PUMPKIN_STEM".equals(materialName)) {
                    if ("age".equalsIgnoreCase(key)) {
                        byte age = Byte.parseByte(value);
                        if (age < 0 || age > 7) {
                            age = 0;
                        }
                        materialData.setData(age);
                    }
                } else if (materialData instanceof Skull) {
                    if (((Skull)materialData).getFacing() != BlockFace.SELF && "facing".equalsIgnoreCase(key)) {
                        switch (value.toLowerCase(Locale.ROOT)) {
                            case "east": {
                                materialData.setData((byte)5);
                                break;
                            }
                            case "north": {
                                ((Skull)materialData).setFacingDirection(BlockFace.NORTH);
                                break;
                            }
                            case "south": {
                                ((Skull)materialData).setFacingDirection(BlockFace.SOUTH);
                                break;
                            }
                            case "west": {
                                materialData.setData((byte)4);
                            }
                        }
                    }
                } else if (materialData instanceof Mushroom && materialData.getData() != 10 && materialData.getData() != 15) {
                    switch (key.toLowerCase(Locale.ROOT)) {
                        case "east": {
                            boolean bool = Boolean.parseBoolean(value);
                            boolean isPainted = ((Mushroom)materialData).isFacePainted(BlockFace.EAST);
                            if (bool == isPainted) break;
                            ((Mushroom)materialData).setFacePainted(BlockFace.EAST, bool);
                            break;
                        }
                        case "down": {
                            boolean bool = Boolean.parseBoolean(value);
                            boolean isPainted = ((Mushroom)materialData).isFacePainted(BlockFace.DOWN);
                            if (bool == isPainted) break;
                            ((Mushroom)materialData).setFacePainted(BlockFace.DOWN, bool);
                            break;
                        }
                        case "north": {
                            boolean bool = Boolean.parseBoolean(value);
                            boolean isPainted = ((Mushroom)materialData).isFacePainted(BlockFace.NORTH);
                            if (bool == isPainted) break;
                            ((Mushroom)materialData).setFacePainted(BlockFace.NORTH, bool);
                            break;
                        }
                        case "south": {
                            boolean bool = Boolean.parseBoolean(value);
                            boolean isPainted = ((Mushroom)materialData).isFacePainted(BlockFace.SOUTH);
                            if (bool == isPainted) break;
                            ((Mushroom)materialData).setFacePainted(BlockFace.SOUTH, bool);
                            break;
                        }
                        case "up": {
                            boolean bool = Boolean.parseBoolean(value);
                            boolean isPainted = ((Mushroom)materialData).isFacePainted(BlockFace.UP);
                            if (bool == isPainted) break;
                            ((Mushroom)materialData).setFacePainted(BlockFace.UP, bool);
                            break;
                        }
                        case "west": {
                            boolean bool = Boolean.parseBoolean(value);
                            boolean isPainted = ((Mushroom)materialData).isFacePainted(BlockFace.WEST);
                            if (bool == isPainted) break;
                            ((Mushroom)materialData).setFacePainted(BlockFace.WEST, bool);
                            break;
                        }
                    }
                } else if ("PORTAL".equals(materialName)) {
                    if ("axis".equalsIgnoreCase(key)) {
                        if ("x".equalsIgnoreCase(value)) {
                            materialData.setData((byte)1);
                        } else if ("z".equalsIgnoreCase(value)) {
                            materialData.setData((byte)2);
                        }
                    }
                } else if ("OBSERVER".equals(materialName)) {
                    block415 : switch (key.toLowerCase(Locale.ROOT)) {
                        case "facing": {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "down": {
                                    materialData.setData((byte)(materialData.getData() & 8));
                                    break block415;
                                }
                                case "east": {
                                    materialData.setData((byte)(materialData.getData() & 8 | 5));
                                    break block415;
                                }
                                case "north": {
                                    materialData.setData((byte)(materialData.getData() & 8 | 2));
                                    break block415;
                                }
                                case "south": {
                                    materialData.setData((byte)(materialData.getData() & 8 | 3));
                                    break block415;
                                }
                                case "up": {
                                    materialData.setData((byte)(materialData.getData() & 8 | 1));
                                    break block415;
                                }
                                case "west": {
                                    materialData.setData((byte)(materialData.getData() & 8 | 4));
                                }
                            }
                            break;
                        }
                        case "powered": {
                            boolean bool = Boolean.parseBoolean(value);
                            if (bool) {
                                materialData.setData((byte)(materialData.getData() | 8));
                                break;
                            }
                            materialData.setData((byte)(materialData.getData() & 0xFFFFFFF7));
                        }
                    }
                } else if (materialData instanceof PistonBaseMaterial) {
                    block439 : switch (key.toLowerCase(Locale.ROOT)) {
                        case "extended": {
                            ((PistonBaseMaterial)materialData).setPowered(Boolean.parseBoolean(value));
                            break;
                        }
                        case "facing": {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "down": {
                                    ((PistonBaseMaterial)materialData).setFacingDirection(BlockFace.DOWN);
                                    break block439;
                                }
                                case "east": {
                                    ((PistonBaseMaterial)materialData).setFacingDirection(BlockFace.EAST);
                                    break block439;
                                }
                                case "north": {
                                    ((PistonBaseMaterial)materialData).setFacingDirection(BlockFace.NORTH);
                                    break block439;
                                }
                                case "south": {
                                    ((PistonBaseMaterial)materialData).setFacingDirection(BlockFace.SOUTH);
                                    break block439;
                                }
                                case "up": {
                                    ((PistonBaseMaterial)materialData).setFacingDirection(BlockFace.UP);
                                    break block439;
                                }
                                case "west": {
                                    ((PistonBaseMaterial)materialData).setFacingDirection(BlockFace.WEST);
                                }
                            }
                        }
                    }
                } else if (materialData instanceof PistonExtensionMaterial) {
                    block463 : switch (key.toLowerCase(Locale.ROOT)) {
                        case "type": {
                            if ("normal".equalsIgnoreCase(value)) {
                                ((PistonExtensionMaterial)materialData).setSticky(false);
                                break;
                            }
                            if (!"sticky".equalsIgnoreCase(value)) break;
                            ((PistonExtensionMaterial)materialData).setSticky(true);
                            break;
                        }
                        case "facing": {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "down": {
                                    ((PistonExtensionMaterial)materialData).setFacingDirection(BlockFace.DOWN);
                                    break block463;
                                }
                                case "east": {
                                    ((PistonExtensionMaterial)materialData).setFacingDirection(BlockFace.EAST);
                                    break block463;
                                }
                                case "north": {
                                    ((PistonExtensionMaterial)materialData).setFacingDirection(BlockFace.NORTH);
                                    break block463;
                                }
                                case "south": {
                                    ((PistonExtensionMaterial)materialData).setFacingDirection(BlockFace.SOUTH);
                                    break block463;
                                }
                                case "up": {
                                    ((PistonExtensionMaterial)materialData).setFacingDirection(BlockFace.UP);
                                    break block463;
                                }
                                case "west": {
                                    ((PistonExtensionMaterial)materialData).setFacingDirection(BlockFace.WEST);
                                }
                            }
                        }
                    }
                } else if (materialData instanceof PressurePlate) {
                    if ("powered".equalsIgnoreCase(key)) {
                        materialData.setData((byte)(Boolean.parseBoolean(value) ? 1 : 0));
                    }
                } else if ("IRON_PLATE".equals(materialName) || "GOLD_PLATE".equals(materialName)) {
                    if ("power".equalsIgnoreCase(key)) {
                        byte age = Byte.parseByte(value);
                        if (age < 0 || age > 15) {
                            age = 0;
                        }
                        materialData.setData(age);
                    }
                } else if ("QUARTZ_BLOCK".equals(materialName)) {
                    if (materialData.getData() >= 2 && "axis".equalsIgnoreCase(key)) {
                        switch (value.toLowerCase(Locale.ROOT)) {
                            case "x": {
                                materialData.setData((byte)3);
                                break;
                            }
                            case "y": {
                                materialData.setData((byte)2);
                                break;
                            }
                            case "z": {
                                materialData.setData((byte)4);
                            }
                        }
                    }
                } else if ("PURPUR_PILLAR".equals(materialName) || "BONE_BLOCK".equals(materialName) || "HAY_BLOCK".equals(materialName)) {
                    if ("axis".equalsIgnoreCase(key)) {
                        switch (value.toLowerCase(Locale.ROOT)) {
                            case "x": {
                                materialData.setData((byte)4);
                                break;
                            }
                            case "y": {
                                materialData.setData((byte)0);
                                break;
                            }
                            case "z": {
                                materialData.setData((byte)8);
                            }
                        }
                    }
                } else if (materialData instanceof Rails) {
                    if (materialData instanceof ExtendedRails) {
                        block507 : switch (key.toLowerCase(Locale.ROOT)) {
                            case "powered": {
                                boolean bool = Boolean.parseBoolean(value);
                                if (bool) {
                                    materialData.setData((byte)(materialData.getData() | 8));
                                    break;
                                }
                                materialData.setData((byte)(materialData.getData() & 0xFFFFFFF7));
                                break;
                            }
                            case "shape": {
                                switch (value.toLowerCase(Locale.ROOT)) {
                                    case "east_west": {
                                        ((Rails)materialData).setDirection(BlockFace.EAST, false);
                                        break block507;
                                    }
                                    case "north_south": {
                                        ((Rails)materialData).setDirection(BlockFace.NORTH, false);
                                        break block507;
                                    }
                                    case "ascending_east": {
                                        ((Rails)materialData).setDirection(BlockFace.EAST, true);
                                        break block507;
                                    }
                                    case "ascending_north": {
                                        ((Rails)materialData).setDirection(BlockFace.NORTH, true);
                                        break block507;
                                    }
                                    case "ascending_south": {
                                        ((Rails)materialData).setDirection(BlockFace.SOUTH, true);
                                        break block507;
                                    }
                                    case "ascending_west": {
                                        ((Rails)materialData).setDirection(BlockFace.WEST, true);
                                    }
                                }
                            }
                        }
                    } else if ("shape".equalsIgnoreCase(key)) {
                        switch (value.toLowerCase(Locale.ROOT)) {
                            case "east_west": {
                                ((Rails)materialData).setDirection(BlockFace.EAST, false);
                                break;
                            }
                            case "north_east": {
                                ((Rails)materialData).setDirection(BlockFace.SOUTH_WEST, false);
                                break;
                            }
                            case "north_south": {
                                ((Rails)materialData).setDirection(BlockFace.NORTH, false);
                                break;
                            }
                            case "north_west": {
                                ((Rails)materialData).setDirection(BlockFace.SOUTH_EAST, false);
                                break;
                            }
                            case "south_east": {
                                ((Rails)materialData).setDirection(BlockFace.NORTH_WEST, false);
                                break;
                            }
                            case "south_west": {
                                ((Rails)materialData).setDirection(BlockFace.NORTH_EAST, false);
                                break;
                            }
                            case "ascending_east": {
                                ((Rails)materialData).setDirection(BlockFace.EAST, true);
                                break;
                            }
                            case "ascending_north": {
                                ((Rails)materialData).setDirection(BlockFace.NORTH, true);
                                break;
                            }
                            case "ascending_south": {
                                ((Rails)materialData).setDirection(BlockFace.SOUTH, true);
                                break;
                            }
                            case "ascending_west": {
                                ((Rails)materialData).setDirection(BlockFace.WEST, true);
                            }
                        }
                    }
                } else if ("REDSTONE_COMPARATOR_OFF".equals(materialName) || "REDSTONE_COMPARATOR_ON".equals(materialName)) {
                    block556 : switch (key.toLowerCase(Locale.ROOT)) {
                        case "facing": {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "east": {
                                    materialData.setData((byte)(materialData.getData() & 0xC | 2));
                                    break block556;
                                }
                                case "north": {
                                    materialData.setData((byte)(materialData.getData() & 0xC | 1));
                                    break block556;
                                }
                                case "south": {
                                    materialData.setData((byte)(materialData.getData() & 0xC));
                                    break block556;
                                }
                                case "west": {
                                    materialData.setData((byte)(materialData.getData() & 0xC | 3));
                                }
                            }
                            break;
                        }
                        case "mode": {
                            if ("compare".equalsIgnoreCase(value)) {
                                materialData.setData((byte)(materialData.getData() & 0xFFFFFFFB));
                                break;
                            }
                            if (!"subtract".equalsIgnoreCase(value)) break;
                            materialData.setData((byte)(materialData.getData() | 4));
                            break;
                        }
                        case "powered": {
                            boolean bool = Boolean.parseBoolean(value);
                            if (bool) {
                                materialData.setData((byte)(materialData.getData() | 8));
                                break;
                            }
                            materialData.setData((byte)(materialData.getData() & 0xFFFFFFF7));
                        }
                    }
                } else if (materialData instanceof RedstoneWire) {
                    if ("power".equalsIgnoreCase(key)) {
                        byte power = Byte.parseByte(value);
                        if (power < 0 || power > 15) {
                            power = 0;
                        }
                        materialData.setData(power);
                    }
                } else if ("REDSTONE_LAMP_OFF".equals(materialName) || "REDSTONE_LAMP_ON".equals(materialName)) {
                    if ("lit".equalsIgnoreCase(key)) {
                        boolean bool = Boolean.parseBoolean(value);
                        if (bool && "REDSTONE_LAMP_OFF".equals(materialName)) {
                            materialData = new MaterialData(Material.valueOf((String)"REDSTONE_LAMP_ON"));
                        } else if (!bool && "REDSTONE_LAMP_ON".equals(materialName)) {
                            materialData = new MaterialData(Material.valueOf((String)"REDSTONE_LAMP_OFF"));
                        }
                    }
                } else if ("REDSTONE_ORE".equals(materialName) || "GLOWING_REDSTONE_ORE".equals(materialName)) {
                    if ("lit".equalsIgnoreCase(key)) {
                        boolean bool = Boolean.parseBoolean(value);
                        if (bool && "REDSTONE_ORE".equals(materialName)) {
                            materialData = new MaterialData(Material.valueOf((String)"GLOWING_REDSTONE_ORE"));
                        } else if (!bool && "GLOWING_REDSTONE_ORE".equals(materialName)) {
                            materialData = new MaterialData(Material.valueOf((String)"REDSTONE_ORE"));
                        }
                    }
                } else if (materialData instanceof Diode) {
                    block578 : switch (key.toLowerCase(Locale.ROOT)) {
                        case "delay": {
                            byte delay = Byte.parseByte(value);
                            if (delay < 1 || delay > 4) {
                                delay = 1;
                            }
                            ((Diode)materialData).setDelay((int)delay);
                            break;
                        }
                        case "facing": {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "east": {
                                    ((Diode)materialData).setFacingDirection(BlockFace.EAST);
                                    break block578;
                                }
                                case "north": {
                                    ((Diode)materialData).setFacingDirection(BlockFace.NORTH);
                                    break block578;
                                }
                                case "south": {
                                    ((Diode)materialData).setFacingDirection(BlockFace.SOUTH);
                                    break block578;
                                }
                                case "west": {
                                    ((Diode)materialData).setFacingDirection(BlockFace.WEST);
                                }
                            }
                            break;
                        }
                        case "powered": {
                            boolean bool = Boolean.parseBoolean(value);
                            if (bool && "DIODE_BLOCK_OFF".equals(materialName)) {
                                materialData = new Diode(Material.valueOf((String)"DIODE_BLOCK_ON"), materialData.getData());
                                break;
                            }
                            if (bool || !"DIODE_BLOCK_ON".equals(materialName)) break;
                            materialData = new Diode(Material.valueOf((String)"DIODE_BLOCK_OFF"), materialData.getData());
                        }
                    }
                } else if (materialData instanceof RedstoneTorch) {
                    block599 : switch (key.toLowerCase(Locale.ROOT)) {
                        case "lit": {
                            boolean bool = Boolean.parseBoolean(value);
                            if (bool && "REDSTONE_TORCH_OFF".equals(materialName)) {
                                materialData = new MaterialData(Material.valueOf((String)"REDSTONE_TORCH_ON"), materialData.getData());
                                break;
                            }
                            if (bool || !"REDSTONE_TORCH_ON".equals(materialName)) break;
                            materialData = new MaterialData(Material.valueOf((String)"REDSTONE_TORCH_OFF"), materialData.getData());
                            break;
                        }
                        case "facing": {
                            if (((RedstoneTorch)materialData).getAttachedFace() == BlockFace.DOWN) break;
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "east": {
                                    ((RedstoneTorch)materialData).setFacingDirection(BlockFace.EAST);
                                    break block599;
                                }
                                case "north": {
                                    ((RedstoneTorch)materialData).setFacingDirection(BlockFace.NORTH);
                                    break block599;
                                }
                                case "south": {
                                    ((RedstoneTorch)materialData).setFacingDirection(BlockFace.SOUTH);
                                    break block599;
                                }
                                case "west": {
                                    ((RedstoneTorch)materialData).setFacingDirection(BlockFace.WEST);
                                }
                            }
                        }
                    }
                } else if ("SAPLING".equals(materialName)) {
                    if ("stage".equalsIgnoreCase(key)) {
                        boolean stage;
                        boolean bl = stage = Byte.parseByte(value) == 1;
                        if (stage) {
                            materialData.setData((byte)(materialData.getData() | 8));
                        } else {
                            materialData.setData((byte)(materialData.getData() & 0xFFFFFFF7));
                        }
                    }
                } else if (materialName.endsWith("_SHULKER_BOX")) {
                    if ("facing".equalsIgnoreCase(key)) {
                        switch (value.toLowerCase(Locale.ROOT)) {
                            case "down": {
                                materialData.setData((byte)0);
                                break;
                            }
                            case "up": {
                                materialData.setData((byte)1);
                                break;
                            }
                            case "east": {
                                materialData.setData((byte)5);
                                break;
                            }
                            case "west": {
                                materialData.setData((byte)4);
                                break;
                            }
                            case "north": {
                                materialData.setData((byte)2);
                                break;
                            }
                            case "south": {
                                materialData.setData((byte)3);
                            }
                        }
                    }
                } else if (materialData instanceof Sign) {
                    if (((Sign)materialData).isWallSign()) {
                        if ("facing".equalsIgnoreCase(key)) {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "east": {
                                    ((Sign)materialData).setFacingDirection(BlockFace.EAST);
                                    break;
                                }
                                case "north": {
                                    ((Sign)materialData).setFacingDirection(BlockFace.NORTH);
                                    break;
                                }
                                case "south": {
                                    ((Sign)materialData).setFacingDirection(BlockFace.SOUTH);
                                    break;
                                }
                                case "west": {
                                    ((Sign)materialData).setFacingDirection(BlockFace.WEST);
                                }
                            }
                        }
                    } else if ("rotation".equalsIgnoreCase(key)) {
                        byte rotation = Byte.parseByte(value);
                        if (rotation < 0 || rotation > 15) {
                            rotation = 0;
                        }
                        materialData.setData(rotation);
                    }
                } else if ("STEP".equals(materialName) || "WOOD_STEP".equals(materialName) || "STONE_SLAB2".equals(materialName) || "PURPUR_SLAB".equals(materialName)) {
                    if ("type".equalsIgnoreCase(key)) {
                        block648 : switch (value.toLowerCase(Locale.ROOT)) {
                            case "bottom": {
                                materialData.setData((byte)(materialData.getData() & 0xFFFFFFF7));
                                break;
                            }
                            case "top": {
                                materialData.setData((byte)(materialData.getData() | 8));
                                break;
                            }
                            case "double": {
                                switch (materialName) {
                                    case "STEP": {
                                        materialData = new MaterialData(Material.valueOf((String)"DOUBLE_STEP"), (byte)(materialData.getData() & 7));
                                        break block648;
                                    }
                                    case "WOOD_STEP": {
                                        materialData = new MaterialData(Material.valueOf((String)"WOOD_DOUBLE_STEP"), (byte)(materialData.getData() & 7));
                                        break block648;
                                    }
                                    case "STONE_SLAB2": {
                                        materialData = new MaterialData(Material.valueOf((String)"DOUBLE_STONE_SLAB2"), (byte)(materialData.getData() & 7));
                                        break block648;
                                    }
                                    case "PURPUR_SLAB": {
                                        materialData = new MaterialData(Material.valueOf((String)"PURPUR_DOUBLE_SLAB"), (byte)(materialData.getData() & 7));
                                    }
                                }
                            }
                        }
                    }
                } else if ("DOUBLE_STEP".equals(materialName) || "WOOD_DOUBLE_STEP".equals(materialName) || "DOUBLE_STONE_SLAB2".equals(materialName) || "PURPUR_DOUBLE_SLAB".equals(materialName)) {
                    if ("type".equalsIgnoreCase(key)) {
                        block669 : switch (value.toLowerCase(Locale.ROOT)) {
                            case "bottom": {
                                switch (materialName) {
                                    case "DOUBLE_STEP": {
                                        materialData = new MaterialData(Material.valueOf((String)"STEP"), materialData.getData());
                                        break block669;
                                    }
                                    case "WOOD_DOUBLE_STEP": {
                                        materialData = new MaterialData(Material.valueOf((String)"WOOD_STEP"), materialData.getData());
                                        break block669;
                                    }
                                    case "DOUBLE_STONE_SLAB2": {
                                        materialData = new MaterialData(Material.valueOf((String)"STONE_SLAB2"), materialData.getData());
                                        break block669;
                                    }
                                    case "PURPUR_DOUBLE_SLAB": {
                                        materialData = new MaterialData(Material.valueOf((String)"PURPUR_SLAB"), materialData.getData());
                                    }
                                }
                                break;
                            }
                            case "top": {
                                switch (materialName) {
                                    case "DOUBLE_STEP": {
                                        materialData = new MaterialData(Material.valueOf((String)"STEP"), (byte)(materialData.getData() | 8));
                                        break block669;
                                    }
                                    case "WOOD_DOUBLE_STEP": {
                                        materialData = new MaterialData(Material.valueOf((String)"WOOD_STEP"), (byte)(materialData.getData() | 8));
                                        break block669;
                                    }
                                    case "DOUBLE_STONE_SLAB2": {
                                        materialData = new MaterialData(Material.valueOf((String)"STONE_SLAB2"), (byte)(materialData.getData() | 8));
                                        break block669;
                                    }
                                    case "PURPUR_DOUBLE_SLAB": {
                                        materialData = new MaterialData(Material.valueOf((String)"PURPUR_SLAB"), (byte)(materialData.getData() | 8));
                                    }
                                }
                            }
                        }
                    }
                } else if ("SNOW".equals(materialName)) {
                    if ("layers".equalsIgnoreCase(key)) {
                        byte layer = (byte)(Byte.parseByte(value) - 1);
                        if (layer < 0 || layer > 7) {
                            layer = 0;
                        }
                        materialData.setData(layer);
                    }
                } else if (materialData instanceof Stairs) {
                    block701 : switch (key.toLowerCase(Locale.ROOT)) {
                        case "facing": {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "north": {
                                    ((Stairs)materialData).setFacingDirection(BlockFace.NORTH);
                                    break block701;
                                }
                                case "west": {
                                    ((Stairs)materialData).setFacingDirection(BlockFace.WEST);
                                    break block701;
                                }
                                case "south": {
                                    ((Stairs)materialData).setFacingDirection(BlockFace.SOUTH);
                                    break block701;
                                }
                                case "east": {
                                    ((Stairs)materialData).setFacingDirection(BlockFace.EAST);
                                }
                            }
                            break;
                        }
                        case "half": {
                            if ("bottom".equalsIgnoreCase(value)) {
                                ((Stairs)materialData).setInverted(false);
                                break;
                            }
                            if (!"top".equalsIgnoreCase(value)) break;
                            ((Stairs)materialData).setInverted(true);
                        }
                    }
                } else if ("STRUCTURE_BLOCK".equals(materialName)) {
                    if ("mode".equalsIgnoreCase(key)) {
                        switch (value.toLowerCase(Locale.ROOT)) {
                            case "corner": {
                                materialData.setData((byte)3);
                                break;
                            }
                            case "data": {
                                materialData.setData((byte)0);
                                break;
                            }
                            case "load": {
                                materialData.setData((byte)2);
                                break;
                            }
                            case "save": {
                                materialData.setData((byte)1);
                            }
                        }
                    }
                } else if ("TNT".equals(materialName)) {
                    if ("unstable".equalsIgnoreCase(key)) {
                        boolean bool = Boolean.parseBoolean(value);
                        if (bool) {
                            materialData.setData((byte)1);
                        } else {
                            materialData.setData((byte)0);
                        }
                    }
                } else if (materialData instanceof Torch) {
                    if ("facing".equalsIgnoreCase(key) && ((Torch)materialData).getAttachedFace() != BlockFace.DOWN) {
                        switch (value.toLowerCase(Locale.ROOT)) {
                            case "east": {
                                ((Torch)materialData).setFacingDirection(BlockFace.EAST);
                                break;
                            }
                            case "north": {
                                ((Torch)materialData).setFacingDirection(BlockFace.NORTH);
                                break;
                            }
                            case "south": {
                                ((Torch)materialData).setFacingDirection(BlockFace.SOUTH);
                                break;
                            }
                            case "west": {
                                ((Torch)materialData).setFacingDirection(BlockFace.WEST);
                            }
                        }
                    }
                } else if (materialData instanceof TrapDoor) {
                    block746 : switch (key.toLowerCase(Locale.ROOT)) {
                        case "facing": {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "east": {
                                    ((TrapDoor)materialData).setFacingDirection(BlockFace.EAST);
                                    break block746;
                                }
                                case "north": {
                                    ((TrapDoor)materialData).setFacingDirection(BlockFace.NORTH);
                                    break block746;
                                }
                                case "south": {
                                    ((TrapDoor)materialData).setFacingDirection(BlockFace.SOUTH);
                                    break block746;
                                }
                                case "west": {
                                    ((TrapDoor)materialData).setFacingDirection(BlockFace.WEST);
                                }
                            }
                            break;
                        }
                        case "half": {
                            if ("bottom".equalsIgnoreCase(value)) {
                                ((TrapDoor)materialData).setInverted(false);
                                break;
                            }
                            if (!"top".equalsIgnoreCase(value)) break;
                            ((TrapDoor)materialData).setInverted(true);
                            break;
                        }
                        case "open": {
                            ((TrapDoor)materialData).setOpen(Boolean.parseBoolean(value));
                        }
                    }
                } else if (materialData instanceof Tripwire) {
                    switch (key.toLowerCase(Locale.ROOT)) {
                        case "attached": {
                            ((Tripwire)materialData).setActivated(Boolean.parseBoolean(value));
                            break;
                        }
                        case "disarmed": {
                            boolean bool = Boolean.parseBoolean(value);
                            if (bool) {
                                materialData.setData((byte)(materialData.getData() | 8));
                                break;
                            }
                            materialData.setData((byte)(materialData.getData() & 0xFFFFFFF7));
                            break;
                        }
                        case "powered": {
                            ((Tripwire)materialData).setObjectTriggering(Boolean.parseBoolean(value));
                        }
                    }
                } else if (materialData instanceof TripwireHook) {
                    block778 : switch (key.toLowerCase(Locale.ROOT)) {
                        case "attached": {
                            ((TripwireHook)materialData).setConnected(Boolean.parseBoolean(value));
                            break;
                        }
                        case "facing": {
                            switch (value.toLowerCase(Locale.ROOT)) {
                                case "east": {
                                    ((TripwireHook)materialData).setFacingDirection(BlockFace.EAST);
                                    break block778;
                                }
                                case "north": {
                                    ((TripwireHook)materialData).setFacingDirection(BlockFace.NORTH);
                                    break block778;
                                }
                                case "south": {
                                    ((TripwireHook)materialData).setFacingDirection(BlockFace.SOUTH);
                                    break block778;
                                }
                                case "west": {
                                    ((TripwireHook)materialData).setFacingDirection(BlockFace.WEST);
                                }
                            }
                            break;
                        }
                        case "powered": {
                            ((TripwireHook)materialData).setActivated(Boolean.parseBoolean(value));
                        }
                    }
                } else if (materialData instanceof Vine) {
                    switch (key.toLowerCase(Locale.ROOT)) {
                        case "east": {
                            if (Boolean.parseBoolean(value)) {
                                ((Vine)materialData).putOnFace(BlockFace.EAST);
                                break;
                            }
                            ((Vine)materialData).removeFromFace(BlockFace.EAST);
                            break;
                        }
                        case "north": {
                            if (Boolean.parseBoolean(value)) {
                                ((Vine)materialData).putOnFace(BlockFace.NORTH);
                                break;
                            }
                            ((Vine)materialData).removeFromFace(BlockFace.NORTH);
                            break;
                        }
                        case "south": {
                            if (Boolean.parseBoolean(value)) {
                                ((Vine)materialData).putOnFace(BlockFace.SOUTH);
                                break;
                            }
                            ((Vine)materialData).removeFromFace(BlockFace.SOUTH);
                            break;
                        }
                        case "west": {
                            if (Boolean.parseBoolean(value)) {
                                ((Vine)materialData).putOnFace(BlockFace.WEST);
                                break;
                            }
                            ((Vine)materialData).removeFromFace(BlockFace.WEST);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return materialData;
    }

    @Nullable
    public static String get(@NotNull MaterialData materialData, @NotNull String key) {
        try {
            String materialName = materialData.getItemType().name();
            if ("waterlogged".equalsIgnoreCase(key)) {
                switch (materialName) {
                    case "CHEST": 
                    case "TRAPPED_CHEST": 
                    case "WOOD_STAIRS": 
                    case "COBBLESTONE_STAIRS": 
                    case "BRICK_STAIRS": 
                    case "SMOOTH_STAIRS": 
                    case "SANDSTONE_STAIRS": 
                    case "QUARTZ_STAIRS": 
                    case "ACACIA_STAIRS": 
                    case "DARK_OAK_STAIRS": 
                    case "SPRUCE_WOOD_STAIRS": 
                    case "BIRCH_WOOD_STAIRS": 
                    case "JUNGLE_WOOD_STAIRS": 
                    case "RED_SANDSTONE_STAIRS": 
                    case "PURPUR_STAIRS": 
                    case "NETHER_BRICK_STAIRS": 
                    case "STEP": 
                    case "WOOD_STEP": 
                    case "STONE_SLAB2": 
                    case "PURPUR_SLAB": 
                    case "DOUBLE_STEP": 
                    case "WOOD_DOUBLE_STEP": 
                    case "DOUBLE_STONE_SLAB2": 
                    case "PURPUR_DOUBLE_SLAB": 
                    case "FENCE": 
                    case "IRON_FENCE": 
                    case "NETHER_FENCE": 
                    case "SPRUCE_FENCE": 
                    case "BIRCH_FENCE": 
                    case "JUNGLE_FENCE": 
                    case "DARK_OAK_FENCE": 
                    case "ACACIA_FENCE": 
                    case "COBBLE_WALL": 
                    case "STAINED_GLASS_PANE": 
                    case "THIN_GLASS": 
                    case "ENDER_CHEST": 
                    case "IRON_TRAPDOOR": 
                    case "TRAP_DOOR": 
                    case "LADDER": 
                    case "SIGN_POST": 
                    case "WALL_SIGN": {
                        return "false";
                    }
                }
                return null;
            }
            if ("ANVIL".equals(materialName)) {
                if ("facing".equalsIgnoreCase(key)) {
                    int value = materialData.getData() & 3;
                    switch (value) {
                        case 0: {
                            return "west";
                        }
                        case 1: {
                            return "north";
                        }
                        case 2: {
                            return "east";
                        }
                        case 3: {
                            return "south";
                        }
                    }
                }
            } else if (materialData instanceof Banner) {
                if (((Banner)materialData).isWallBanner()) {
                    if ("facing".equalsIgnoreCase(key)) {
                        return ((Banner)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                    }
                } else if ("rotation".equalsIgnoreCase(key)) {
                    return String.valueOf(materialData.getData());
                }
            } else if (materialData instanceof Bed) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "facing": {
                        return ((Bed)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                    }
                    case "part": {
                        return ((Bed)materialData).isHeadOfBed() ? "head" : "foot";
                    }
                    case "occupied": {
                        return "false";
                    }
                }
            } else if (materialData instanceof Crops || materialData instanceof NetherWarts || "CARROT".equals(materialName) || "POTATO".equals(materialName) || "CACTUS".equals(materialName) || "SUGAR_CANE_BLOCK".equals(materialName) || "CHORUS_FLOWER".equalsIgnoreCase(materialName) || "FROSTED_ICE".equals(materialName) || "MELON_STEM".equals(materialName) || "PUMPKIN_STEM".equals(materialName)) {
                if ("age".equalsIgnoreCase(key)) {
                    return String.valueOf(materialData.getData());
                }
            } else if ("FIRE".equals(materialName)) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "age": {
                        return String.valueOf(materialData.getData());
                    }
                    case "east": 
                    case "north": 
                    case "south": 
                    case "up": 
                    case "west": {
                        return "true";
                    }
                }
            } else if ("BREWING_STAND".equals(materialName)) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "has_bottle_0": {
                        return (materialData.getData() & 1) == 1 ? "true" : "false";
                    }
                    case "has_bottle_1": {
                        return (materialData.getData() & 2) == 2 ? "true" : "false";
                    }
                    case "has_bottle_2": {
                        return (materialData.getData() & 4) == 4 ? "true" : "false";
                    }
                }
            } else if (materialData instanceof Button) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "powered": {
                        return String.valueOf(((Button)materialData).isPowered());
                    }
                    case "facing": {
                        if (((Button)materialData).getFacing() != BlockFace.UP && ((Button)materialData).getFacing() != BlockFace.DOWN) {
                            return ((Button)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                        }
                        return "north";
                    }
                    case "face": {
                        if (((Button)materialData).getFacing() == BlockFace.UP) {
                            return "floor";
                        }
                        if (((Button)materialData).getFacing() == BlockFace.DOWN) {
                            return "ceiling";
                        }
                        return "wall";
                    }
                }
            } else if (materialData instanceof Cake) {
                if ("bites".equalsIgnoreCase(key)) {
                    return String.valueOf(materialData.getData());
                }
            } else if (materialData instanceof Cauldron) {
                if ("level".equalsIgnoreCase(key)) {
                    return String.valueOf(materialData.getData());
                }
            } else if (materialData instanceof DirectionalContainer) {
                if (materialData instanceof Chest || materialData instanceof EnderChest) {
                    switch (key.toLowerCase(Locale.ROOT)) {
                        case "facing": {
                            return ((DirectionalContainer)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                        }
                        case "type": {
                            return "single";
                        }
                    }
                } else if (materialData instanceof Dispenser) {
                    switch (key.toLowerCase(Locale.ROOT)) {
                        case "facing": {
                            return ((Dispenser)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                        }
                        case "triggered": {
                            return (materialData.getData() & 8) == 8 ? "true" : "false";
                        }
                    }
                } else if (materialData instanceof Furnace) {
                    switch (key.toLowerCase(Locale.ROOT)) {
                        case "facing": {
                            return ((Furnace)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                        }
                        case "lit": {
                            return "BURNING_FURNACE".equals(materialName) ? "true" : "false";
                        }
                    }
                }
            } else if (materialData instanceof CocoaPlant) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "age": {
                        return String.valueOf(((CocoaPlant)materialData).getSize().ordinal());
                    }
                    case "facing": {
                        return ((CocoaPlant)materialData).getAttachedFace().name().toLowerCase(Locale.ROOT);
                    }
                }
            } else if (materialData instanceof Command) {
                if (BukkitFeature.COMMAND_BLOCK_VERBOSE_BLOCK_STATE.isSupported()) {
                    switch (key.toLowerCase(Locale.ROOT)) {
                        case "conditional": {
                            return (materialData.getData() & 8) == 8 ? "true" : "false";
                        }
                        case "facing": {
                            switch (materialData.getData() & 7) {
                                default: {
                                    return "down";
                                }
                                case 1: {
                                    return "up";
                                }
                                case 2: {
                                    return "north";
                                }
                                case 3: {
                                    return "south";
                                }
                                case 4: {
                                    return "west";
                                }
                                case 5: 
                            }
                            return "east";
                        }
                    }
                } else {
                    switch (key.toLowerCase(Locale.ROOT)) {
                        case "conditional": {
                            return "false";
                        }
                        case "facing": {
                            return "north";
                        }
                    }
                }
            } else if ("DAYLIGHT_DETECTOR".equals(materialName) || "DAYLIGHT_DETECTOR_INVERTED".equals(materialName)) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "inverted": {
                        return "DAYLIGHT_DETECTOR_INVERTED".equals(materialName) ? "true" : "false";
                    }
                    case "power": {
                        return String.valueOf(materialData.getData());
                    }
                }
            } else if (materialData instanceof Door) {
                if (((Door)materialData).isTopHalf()) {
                    switch (key.toLowerCase(Locale.ROOT)) {
                        case "half": {
                            return "upper";
                        }
                        case "powered": {
                            return (materialData.getData() & 2) == 2 ? "true" : "false";
                        }
                        case "hinge": {
                            return ((Door)materialData).getHinge() ? "right" : "left";
                        }
                        case "facing": {
                            return "north";
                        }
                        case "open": {
                            return "false";
                        }
                    }
                } else {
                    switch (key.toLowerCase(Locale.ROOT)) {
                        case "half": {
                            return "lower";
                        }
                        case "open": {
                            return ((Door)materialData).isOpen() ? "true" : "false";
                        }
                        case "facing": {
                            return ((Door)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                        }
                        case "hinge": {
                            return "left";
                        }
                        case "powered": {
                            return "false";
                        }
                    }
                }
            } else if ("ENDER_PORTAL_FRAME".equals(materialName)) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "eye": {
                        return (materialData.getData() & 4) == 4 ? "true" : "false";
                    }
                    case "facing": {
                        switch (materialData.getData() & 3) {
                            default: {
                                return "south";
                            }
                            case 1: {
                                return "west";
                            }
                            case 2: {
                                return "north";
                            }
                            case 3: 
                        }
                        return "east";
                    }
                }
            } else if ("END_ROD".equals(materialName)) {
                if ("facing".equalsIgnoreCase(key)) {
                    switch (materialData.getData()) {
                        default: {
                            return "down";
                        }
                        case 1: {
                            return "up";
                        }
                        case 2: {
                            return "north";
                        }
                        case 3: {
                            return "south";
                        }
                        case 4: {
                            return "west";
                        }
                        case 5: 
                    }
                    return "east";
                }
            } else if ("SOIL".equals(materialName)) {
                if ("moisture".equalsIgnoreCase(key)) {
                    return String.valueOf(materialData.getData());
                }
            } else if (materialData instanceof Gate) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "facing": {
                        switch (materialData.getData() & 3) {
                            default: {
                                return "south";
                            }
                            case 1: {
                                return "west";
                            }
                            case 2: {
                                return "north";
                            }
                            case 3: 
                        }
                        return "east";
                    }
                    case "open": {
                        return ((Gate)materialData).isOpen() ? "true" : "false";
                    }
                    case "in_wall": {
                        return "false";
                    }
                    case "powered": {
                        return "false";
                    }
                }
            } else if ("DOUBLE_PLANT".equals(materialName)) {
                if ("half".equalsIgnoreCase(key)) {
                    return (materialData.getData() & 8) == 8 ? "upper" : "lower";
                }
            } else if (materialName.endsWith("GLAZED_TERRACOTTA")) {
                if ("facing".equalsIgnoreCase(key)) {
                    switch (materialData.getData()) {
                        default: {
                            return "south";
                        }
                        case 1: {
                            return "west";
                        }
                        case 2: {
                            return "north";
                        }
                        case 3: 
                    }
                    return "east";
                }
            } else if ("HOPPER".equalsIgnoreCase(materialName)) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "enabled": {
                        return (materialData.getData() & 8) == 8 ? "true" : "false";
                    }
                    case "facing": {
                        switch (materialData.getData() & 7) {
                            default: {
                                return "down";
                            }
                            case 2: {
                                return "north";
                            }
                            case 3: {
                                return "south";
                            }
                            case 4: {
                                return "west";
                            }
                            case 5: 
                        }
                        return "east";
                    }
                }
            } else if (materialData instanceof Pumpkin) {
                if ("facing".equalsIgnoreCase(key)) {
                    if (materialData.getData() == 3) {
                        return "west";
                    }
                    return ((Pumpkin)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                }
            } else if ("JUKEBOX".equals(materialName)) {
                if ("has_record".equalsIgnoreCase(key)) {
                    return materialData.getData() == 1 ? "true" : "false";
                }
            } else if (materialData instanceof Ladder) {
                if ("facing".equalsIgnoreCase(key)) {
                    return ((Ladder)materialData).getAttachedFace().name().toLowerCase(Locale.ROOT);
                }
            } else if ("WATER".equals(materialName) || "STATIONARY_WATER".equals(materialName) || "LAVA".equals(materialName) || "STATIONARY_LAVA".equals(materialName)) {
                if ("level".equalsIgnoreCase(key)) {
                    return String.valueOf(materialData.getData());
                }
            } else if ("LEAVES".equals(materialName) || "LEAVES_2".equals(materialName)) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "persistent": {
                        return (materialData.getData() & 4) == 4 ? "true" : "false";
                    }
                    case "distance": {
                        return (materialData.getData() & 4) == 4 ? "1" : "6";
                    }
                }
            } else if (materialData instanceof Lever) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "face": {
                        switch (((Lever)materialData).getAttachedFace()) {
                            case UP: {
                                return "ceiling";
                            }
                            case DOWN: {
                                return "floor";
                            }
                        }
                        return "wall";
                    }
                    case "facing": {
                        switch (((Lever)materialData).getAttachedFace()) {
                            case UP: {
                                return (materialData.getData() & 7) == 5 ? "east" : "south";
                            }
                            case DOWN: {
                                return (materialData.getData() & 7) == 0 ? "east" : "south";
                            }
                        }
                        return ((Lever)materialData).getAttachedFace().name().toLowerCase(Locale.ROOT);
                    }
                    case "powered": {
                        return ((Lever)materialData).isPowered() ? "true" : "false";
                    }
                }
            } else if (materialData instanceof Tree) {
                if ("axis".equalsIgnoreCase(key)) {
                    if (((Tree)materialData).getDirection() != BlockFace.SELF) {
                        switch (((Tree)materialData).getDirection()) {
                            case WEST: {
                                return "x";
                            }
                            default: {
                                return "y";
                            }
                            case NORTH: 
                        }
                        return "z";
                    }
                    return "y";
                }
            } else if (materialData instanceof Skull) {
                if (((Skull)materialData).getFacing() != BlockFace.SELF && "facing".equalsIgnoreCase(key)) {
                    switch (materialData.getData()) {
                        default: {
                            return "north";
                        }
                        case 3: {
                            return "south";
                        }
                        case 4: {
                            return "west";
                        }
                        case 5: 
                    }
                    return "east";
                }
            } else if (materialData instanceof Mushroom) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "east": {
                        return ((Mushroom)materialData).isFacePainted(BlockFace.EAST) ? "true" : "false";
                    }
                    case "down": {
                        return ((Mushroom)materialData).isFacePainted(BlockFace.DOWN) ? "true" : "false";
                    }
                    case "north": {
                        return ((Mushroom)materialData).isFacePainted(BlockFace.NORTH) ? "true" : "false";
                    }
                    case "south": {
                        return ((Mushroom)materialData).isFacePainted(BlockFace.SOUTH) ? "true" : "false";
                    }
                    case "up": {
                        return ((Mushroom)materialData).isFacePainted(BlockFace.UP) ? "true" : "false";
                    }
                    case "west": {
                        return ((Mushroom)materialData).isFacePainted(BlockFace.WEST) ? "true" : "false";
                    }
                }
            } else if ("PORTAL".equals(materialName)) {
                if ("axis".equalsIgnoreCase(key)) {
                    return materialData.getData() == 1 ? "x" : "z";
                }
            } else if ("OBSERVER".equals(materialName)) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "facing": {
                        switch (materialData.getData() & 7) {
                            default: {
                                return "down";
                            }
                            case 1: {
                                return "up";
                            }
                            case 2: {
                                return "north";
                            }
                            case 3: {
                                return "south";
                            }
                            case 4: {
                                return "west";
                            }
                            case 5: 
                        }
                        return "east";
                    }
                    case "powered": {
                        return (materialData.getData() & 8) == 8 ? "true" : "false";
                    }
                }
            } else if (materialData instanceof PistonBaseMaterial) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "extended": {
                        return ((PistonBaseMaterial)materialData).isPowered() ? "true" : "false";
                    }
                    case "facing": {
                        return ((PistonBaseMaterial)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                    }
                }
            } else if (materialData instanceof PistonExtensionMaterial) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "type": {
                        return ((PistonExtensionMaterial)materialData).isSticky() ? "sticky" : "normal";
                    }
                    case "facing": {
                        return ((PistonExtensionMaterial)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                    }
                    case "short": {
                        return "false";
                    }
                }
            } else if (materialData instanceof PressurePlate) {
                if ("powered".equalsIgnoreCase(key)) {
                    return materialData.getData() == 1 ? "true" : "false";
                }
            } else if ("IRON_PLATE".equals(materialName) || "GOLD_PLATE".equals(materialName)) {
                if ("power".equalsIgnoreCase(key)) {
                    return String.valueOf(materialData.getData());
                }
            } else if ("QUARTZ_BLOCK".equals(materialName)) {
                if (materialData.getData() >= 2 && "axis".equalsIgnoreCase(key)) {
                    switch (materialData.getData()) {
                        case 3: {
                            return "x";
                        }
                        case 2: {
                            return "y";
                        }
                        case 4: {
                            return "z";
                        }
                    }
                }
            } else if ("PURPUR_PILLAR".equals(materialName) || "BONE_BLOCK".equals(materialName) || "HAY_BLOCK".equals(materialName)) {
                if ("axis".equalsIgnoreCase(key)) {
                    switch (materialData.getData()) {
                        case 4: {
                            return "x";
                        }
                        case 0: {
                            return "y";
                        }
                        case 8: {
                            return "z";
                        }
                    }
                }
            } else if (materialData instanceof Rails) {
                if (materialData instanceof ExtendedRails) {
                    switch (key.toLowerCase(Locale.ROOT)) {
                        case "powered": {
                            return (materialData.getData() & 8) == 8 ? "true" : "false";
                        }
                        case "shape": {
                            if (((ExtendedRails)materialData).isOnSlope()) {
                                switch (((ExtendedRails)materialData).getDirection()) {
                                    default: {
                                        return "ascending_north";
                                    }
                                    case EAST: {
                                        return "ascending_east";
                                    }
                                    case SOUTH: {
                                        return "ascending_south";
                                    }
                                    case WEST: 
                                }
                                return "ascending_west";
                            }
                            switch (((ExtendedRails)materialData).getDirection()) {
                                default: {
                                    return "north_south";
                                }
                                case EAST: 
                            }
                            return "north_east";
                        }
                    }
                } else if ("shape".equalsIgnoreCase(key)) {
                    if (((Rails)materialData).isOnSlope()) {
                        switch (((Rails)materialData).getDirection()) {
                            default: {
                                return "ascending_north";
                            }
                            case EAST: {
                                return "ascending_east";
                            }
                            case SOUTH: {
                                return "ascending_south";
                            }
                            case WEST: 
                        }
                        return "ascending_west";
                    }
                    switch (((Rails)materialData).getDirection()) {
                        default: {
                            return "north_south";
                        }
                        case EAST: {
                            return "north_east";
                        }
                        case NORTH_EAST: {
                            return "south_west";
                        }
                        case NORTH_WEST: {
                            return "south_east";
                        }
                        case SOUTH_EAST: {
                            return "north_west";
                        }
                        case SOUTH_WEST: 
                    }
                    return "north_east";
                }
            } else if ("REDSTONE_COMPARATOR_OFF".equals(materialName) || "REDSTONE_COMPARATOR_ON".equals(materialName)) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "facing": {
                        switch (materialData.getData() & 3) {
                            default: {
                                return "south";
                            }
                            case 1: {
                                return "north";
                            }
                            case 2: {
                                return "east";
                            }
                            case 3: 
                        }
                        return "west";
                    }
                    case "mode": {
                        return (materialData.getData() & 4) == 4 ? "subtract" : "compare";
                    }
                    case "powered": {
                        return (materialData.getData() & 8) == 8 ? "true" : "false";
                    }
                }
            } else if (materialData instanceof RedstoneWire) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "power": {
                        return String.valueOf(materialData.getData());
                    }
                    case "east": 
                    case "north": 
                    case "south": 
                    case "west": {
                        return "side";
                    }
                }
            } else if ("REDSTONE_LAMP_OFF".equals(materialName) || "REDSTONE_ORE".equals(materialName)) {
                if ("lit".equalsIgnoreCase(key)) {
                    return "false";
                }
            } else if ("REDSTONE_LAMP_ON".equals(materialName) || "GLOWING_REDSTONE_ORE".equals(materialName)) {
                if ("lit".equalsIgnoreCase(key)) {
                    return "true";
                }
            } else if (materialData instanceof Diode) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "delay": {
                        return String.valueOf(((Diode)materialData).getDelay());
                    }
                    case "facing": {
                        return ((Diode)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                    }
                    case "powered": {
                        return "DIODE_BLOCK_ON".equals(materialName) ? "true" : "false";
                    }
                    case "locked": {
                        return "false";
                    }
                }
            } else if (materialData instanceof RedstoneTorch) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "lit": {
                        return "REDSTONE_TORCH_ON".equals(materialName) ? "true" : "false";
                    }
                    case "facing": {
                        if (((RedstoneTorch)materialData).getAttachedFace() == BlockFace.DOWN) break;
                        return ((RedstoneTorch)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                    }
                }
            } else if ("SAPLING".equals(materialName)) {
                if ("stage".equalsIgnoreCase(key)) {
                    return (materialData.getData() & 8) == 8 ? "true" : "false";
                }
            } else if (materialName.endsWith("_SHULKER_BOX")) {
                if ("facing".equalsIgnoreCase(key)) {
                    switch (materialData.getData()) {
                        default: {
                            return "down";
                        }
                        case 1: {
                            return "up";
                        }
                        case 2: {
                            return "north";
                        }
                        case 3: {
                            return "south";
                        }
                        case 4: {
                            return "west";
                        }
                        case 5: 
                    }
                    return "east";
                }
            } else if (materialData instanceof Sign) {
                if (((Sign)materialData).isWallSign()) {
                    if ("facing".equalsIgnoreCase(key)) {
                        return ((Sign)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                    }
                } else if ("rotation".equalsIgnoreCase(key)) {
                    return String.valueOf(materialData.getData());
                }
            } else if ("STEP".equals(materialName) || "WOOD_STEP".equals(materialName) || "STONE_SLAB2".equals(materialName) || "PURPUR_SLAB".equals(materialName)) {
                if ("type".equalsIgnoreCase(key)) {
                    return (materialData.getData() & 8) == 8 ? "top" : "bottom";
                }
            } else if ("DOUBLE_STEP".equals(materialName) || "WOOD_DOUBLE_STEP".equals(materialName) || "DOUBLE_STONE_SLAB2".equals(materialName) || "PURPUR_DOUBLE_SLAB".equals(materialName)) {
                if ("type".equalsIgnoreCase(key)) {
                    return "double";
                }
            } else if ("SNOW".equals(materialName)) {
                if ("layers".equalsIgnoreCase(key)) {
                    return String.valueOf(materialData.getData());
                }
            } else if (materialData instanceof Stairs) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "facing": {
                        return ((Stairs)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                    }
                    case "half": {
                        return ((Stairs)materialData).isInverted() ? "top" : "bottom";
                    }
                    case "shape": {
                        return "straight";
                    }
                }
            } else if ("STRUCTURE_BLOCK".equals(materialName)) {
                if ("mode".equalsIgnoreCase(key)) {
                    switch (materialData.getData()) {
                        default: {
                            return "data";
                        }
                        case 1: {
                            return "save";
                        }
                        case 2: {
                            return "load";
                        }
                        case 3: 
                    }
                    return "corner";
                }
            } else if ("TNT".equals(materialName)) {
                if ("unstable".equalsIgnoreCase(key)) {
                    return materialData.getData() == 1 ? "true" : "false";
                }
            } else if (materialData instanceof Torch) {
                if ("facing".equalsIgnoreCase(key) && ((Torch)materialData).getAttachedFace() != BlockFace.DOWN) {
                    return ((Torch)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                }
            } else if (materialData instanceof TrapDoor) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "facing": {
                        return ((TrapDoor)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                    }
                    case "half": {
                        return ((TrapDoor)materialData).isInverted() ? "top" : "bottom";
                    }
                    case "open": {
                        return ((TrapDoor)materialData).isOpen() ? "true" : "false";
                    }
                    case "powered": {
                        return "false";
                    }
                }
            } else if (materialData instanceof Tripwire) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "attached": {
                        return ((Tripwire)materialData).isActivated() ? "true" : "false";
                    }
                    case "disarmed": {
                        return (materialData.getData() & 8) == 8 ? "true" : "false";
                    }
                    case "powered": {
                        return ((Tripwire)materialData).isObjectTriggering() ? "true" : "false";
                    }
                    case "east": 
                    case "north": 
                    case "south": 
                    case "west": {
                        return "true";
                    }
                }
            } else if (materialData instanceof TripwireHook) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "attached": {
                        return ((TripwireHook)materialData).isConnected() ? "true" : "false";
                    }
                    case "facing": {
                        return ((TripwireHook)materialData).getFacing().name().toLowerCase(Locale.ROOT);
                    }
                    case "powered": {
                        return ((TripwireHook)materialData).isActivated() ? "true" : "false";
                    }
                }
            } else if (materialData instanceof Vine) {
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "east": {
                        return ((Vine)materialData).isOnFace(BlockFace.EAST) ? "true" : "false";
                    }
                    case "north": {
                        return ((Vine)materialData).isOnFace(BlockFace.NORTH) ? "true" : "false";
                    }
                    case "south": {
                        return ((Vine)materialData).isOnFace(BlockFace.SOUTH) ? "true" : "false";
                    }
                    case "west": {
                        return ((Vine)materialData).isOnFace(BlockFace.WEST) ? "true" : "false";
                    }
                    case "up": {
                        return "true";
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    @NotNull
    public static @NotNull Map<@NotNull String, String> get(@NotNull MaterialData materialData) {
        List<String> possibleKeys = List.of("waterlogged", "facing", "rotation", "part", "occupied", "age", "east", "north", "south", "up", "west", "down", "has_bottle_0", "has_bottle_1", "has_bottle_2", "powered", "face", "bites", "level", "type", "triggered", "lit", "conditional", "inverted", "power", "half", "hinge", "open", "eye", "moisture", "in_wall", "enabled", "has_record", "persistent", "distance", "axis", "extended", "short", "shape", "mode", "delay", "locked", "stage", "layers", "unstable", "attached", "disarmed");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String possible : possibleKeys) {
            String resolve = LegacyMaterialDataToFlatteningConverter.get(materialData, possible);
            if (resolve == null) continue;
            map.put(possible, resolve);
        }
        return Map.copyOf(map);
    }

    @Generated
    private LegacyMaterialDataToFlatteningConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

