/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.compat.v1_21_1;

import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Sound;
import org.jetbrains.annotations.NotNull;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.utils.Version;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.u.reflect.Reflect;

public final class SoundCompat {
    public static void fillSoundCache(@NotNull @NotNull Map<@NotNull String, String> soundCache) {
        if (BukkitFeature.SOUND_KEYED.isSupported()) {
            for (Sound v : Sound.values()) {
                if (!"minecraft".equals(v.getKey().getNamespace())) continue;
                soundCache.put(v.name(), v.getKey().getKey());
            }
        } else {
            boolean is1_9 = Version.isVersion(1, 9);
            for (Sound v : Sound.values()) {
                Object craftSound = Reflect.getMethod(ClassStorage.CB.CraftSound, "getSound", Sound.class).invokeStatic(v);
                soundCache.put(v.name(), craftSound.toString());
                if (is1_9) continue;
                soundCache.put(craftSound.toString().replace('.', '_').toUpperCase(Locale.ROOT), craftSound.toString());
            }
        }
    }

    @Generated
    private SoundCompat() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

