/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.entity;

import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.jetbrains.annotations.NotNull;
import sba.sl.e.ItemEntity;
import sba.sl.i.ItemStack;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.entity.BukkitEntity;
import sba.sl.impl.bukkit.item.BukkitItem;

public class BukkitItemEntity
extends BukkitEntity
implements ItemEntity {
    public BukkitItemEntity(@NotNull Item wrappedObject) {
        super((Entity)wrappedObject);
    }

    @Override
    @NotNull
    public ItemStack getItem() {
        return new BukkitItem(this.getWrappedObject().getItemStack());
    }

    @Override
    public void setItem(@NotNull ItemStack stack) {
        this.getWrappedObject().setItemStack(stack.as(org.bukkit.inventory.ItemStack.class));
    }

    @Override
    public int getPickupDelay() {
        return this.getWrappedObject().getPickupDelay();
    }

    @Override
    public void setPickupDelay(int delay, @NotNull TimeUnit timeUnit) {
        switch (timeUnit) {
            case SECONDS: {
                this.getWrappedObject().setPickupDelay(delay * 20);
                break;
            }
            case MINUTES: {
                this.getWrappedObject().setPickupDelay(delay * 1200);
                break;
            }
            case HOURS: {
                this.getWrappedObject().setPickupDelay(delay * 72000);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported TimeUnit " + timeUnit.name() + "!");
            }
        }
    }

    @Override
    public boolean isPickable() {
        if (BukkitFeature.ITEM_CAN_PLAYER_PICKUP.isSupported()) {
            return this.getWrappedObject().canPlayerPickup();
        }
        return true;
    }

    @Override
    public void setPickable(boolean pickable) {
        if (BukkitFeature.ITEM_CAN_PLAYER_PICKUP.isSupported()) {
            this.getWrappedObject().setCanPlayerPickup(pickable);
        }
    }

    @Override
    public boolean isMergeable() {
        return true;
    }

    @Override
    public void setMergeable(boolean mergeable) {
    }

    @Override
    public float getMergeRange() {
        return 0.0f;
    }

    @Override
    public void setMergeRange(float mergeRange) {
    }

    @Override
    public long getSpawnTime() {
        return this.getWrappedObject().getTicksLived();
    }

    public @NotNull Item getWrappedObject() {
        return (Item)this.wrappedObject;
    }
}

