/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.entity.projectile;

import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.BlockPlacement;
import sba.sl.e.Entities;
import sba.sl.e.projectile.BlockProjectileShooter;
import sba.sl.e.projectile.ProjectileEntity;
import sba.sl.e.type.EntityType;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.u.BasicWrapper;
import sba.sl.u.math.Vector3D;

public class BukkitBlockProjectileSource
extends BasicWrapper<BlockProjectileSource>
implements BlockProjectileShooter {
    public BukkitBlockProjectileSource(@NotNull BlockProjectileSource wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @Nullable
    public ProjectileEntity launchProjectile(@NotNull EntityType projectileType) {
        Class projectileBukkit = projectileType.as(org.bukkit.entity.EntityType.class).getEntityClass();
        if (!Projectile.class.isAssignableFrom(projectileBukkit)) {
            return null;
        }
        return Entities.wrapEntityProjectile(((BlockProjectileSource)this.wrappedObject).launchProjectile(projectileBukkit));
    }

    @Override
    @Nullable
    public ProjectileEntity launchProjectile(@NotNull EntityType projectileType, @NotNull Vector3D velocity) {
        Class projectileBukkit = projectileType.as(org.bukkit.entity.EntityType.class).getEntityClass();
        if (!Projectile.class.isAssignableFrom(projectileBukkit)) {
            return null;
        }
        return Entities.wrapEntityProjectile(((BlockProjectileSource)this.wrappedObject).launchProjectile(projectileBukkit, new Vector(velocity.getX(), velocity.getY(), velocity.getZ())));
    }

    @Override
    @NotNull
    public BlockPlacement getBlock() {
        return new BukkitBlockPlacement(((BlockProjectileSource)this.wrappedObject).getBlock());
    }
}

