/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.block;

import lombok.Generated;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.BlockPlacement;
import sba.sl.e.Entities;
import sba.sl.e.LivingEntity;
import sba.sl.i.ItemStack;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.impl.bukkit.item.BukkitItem;
import sba.sl.u.math.Vector3D;

public class BukkitBlockDispenseEvent
implements sba.sl.ev.block.BlockDispenseEvent,
BukkitCancellable {
    @NotNull
    private final BlockDispenseEvent event;
    @Nullable
    private BlockPlacement block;
    @Nullable
    private LivingEntity receiver;
    private boolean receiverCached;

    @Override
    @NotNull
    public BlockPlacement block() {
        if (this.block == null) {
            this.block = new BukkitBlockPlacement(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    @NotNull
    public ItemStack item() {
        return new BukkitItem(this.event.getItem());
    }

    @Override
    public void item(@NotNull ItemStack item) {
        this.event.setItem(item.as(org.bukkit.inventory.ItemStack.class));
    }

    @Override
    @NotNull
    public Vector3D velocity() {
        return new Vector3D(this.event.getVelocity().getX(), this.event.getVelocity().getY(), this.event.getVelocity().getZ());
    }

    @Override
    public void velocity(@NotNull Vector3D velocity) {
        this.event.setVelocity(new Vector(velocity.getX(), velocity.getY(), velocity.getZ()));
    }

    @Override
    @Nullable
    public LivingEntity receiver() {
        if (!this.receiverCached) {
            if (this.event instanceof BlockDispenseArmorEvent) {
                this.receiver = Entities.wrapEntityLiving(((BlockDispenseArmorEvent)this.event).getTargetEntity());
            }
            this.receiverCached = true;
        }
        return this.receiver;
    }

    @Generated
    public BukkitBlockDispenseEvent(@NotNull BlockDispenseEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitBlockDispenseEvent)) {
            return false;
        }
        BukkitBlockDispenseEvent other = (BukkitBlockDispenseEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockDispenseEvent this$event = this.event();
        BlockDispenseEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitBlockDispenseEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockDispenseEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitBlockDispenseEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public BlockDispenseEvent event() {
        return this.event;
    }
}

