/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.entity;

import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.block.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.snapshot.BlockSnapshot;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.ev.entity.EntityCreatePortalEvent;
import sba.sl.impl.block.snapshot.BlockSnapshots;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.impl.utils.collections.CollectionLinkedToCollection;
import sba.sl.u.PortalType;

public class BukkitEntityCreatePortalEvent
implements EntityCreatePortalEvent,
BukkitCancellable {
    @NotNull
    private final org.bukkit.event.entity.EntityCreatePortalEvent event;
    @Nullable
    private Entity entity;
    private @Nullable Collection<@NotNull BlockSnapshot> blocks;
    @Nullable
    private PortalType portalType;

    @Override
    @NotNull
    public Entity entity() {
        if (this.entity == null) {
            this.entity = Objects.requireNonNull(Entities.wrapEntity(this.event.getEntity()));
        }
        return this.entity;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull BlockSnapshot> blocks() {
        if (this.blocks == null) {
            this.blocks = new CollectionLinkedToCollection<BlockSnapshot, BlockState>(this.event.getBlocks(), blockStateHolder -> blockStateHolder.as(BlockState.class), blockState -> (BlockSnapshot)Objects.requireNonNull(BlockSnapshots.wrapBlockSnapshot(blockState)));
        }
        return this.blocks;
    }

    @Override
    @NotNull
    public PortalType portalType() {
        if (this.portalType == null) {
            this.portalType = PortalType.valueOf(this.event.getPortalType().name().toUpperCase(Locale.ROOT));
        }
        return this.portalType;
    }

    @Generated
    public BukkitEntityCreatePortalEvent(@NotNull org.bukkit.event.entity.EntityCreatePortalEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitEntityCreatePortalEvent)) {
            return false;
        }
        BukkitEntityCreatePortalEvent other = (BukkitEntityCreatePortalEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        org.bukkit.event.entity.EntityCreatePortalEvent this$event = this.event();
        org.bukkit.event.entity.EntityCreatePortalEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitEntityCreatePortalEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        org.bukkit.event.entity.EntityCreatePortalEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitEntityCreatePortalEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public org.bukkit.event.entity.EntityCreatePortalEvent event() {
        return this.event;
    }
}

