/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.player;

import lombok.Generated;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.BlockPlacement;
import sba.sl.ev.Event;
import sba.sl.ev.player.PlayerInteractEvent;
import sba.sl.i.ItemStackView;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.item.BukkitItemView;
import sba.sl.pa.Player;
import sba.sl.sl.EquipmentSlot;
import sba.sl.u.BlockFace;

public class BukkitPlayerInteractEvent
implements PlayerInteractEvent {
    @NotNull
    private final org.bukkit.event.player.PlayerInteractEvent event;
    @Nullable
    private Player player;
    @Nullable
    private ItemStackView item;
    private boolean itemCached;
    @Nullable
    private PlayerInteractEvent.Action action;
    @Nullable
    private BlockFace blockFace;
    @Nullable
    private BlockPlacement clickedBlock;
    private boolean clickedBlockCached;
    @Nullable
    private EquipmentSlot hand;
    private boolean handCached;

    @Override
    @NotNull
    public Player player() {
        if (this.player == null) {
            this.player = new BukkitPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    @Nullable
    public ItemStackView item() {
        if (!this.itemCached) {
            if (this.event.getItem() != null) {
                this.item = new BukkitItemView(this.event.getItem());
            }
            this.itemCached = true;
        }
        return this.item;
    }

    @Override
    @NotNull
    public PlayerInteractEvent.Action action() {
        if (this.action == null) {
            this.action = PlayerInteractEvent.Action.convert(this.event.getAction().name());
        }
        return this.action;
    }

    @Override
    @Nullable
    public BlockPlacement clickedBlock() {
        if (!this.clickedBlockCached) {
            if (this.event.getClickedBlock() != null) {
                this.clickedBlock = new BukkitBlockPlacement(this.event.getClickedBlock());
            }
            this.clickedBlockCached = true;
        }
        return this.clickedBlock;
    }

    @Override
    @NotNull
    public BlockFace blockFace() {
        if (this.blockFace == null) {
            this.blockFace = BlockFace.valueOf(this.event.getBlockFace().name());
        }
        return this.blockFace;
    }

    @Override
    @NotNull
    public Event.Result useClickedBlock() {
        return Event.Result.convert(this.event.useInteractedBlock().name());
    }

    @Override
    public void useClickedBlock(@NotNull Event.Result useClickedBlock) {
        this.event.setUseInteractedBlock(Event.Result.valueOf((String)useClickedBlock.name()));
    }

    @Override
    @NotNull
    public Event.Result useItemInHand() {
        return Event.Result.convert(this.event.useItemInHand().name());
    }

    @Override
    public void useItemInHand(@NotNull Event.Result useItemInHand) {
        this.event.setUseItemInHand(Event.Result.valueOf((String)useItemInHand.name()));
    }

    @Override
    @Nullable
    public EquipmentSlot hand() {
        if (!this.handCached) {
            if (BukkitFeature.OFF_HAND.isSupported()) {
                if (this.event.getHand() != null) {
                    this.hand = EquipmentSlot.of(this.event.getHand());
                }
                this.handCached = true;
            } else {
                this.hand = this.event.getAction() == Action.PHYSICAL ? null : EquipmentSlot.of("main_hand");
                this.handCached = true;
            }
        }
        return this.hand;
    }

    @Generated
    public BukkitPlayerInteractEvent(@NotNull org.bukkit.event.player.PlayerInteractEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitPlayerInteractEvent)) {
            return false;
        }
        BukkitPlayerInteractEvent other = (BukkitPlayerInteractEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        org.bukkit.event.player.PlayerInteractEvent this$event = this.event();
        org.bukkit.event.player.PlayerInteractEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitPlayerInteractEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        org.bukkit.event.player.PlayerInteractEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitPlayerInteractEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public org.bukkit.event.player.PlayerInteractEvent event() {
        return this.event;
    }
}

