/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.packet;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.exception.CancelEncoderException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.packet.CraftBukkitPacketWriter;
import sba.sl.impl.bukkit.packet.listener.ServerboundInteractPacketListener;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.impl.nms.accessors.network.ProtocolInfoAccessor;
import sba.sl.impl.nms.accessors.server.network.ServerCommonPacketListenerImplAccessor;
import sba.sl.impl.nms.accessors.world.entity.decoration.ArmorStandAccessor;
import sba.sl.impl.vanilla.packet.PacketIdMapping;
import sba.sl.impl.vanilla.packet.PacketIdMapping1_20_5;
import sba.sl.p.AbstractPacket;
import sba.sl.p.PacketMapper;
import sba.sl.pa.Players;
import sba.sl.u.Preconditions;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.internal.AccessPluginClasses;
import sba.sl.u.reflect.Reflect;

@Service
@ServiceDependencies(dependsOn={ServerboundInteractPacketListener.class})
@AccessPluginClasses(value={"ViaVersion", "ProtocolSupport"})
public class BukkitPacketMapper
extends PacketMapper {
    @Override
    public void sendPacket0(@NotNull sba.sl.pa.Player player, @NotNull AbstractPacket packet) {
        Preconditions.checkNotNull(packet, "Packet cannot be null!, skipping packet...");
        ByteBuf buffer = Unpooled.buffer();
        try {
            CraftBukkitPacketWriter writer = new CraftBukkitPacketWriter(buffer);
            writer.writeVarInt(packet.getId());
            int dataStartIndex = buffer.writerIndex();
            packet.write(writer);
            if (!writer.isCancelled()) {
                int dataSize = buffer.writerIndex() - dataStartIndex;
                if (dataSize > 0x1FFFFF) {
                    throw new IllegalArgumentException("Packet too big (is " + dataSize + ", should be less than 2097152): " + String.valueOf(packet));
                }
                this.sendRawPacket(player, buffer);
            }
            writer.getAppendedPackets().forEach(extraPacket -> this.sendPacket0(player, (AbstractPacket)extraPacket));
        }
        catch (Throwable t) {
            buffer.release();
            Bukkit.getLogger().severe("An exception occurred serializing packet of class: " + packet.getClass().getSimpleName());
            t.printStackTrace();
        }
    }

    @Override
    public int getId0(Class<? extends AbstractPacket> clazz) {
        @Nullable Integer id = ProtocolInfoAccessor.TYPE.get() != null ? PacketIdMapping1_20_5.getPacketId(clazz) : PacketIdMapping.getPacketId(clazz);
        return id == null ? -1 : id;
    }

    @Override
    public int getArmorStandTypeId0() {
        return ClassStorage.getEntityTypeId("armor_stand", ArmorStandAccessor.TYPE.get());
    }

    @Override
    public int getTextDisplayTypeId0() {
        return ClassStorage.getEntityTypeId("text_display", null);
    }

    @Override
    public int getPlayerTypeId0() {
        return ClassStorage.getEntityTypeId("player", null);
    }

    protected void sendRawPacket(sba.sl.pa.Player player, ByteBuf buffer) {
        Channel channel = Players.getNettyChannel(player);
        if (channel.isActive()) {
            ChannelHandlerContext ctx = channel.pipeline().context("encoder");
            if (Bukkit.getPluginManager().isPluginEnabled("ViaVersion")) {
                UserConnection conn;
                ChannelHandlerContext viaCtx = channel.pipeline().context("via-encoder");
                if (viaCtx != null) {
                    ctx = viaCtx;
                }
                if ((conn = Via.getAPI().getConnection(player.getUuid())) != null) {
                    try {
                        conn.transformClientbound(buffer, CancelEncoderException::generate);
                    }
                    catch (Throwable ex) {
                        if (!(ex instanceof CancelEncoderException)) {
                            ex.printStackTrace();
                        }
                        return;
                    }
                }
            }
            boolean flush = ServerCommonPacketListenerImplAccessor.FIELD_SUSPEND_FLUSHING_ON_SERVER_THREAD.get() != null ? (Boolean)Reflect.getField(ClassStorage.getPlayerConnection(player.as(Player.class)), ServerCommonPacketListenerImplAccessor.FIELD_SUSPEND_FLUSHING_ON_SERVER_THREAD.get()) : true;
            ChannelHandlerContext finalCtx = ctx;
            Runnable task = () -> {
                if (finalCtx != null) {
                    if (flush) {
                        finalCtx.writeAndFlush((Object)buffer);
                    } else {
                        finalCtx.write((Object)buffer);
                    }
                } else if (flush) {
                    channel.writeAndFlush((Object)buffer);
                } else {
                    channel.write((Object)buffer);
                }
            };
            if (channel.eventLoop().inEventLoop()) {
                task.run();
            } else {
                channel.eventLoop().submit(task);
            }
        }
    }

    @Generated
    public BukkitPacketMapper() {
    }
}

